/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.plugin;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.configuration.Constant;
import org.gcube.accounting.aggregator.configuration.ManagementFileBackup;
import org.gcube.accounting.aggregator.madeaggregation.Aggregation;
import org.gcube.accounting.aggregator.madeaggregation.AggregationType;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceBackendQueryConfiguration;
import org.gcube.accounting.aggregator.plugin.AccountingAggregatorPluginDeclaration;
import org.gcube.accounting.aggregator.plugin.DesignID;
import org.gcube.accounting.aggregator.plugin.Utility;
import org.gcube.accounting.aggregator.plugin.WorkSpaceManagement;
import org.gcube.accounting.aggregator.recovery.RecoveryRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.persistence.PersistenceCouchBase;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingAggregatorPlugin
extends Plugin<AccountingAggregatorPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(AccountingAggregatorPlugin.class);
    public Bucket accountingBucket;
    protected Cluster cluster;
    public Aggregation aggregate;
    public static final String AGGREGATED = "aggregated";
    private static final String LINE_FREFIX = "{";
    private static final String LINE_SUFFIX = "}";
    private static final String KEY_VALUE_PAIR_SEPARATOR = ",";
    private static final String KEY_VALUE_LINKER = "=";
    public static Integer countInsert = 0;
    public static Integer countDelete = 0;
    public static Integer RecoveryMode = 0;
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(Constant.CONNECTION_TIMEOUT * 1000).queryTimeout(Constant.CONNECTION_TIMEOUT * 1000).keepAliveInterval(3600000L).build();

    public AccountingAggregatorPlugin(AccountingAggregatorPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        AggregatorPersistenceBackendQueryConfiguration configuration;
        countInsert = 0;
        countDelete = 0;
        if (inputs == null || inputs.isEmpty()) {
            logger.debug("{} inputs {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), inputs);
            throw new Exception("Inputs null");
        }
        if (!inputs.containsKey("type") || !inputs.containsKey("interval")) {
            throw new IllegalArgumentException("Interval and type must be defined");
        }
        AggregationType aggType = AggregationType.valueOf((String)inputs.get("type"));
        Integer interval = (Integer)inputs.get("interval") * aggType.getMultiplierFactor();
        Integer inputStartTime = null;
        if (inputs.containsKey("startTime")) {
            inputStartTime = (Integer)inputs.get("startTime");
        }
        Boolean currentScope = false;
        String scope = null;
        if (inputs.containsKey("currentScope")) {
            currentScope = (Boolean)inputs.get("currentScope");
        }
        if (currentScope.booleanValue()) {
            scope = ScopeProvider.instance.get();
        }
        Constant.user = inputs.containsKey("user") ? (String)inputs.get("user") : "service.aggregatorAccounting";
        if (inputs.containsKey("recovery")) {
            RecoveryMode = (Integer)inputs.get("recovery");
        }
        logger.debug("Launch with Type:{}, Interval:{}, startTime:{}, Scope:{}, Recovery:{}", new Object[]{aggType.toString(), interval, inputStartTime, scope, RecoveryMode});
        String url = null;
        String password = null;
        ArrayList<String> listBucket = new ArrayList<String>();
        try {
            configuration = new AggregatorPersistenceBackendQueryConfiguration(PersistenceCouchBase.class);
            url = configuration.getProperty("URL");
            password = configuration.getProperty("password");
            if (inputs.containsKey("bucket")) {
                listBucket.add(inputs.get("bucket").toString());
            } else {
                listBucket.add(configuration.getProperty("AggregatedStorageUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedServiceUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedJobUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedPortletUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedTaskUsageRecord"));
            }
        }
        catch (Exception e) {
            logger.error("launch", (Object)e.getLocalizedMessage());
            throw e;
        }
        CouchbaseCluster cluster = CouchbaseCluster.create(ENV, url);
        RecordUtility.addRecordPackage((Package)ServiceUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedServiceUsageRecord.class.getPackage());
        this.initFolder();
        if (RecoveryMode == 2 || RecoveryMode == 0) {
            logger.debug("Recovery mode enabled");
            RecoveryRecord.searchFile(cluster, configuration);
        }
        if (RecoveryMode != 2) {
            for (String bucket : listBucket) {
                logger.trace("OpenBucket:{}", (Object)bucket);
                this.accountingBucket = cluster.openBucket(bucket, password);
                this.elaborateBucket(bucket, scope, inputStartTime, interval, aggType);
            }
            logger.debug("Complete countInsert{}, countDelete{}", (Object)countInsert, (Object)countDelete);
        }
    }

    protected void onStop() throws Exception {
        logger.trace("{} onStop() function", (Object)((Object)((Object)this)).getClass().getSimpleName());
        Thread.currentThread().interrupt();
    }

    public void initFolder() {
        Constant.PATH_DIR_BACKUP = System.getProperty("user.home") + "/" + Constant.NAME_DIR_BACKUP;
        Constant.PATH_DIR_BACKUP_INSERT = Constant.PATH_DIR_BACKUP + "/insert";
        Constant.PATH_DIR_BACKUP_DELETE = Constant.PATH_DIR_BACKUP + "/delete";
        File DirRoot = new File(Constant.PATH_DIR_BACKUP);
        if (!DirRoot.exists()) {
            DirRoot.mkdir();
        }
        logger.debug("init folder:{}", (Object)Constant.PATH_DIR_BACKUP);
    }

    protected boolean elaborateBucket(String bucket, String scope, Integer inputStartTime, Integer interval, AggregationType aggType) throws Exception {
        Calendar nowTemp;
        Calendar now;
        SimpleDateFormat format = new SimpleDateFormat(aggType.getDateformat());
        if (inputStartTime == null) {
            now = Calendar.getInstance();
            nowTemp = Calendar.getInstance();
        } else {
            now = Calendar.getInstance();
            nowTemp = Calendar.getInstance();
            switch (aggType.name()) {
                case "YEARLY": {
                    now.add(1, -inputStartTime.intValue());
                    nowTemp.add(1, -inputStartTime.intValue());
                    break;
                }
                case "MONTHLY": {
                    now.add(2, -inputStartTime.intValue());
                    nowTemp.add(2, -inputStartTime.intValue());
                    break;
                }
                case "DAILY": {
                    now.add(5, -inputStartTime.intValue());
                    nowTemp.add(5, -inputStartTime.intValue());
                    break;
                }
                case "HOURLY": {
                    now.add(10, -inputStartTime.intValue());
                    nowTemp.add(10, -inputStartTime.intValue());
                }
            }
        }
        String endAllKeyString = format.format(now.getTime());
        String endKeyString = format.format(now.getTime());
        nowTemp.add(aggType.getCalendarField(), -1 * interval);
        String startAllKeyString = format.format(nowTemp.getTime());
        WorkSpaceManagement.onSaveBackupFile(this.accountingBucket, bucket, scope, startAllKeyString, endAllKeyString, aggType);
        ArrayList<JsonDocument> documentElaborate = new ArrayList<JsonDocument>();
        for (int i = 0; i < interval; ++i) {
            now.add(aggType.getCalendarField(), -1);
            String startKeyString = format.format(now.getTime());
            JsonArray startKey = Utility.generateKey(scope, startKeyString);
            JsonArray endKey = Utility.generateKey(scope, endKeyString);
            DesignID designid = DesignID.valueOf(bucket);
            String designDocId = designid.getNameDesign();
            String viewName = "";
            viewName = scope != null ? designid.getNameViewScope() : designid.getNameView();
            ViewQuery query = ViewQuery.from(designDocId, viewName);
            query.startKey(startKey);
            query.endKey(endKey);
            query.reduce(false);
            query.inclusiveEnd(false);
            logger.debug("View Query: startKey:{} - endKey:{} designDocId:{} - viewName:{}", new Object[]{startKey, endKey, designDocId, viewName});
            ViewResult viewResult = null;
            try {
                viewResult = this.accountingBucket.query(query);
            }
            catch (Exception e) {
                logger.error("ERROR VIEW", (Object)e.getLocalizedMessage());
            }
            this.aggregate = new Aggregation();
            documentElaborate.clear();
            for (ViewRow row : viewResult) {
                this.elaborateRow(row, documentElaborate);
            }
            String nameFileBackup = "";
            nameFileBackup = scope != null ? scope.replace("/", "") + "-" + startKeyString + "-" + endKeyString : startKeyString + "-" + endKeyString;
            this.reallyFlush(this.aggregate, documentElaborate, nameFileBackup);
            endKeyString = startKeyString;
        }
        return true;
    }

    protected boolean elaborateRow(ViewRow row, List<JsonDocument> documentElaborate) throws Exception {
        try {
            String document = row.value().toString().replace("\":", KEY_VALUE_LINKER).replace("\"", "");
            Map<String, ? extends Serializable> map = AccountingAggregatorPlugin.getMapFromString(document);
            AggregatedRecord record = (AggregatedRecord)RecordUtility.getRecord(map);
            this.aggregate.aggregate(record);
            String identifier = (String)((JsonObject)row.document().content()).get("id");
            JsonDocument documentJson = JsonDocument.create(identifier, (JsonObject)row.document().content());
            documentElaborate.add(documentJson);
            return true;
        }
        catch (InvalidValueException ex) {
            logger.warn("Record is not valid. Anyway, it will be persisted");
            return true;
        }
        catch (Exception e) {
            logger.error("Error elaborateRow", (Object)e, (Object)e.getLocalizedMessage());
            return false;
        }
    }

    protected static Map<String, ? extends Serializable> getMapFromString(String serializedMap) {
        if (!serializedMap.startsWith(LINE_FREFIX) && !serializedMap.endsWith(LINE_SUFFIX)) {
            return null;
        }
        serializedMap = serializedMap.replace(LINE_FREFIX, "");
        serializedMap = serializedMap.replace(LINE_SUFFIX, "");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] pairs = serializedMap.split(KEY_VALUE_PAIR_SEPARATOR);
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            pair.trim();
            String[] keyValue = pair.split(KEY_VALUE_LINKER);
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }

    protected boolean reallyFlush(Aggregation aggregate, List<JsonDocument> docs, String nameFile) throws Exception {
        if (docs.size() != 0) {
            Object object;
            Integer n;
            Integer index = 0;
            boolean succesfulDelete = false;
            List<JsonDocument> notDeleted = docs;
            List<JsonDocument> notInserted = aggregate.reallyFlush();
            nameFile = nameFile + "-" + UUID.randomUUID();
            ManagementFileBackup.getInstance().onCreateStringToFile(notDeleted, "no_aggregated_" + nameFile, false);
            ManagementFileBackup.getInstance().onCreateStringToFile(notInserted, "aggregated_" + nameFile, true);
            while (index < Constant.NUM_RETRY && !succesfulDelete) {
                ArrayList<JsonDocument> notDeletedTemp = new ArrayList<JsonDocument>();
                for (JsonDocument doc : notDeleted) {
                    n = countDelete;
                    Integer n2 = countDelete = Integer.valueOf(countDelete + 1);
                    try {
                        this.accountingBucket.remove(doc.id(), PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.trace("doc:{} not deleted retry:{}", (Object)doc.id(), (Object)index);
                        try {
                            if (!this.accountingBucket.exists(doc.id())) continue;
                            notDeletedTemp.add(doc);
                        }
                        catch (Exception ex) {
                            logger.warn("doc:{} not verify for delete", (Object)doc.id());
                        }
                    }
                }
                if (notDeletedTemp.isEmpty()) {
                    succesfulDelete = true;
                    continue;
                }
                Integer n3 = index;
                index = index + 1;
                object = index;
                notDeleted = new ArrayList<JsonDocument>(notDeletedTemp);
                Thread.sleep(1000L);
            }
            if (!succesfulDelete) {
                logger.error("Error Delete record");
            }
            logger.debug("Delete complete {}, Start a insert aggregated document", (Object)countDelete);
            if (succesfulDelete) {
                ManagementFileBackup.getInstance().onDeleteFile("no_aggregated_" + nameFile, false);
                index = 0;
                boolean succesfulInsert = false;
                while (index < Constant.NUM_RETRY && !succesfulInsert) {
                    ArrayList<JsonDocument> notInsertedTemp = new ArrayList<JsonDocument>();
                    for (JsonDocument document : notInserted) {
                        Serializable ex = countInsert;
                        Integer n4 = countInsert = Integer.valueOf(countInsert + 1);
                        try {
                            ex = this.accountingBucket.upsert(document, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            logger.trace("record:{} not insert retry:{} ", (Object)document.id(), (Object)index);
                            try {
                                if (this.accountingBucket.exists(document.id())) continue;
                                notInsertedTemp.add(document);
                            }
                            catch (Exception ex2) {
                                logger.warn("doc:{} not verify for inset", (Object)document.id());
                            }
                        }
                    }
                    if (notInsertedTemp.isEmpty()) {
                        succesfulInsert = true;
                        continue;
                    }
                    object = index;
                    n = index = Integer.valueOf(index + 1);
                    notInserted = new ArrayList<JsonDocument>(notInsertedTemp);
                    Thread.sleep(1000L);
                }
                if (!succesfulInsert) {
                    logger.error("Error Insert record{}");
                } else {
                    logger.debug("elaborate record aggregate:{} and record not aggregate:{}", (Object)countInsert, (Object)countDelete);
                    ManagementFileBackup.getInstance().onDeleteFile("aggregated_" + nameFile, true);
                }
            }
        }
        return true;
    }
}

