/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.util.zip.WorkspaceToZipModelConverter;
import org.gcube.common.homelibrary.util.zip.ZipModelWriter;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);

    public static File zipFolder(WorkspaceFolder folder) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(folder);
    }

    public static File zipDocument(GCubeItem document) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(document);
    }

    public static File zipTimeSeries(TimeSeries ts) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(ts);
    }

    public static File zipFolder(WorkspaceFolder folder, boolean skipRoot, List<String> idsToExclude) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(folder, skipRoot, idsToExclude);
    }

    public static File zipWorkspaceItems(List<WorkspaceItem> items, List<String> idsToExclude) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(items, idsToExclude);
    }

    public static File zipDocument(GCubeItem document, boolean skipRoot) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(document, skipRoot);
    }

    public static File zipTimeSeries(TimeSeries ts, boolean skipRoot) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(ts, skipRoot);
    }

    protected static File zipWorkspaceItem(WorkspaceItem workspaceItem) throws InternalErrorException, IOException {
        logger.trace("Zipping " + workspaceItem.getName());
        File zipFile = File.createTempFile("zippping", "gz");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            ZipUtil.processFolder(workspaceItem, zipOutputStream, workspaceItem.getName());
        }
        return zipFile;
    }

    private static void processFolder(WorkspaceItem myFolder, ZipOutputStream zipOutputStream, String path) throws IOException, InternalErrorException {
        for (WorkspaceItem workspaceItem : myFolder.getChildren()) {
            ZipEntry zipEntry = null;
            if (workspaceItem.isFolder()) {
                zipEntry = new ZipEntry(path + File.separator + workspaceItem.getName() + File.separator);
                zipOutputStream.putNextEntry(zipEntry);
                ZipUtil.processFolder(workspaceItem, zipOutputStream, path + File.separator + workspaceItem.getName());
            } else {
                zipEntry = new ZipEntry(path + File.separator + workspaceItem.getName());
                zipOutputStream.putNextEntry(zipEntry);
                try {
                    ExternalFile externalFile = (ExternalFile)workspaceItem;
                    try (InputStream inputStream = externalFile.getData();){
                        IOUtils.copy(inputStream, (OutputStream)zipOutputStream);
                    }
                }
                catch (Exception e) {
                    logger.error(workspaceItem.getName() + " will not be compressed.");
                }
            }
            zipOutputStream.closeEntry();
        }
    }

    protected static File zipWorkspaceItem(WorkspaceItem workspaceItem, boolean skipRoot) throws InternalErrorException, IOException {
        return ZipUtil.zipWorkspaceItem(workspaceItem, skipRoot, new ArrayList<String>());
    }

    protected static File zipWorkspaceItem(WorkspaceItem workspaceItem, boolean skipRoot, List<String> idsToExclude) throws InternalErrorException, IOException {
        logger.trace("Zipping " + workspaceItem);
        logger.trace("converting to zip model");
        WorkspaceToZipModelConverter zipConverter = new WorkspaceToZipModelConverter();
        ZipItem item = zipConverter.convert(workspaceItem, idsToExclude);
        logger.trace("writing model");
        ZipModelWriter zipModelWriter = new ZipModelWriter();
        File zipFile = zipModelWriter.writeItem(item, skipRoot);
        logger.trace("conversion complete in file " + zipFile.getAbsolutePath());
        return zipFile;
    }

    protected static File zipWorkspaceItem(List<WorkspaceItem> items, List<String> idsToExclude) throws InternalErrorException, IOException {
        logger.trace("Zipping items: " + items.toString());
        logger.trace("converting to zip model");
        WorkspaceToZipModelConverter zipConverter = new WorkspaceToZipModelConverter();
        ZipItem item = zipConverter.convert(items, idsToExclude);
        logger.trace("writing model");
        ZipModelWriter zipModelWriter = new ZipModelWriter();
        File zipFile = zipModelWriter.writeItem(item, false);
        logger.trace("conversion complete in file " + zipFile.getAbsolutePath());
        return zipFile;
    }

    public static void zip(File input, File output, String entryName) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(output));
        ZipEntry zipEntry = new ZipEntry(entryName);
        out.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)out);
        out.closeEntry();
        out.close();
    }
}

