/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.NodeUtil;

public class IndexUtils {
    public static NodeBuilder getOrCreateOakIndex(NodeBuilder root) {
        NodeBuilder index;
        if (!root.hasChildNode("oak:index")) {
            index = root.child("oak:index");
            index.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
        } else {
            index = root.child("oak:index");
        }
        return index;
    }

    public static NodeBuilder createIndexDefinition(@Nonnull NodeBuilder index, @Nonnull String indexDefName, boolean reindex, boolean unique, @Nonnull Collection<String> propertyNames, @Nullable Collection<String> declaringNodeTypeNames) {
        NodeBuilder entry = index.child(indexDefName).setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", "property").setProperty("reindex", reindex);
        if (unique) {
            entry.setProperty("unique", unique);
        }
        entry.setProperty(PropertyStates.createProperty("propertyNames", propertyNames, Type.NAMES));
        if (declaringNodeTypeNames != null && !declaringNodeTypeNames.isEmpty()) {
            entry.setProperty(PropertyStates.createProperty("declaringNodeTypes", declaringNodeTypeNames, Type.NAMES));
        }
        return entry;
    }

    public static void createIndexDefinition(@Nonnull NodeUtil indexNode, @Nonnull String indexDefName, boolean unique, @Nonnull String[] propertyNames, @Nullable String[] declaringNodeTypeNames) throws RepositoryException {
        IndexUtils.createIndexDefinition(indexNode, indexDefName, unique, propertyNames, declaringNodeTypeNames, "property");
    }

    public static void createIndexDefinition(@Nonnull NodeUtil indexNode, @Nonnull String indexDefName, boolean unique, @Nonnull String[] propertyNames, @Nullable String[] declaringNodeTypeNames, @Nonnull String propertyIndexType) throws RepositoryException {
        IndexUtils.createIndexDefinition(indexNode, indexDefName, unique, propertyNames, declaringNodeTypeNames, propertyIndexType, null);
    }

    public static void createReferenceIndex(@Nonnull NodeBuilder index) {
        index.child("reference").setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", "reference");
    }

    public static boolean isIndexNodeType(NodeState state) {
        PropertyState ps = state.getProperty("jcr:primaryType");
        return ps != null && ps.getValue(Type.STRING).equals("oak:QueryIndexDefinition");
    }

    public static boolean isIndexNodeType(NodeState state, String typeIn) {
        if (!IndexUtils.isIndexNodeType(state)) {
            return false;
        }
        PropertyState type = state.getProperty("type");
        return type != null && !type.isArray() && type.getValue(Type.STRING).equals(typeIn);
    }

    public static void createIndexDefinition(@Nonnull NodeUtil indexNode, @Nonnull String indexDefName, boolean unique, @Nonnull String[] propertyNames, @Nullable String[] declaringNodeTypeNames, @Nonnull String propertyIndexType, Map<String, String> properties) throws RepositoryException {
        NodeUtil entry = indexNode.getOrAddChild(indexDefName, "oak:QueryIndexDefinition");
        entry.setString("type", propertyIndexType);
        entry.setBoolean("reindex", true);
        if (unique) {
            entry.setBoolean("unique", true);
        }
        if (declaringNodeTypeNames != null && declaringNodeTypeNames.length > 0) {
            entry.setNames("declaringNodeTypes", declaringNodeTypeNames);
        }
        entry.setNames("propertyNames", propertyNames);
        if (properties != null) {
            for (String k : properties.keySet()) {
                entry.setString(k, properties.get(k));
            }
        }
    }

    public static void createIndexDefinition(@Nonnull NodeBuilder indexNode, @Nonnull String indexDefName, boolean unique, @Nonnull Iterable<String> propertyNames, @Nullable String[] declaringNodeTypeNames, @Nonnull String propertyIndexType, Map<String, String> properties) throws RepositoryException {
        NodeBuilder entry = indexNode.child(indexDefName).setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", propertyIndexType).setProperty("reindex", false);
        if (unique) {
            entry.setProperty("unique", unique);
        }
        entry.setProperty(PropertyStates.createProperty("propertyNames", propertyNames, Type.NAMES));
        if (declaringNodeTypeNames != null && declaringNodeTypeNames.length > 0) {
            entry.setProperty(PropertyStates.createProperty("declaringNodeTypes", declaringNodeTypeNames, Type.NAMES));
        }
        if (properties != null) {
            for (String k : properties.keySet()) {
                entry.setProperty(k, properties.get(k));
            }
        }
    }
}

