/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.user;

import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.security.user.CredentialsImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserAuthentication
implements Authentication {
    static final Credentials PRE_AUTHENTICATED = new Credentials(){};
    private static final Logger log = LoggerFactory.getLogger(UserAuthentication.class);
    private final String userId;
    private final UserManager userManager;

    UserAuthentication(String userId, UserManager userManager) {
        this.userId = userId;
        this.userManager = userManager;
    }

    @Override
    public boolean authenticate(Credentials credentials) throws LoginException {
        if (this.userId == null || this.userManager == null || credentials == null) {
            return false;
        }
        boolean success = false;
        try {
            Authorizable authorizable = this.userManager.getAuthorizable(this.userId);
            if (authorizable == null) {
                return false;
            }
            if (authorizable.isGroup()) {
                throw new LoginException("Not a user " + this.userId);
            }
            User user = (User)authorizable;
            if (user.isDisabled()) {
                throw new LoginException("User with ID " + this.userId + " has been disabled: " + user.getDisabledReason());
            }
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials creds = (SimpleCredentials)credentials;
                Credentials userCreds = user.getCredentials();
                if (this.userId.equals(creds.getUserID()) && userCreds instanceof CredentialsImpl) {
                    success = PasswordUtil.isSame(((CredentialsImpl)userCreds).getPasswordHash(), creds.getPassword());
                }
                UserAuthentication.checkSuccess(success, "UserId/Password mismatch.");
            } else if (credentials instanceof ImpersonationCredentials) {
                ImpersonationCredentials ipCreds = (ImpersonationCredentials)credentials;
                AuthInfo info = ipCreds.getImpersonatorInfo();
                success = this.equalUserId(ipCreds) && this.impersonate(info, user);
                UserAuthentication.checkSuccess(success, "Impersonation not allowed.");
            } else {
                success = credentials instanceof GuestCredentials || credentials == PRE_AUTHENTICATED;
            }
        }
        catch (RepositoryException e) {
            throw new LoginException(e.getMessage());
        }
        return success;
    }

    private static void checkSuccess(boolean success, String msg) throws LoginException {
        if (!success) {
            throw new LoginException(msg);
        }
    }

    private boolean equalUserId(ImpersonationCredentials creds) {
        Credentials base = creds.getBaseCredentials();
        return base instanceof SimpleCredentials && this.userId.equals(((SimpleCredentials)base).getUserID());
    }

    private boolean impersonate(AuthInfo info, User user) {
        try {
            if (user.getID().equals(info.getUserID())) {
                log.debug("User " + info.getUserID() + " wants to impersonate himself -> success.");
                return true;
            }
            log.debug("User " + info.getUserID() + " wants to impersonate " + user.getID());
            Subject subject = new Subject(true, info.getPrincipals(), Collections.emptySet(), Collections.emptySet());
            return user.getImpersonation().allows(subject);
        }
        catch (RepositoryException e) {
            log.debug("Error while validating impersonation", (Object)e.getMessage());
            return false;
        }
    }
}

