/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPConnection;
import org.gcube.contentmanager.storageclient.model.protocol.smp.StringDecrypter;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPURLConnectionOld
extends SMPConnection {
    Logger logger = LoggerFactory.getLogger(SMPURLConnectionOld.class);

    public SMPURLConnectionOld(URL url) {
        super(url);
    }

    @Override
    public SMPConnection init(URL url) {
        return new SMPURLConnectionOld(url);
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.storageClient(this.url.toString());
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    protected InputStream storageClient(String url) throws Exception {
        this.logger.info("url :" + url);
        String[] urlParam = url.split("\\?");
        this.logger.info("String encrypted " + urlParam[1]);
        String param = new StringDecrypter("DES", null).decrypt(urlParam[1]);
        this.logger.info("String decrypted: " + param);
        String[] getParam = param.split("\\&");
        String serviceClass = null;
        String serviceName = null;
        String owner = null;
        String accessType = null;
        String memoryType = null;
        String scopeType = null;
        AccessType type = null;
        MemoryType mType = null;
        String server = null;
        for (String par : getParam) {
            String[] par1;
            if (par.contains("ServiceClass")) {
                par1 = par.split("=");
                serviceClass = par1[1];
                continue;
            }
            if (par.contains("ServiceName")) {
                par1 = par.split("=");
                serviceName = par1[1];
                continue;
            }
            if (par.contains("owner")) {
                par1 = par.split("=");
                owner = par1[1];
                continue;
            }
            if (par.contains("scope")) {
                par1 = par.split("=");
                scopeType = par1[1];
                continue;
            }
            if (par.contains("server")) {
                par1 = par.split("=");
                server = par1[1];
                continue;
            }
            if (par.contains("AccessType")) {
                par1 = par.split("=");
                accessType = par1[1];
                if (accessType.equalsIgnoreCase("public")) {
                    type = AccessType.PUBLIC;
                    continue;
                }
                if (!accessType.equalsIgnoreCase("shared")) continue;
                type = AccessType.SHARED;
                continue;
            }
            if (!par.contains("MemoryType")) continue;
            par1 = par.split("=");
            memoryType = par1[1];
            mType = memoryType.equalsIgnoreCase("VOLATILE") ? MemoryType.VOLATILE : MemoryType.PERSISTENT;
        }
        if (serviceName == null || serviceClass == null || owner == null || scopeType == null || type == null) {
            this.logger.error("Bad Parameter in URI");
            if (type == null) {
                this.logger.error("URI generated from a private file");
                throw new MalformedURLException("The uri is generated from a private file. It cannot be accessed");
            }
            if (serviceName == null) {
                throw new MalformedURLException("The uri generated has an invalid serviceName");
            }
            if (serviceClass == null) {
                throw new MalformedURLException("The uri generated has an invalid serviceClass");
            }
            if (owner == null) {
                throw new MalformedURLException("The uri generated has an invalid owner");
            }
            if (scopeType == null) {
                throw new MalformedURLException("The uri is generated has an invalid scopeType.");
            }
        }
        String location = this.extractLocation(urlParam[0]);
        this.logger.info("Parameters from URI " + serviceClass + " " + serviceName + " " + owner + " " + type + " " + mType + " location: " + urlParam[0] + " scope: " + scopeType);
        IClient client = null;
        String currentScope = ScopeProvider.instance.get();
        this.logger.info("current scope used: " + currentScope + ". scope found on url is: " + scopeType);
        client = mType != null ? (server != null ? new StorageClient(serviceClass, serviceName, owner, type, mType, server).getClient() : new StorageClient(serviceClass, serviceName, owner, type, mType).getClient()) : (server != null ? new StorageClient(serviceClass, serviceName, owner, server, type).getClient() : new StorageClient(serviceClass, serviceName, owner, type).getClient());
        InputStream is = null;
        is = client.get().RFileAsInputStream(location);
        return is;
    }

    private String extractLocation(String url) {
        String[] loc = url.split("//");
        this.logger.info("url extracted: " + loc[1]);
        return loc[1];
    }
}

