/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.ConfigurationKeys;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.HandlerUtil;
import lombok.delombok.LombokOptionsFactory;
import lombok.experimental.Builder;
import lombok.javac.JavacAST;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleConstructor {
    public static List<JavacNode> findRequiredFields(JavacNode typeNode) {
        ListBuffer<JavacNode> fields = new ListBuffer<JavacNode>();
        for (JavacNode child : typeNode.down()) {
            boolean isNonNull;
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
            if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
            boolean isFinal = (fieldFlags & 0x10L) != 0L;
            boolean bl = isNonNull = !JavacHandlerUtil.findAnnotations(child, HandlerUtil.NON_NULL_PATTERN).isEmpty();
            if (!isFinal && !isNonNull || fieldDecl.init != null) continue;
            fields.append(child);
        }
        return fields.toList();
    }

    public static List<JavacNode> findAllFields(JavacNode typeNode) {
        ListBuffer<JavacNode> fields = new ListBuffer<JavacNode>();
        for (JavacNode child : typeNode.down()) {
            boolean isFinal;
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
            if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
            boolean bl = isFinal = (fieldFlags & 0x10L) != 0L;
            if (isFinal && fieldDecl.init != null) continue;
            fields.append(child);
        }
        return fields.toList();
    }

    public static boolean checkLegality(JavacNode typeNode, JavacNode errorNode, String name) {
        boolean notAClass;
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x2200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError(name + " is only supported on a class or an enum.");
            return false;
        }
        return true;
    }

    public void generateRequiredArgsConstructor(JavacNode typeNode, AccessLevel level, String staticName, SkipIfConstructorExists skipIfConstructorExists, JavacNode source) {
        this.generateConstructor(typeNode, level, List.<JCTree.JCAnnotation>nil(), HandleConstructor.findRequiredFields(typeNode), staticName, skipIfConstructorExists, null, source);
    }

    public void generateAllArgsConstructor(JavacNode typeNode, AccessLevel level, String staticName, SkipIfConstructorExists skipIfConstructorExists, JavacNode source) {
        this.generateConstructor(typeNode, level, List.<JCTree.JCAnnotation>nil(), HandleConstructor.findAllFields(typeNode), staticName, skipIfConstructorExists, null, source);
    }

    public void generateConstructor(JavacNode typeNode, AccessLevel level, List<JCTree.JCAnnotation> onConstructor, List<JavacNode> fields, String staticName, SkipIfConstructorExists skipIfConstructorExists, Boolean suppressConstructorProperties, JavacNode source) {
        boolean staticConstrRequired;
        boolean bl = staticConstrRequired = staticName != null && !staticName.equals("");
        if (skipIfConstructorExists != SkipIfConstructorExists.NO && JavacHandlerUtil.constructorExists(typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            return;
        }
        if (skipIfConstructorExists != SkipIfConstructorExists.NO) {
            for (JavacNode child : typeNode.down()) {
                boolean skipGeneration;
                if (child.getKind() != AST.Kind.ANNOTATION) continue;
                boolean bl2 = skipGeneration = JavacHandlerUtil.annotationTypeMatches(NoArgsConstructor.class, child) || JavacHandlerUtil.annotationTypeMatches(AllArgsConstructor.class, child) || JavacHandlerUtil.annotationTypeMatches(RequiredArgsConstructor.class, child);
                if (!skipGeneration && skipIfConstructorExists == SkipIfConstructorExists.YES) {
                    skipGeneration = JavacHandlerUtil.annotationTypeMatches(Builder.class, child);
                }
                if (!skipGeneration) continue;
                if (staticConstrRequired) {
                    source.addWarning("Ignoring static constructor name: explicit @XxxArgsConstructor annotation present; its `staticName` parameter will be used.");
                }
                return;
            }
        }
        JCTree.JCMethodDecl constr = HandleConstructor.createConstructor(staticConstrRequired ? AccessLevel.PRIVATE : level, onConstructor, typeNode, fields, suppressConstructorProperties, source);
        JavacHandlerUtil.injectMethod(typeNode, constr);
        if (staticConstrRequired) {
            JCTree.JCMethodDecl staticConstr = this.createStaticConstructor(staticName, level, typeNode, fields, (JCTree)source.get());
            JavacHandlerUtil.injectMethod(typeNode, staticConstr);
        }
    }

    public static void addConstructorProperties(JCTree.JCModifiers mods, JavacNode node, List<JavacNode> fields) {
        if (fields.isEmpty()) {
            return;
        }
        JavacTreeMaker maker = node.getTreeMaker();
        JCTree.JCExpression constructorPropertiesType = JavacHandlerUtil.chainDots(node, "java", "beans", "ConstructorProperties");
        ListBuffer<JCTree.JCLiteral> fieldNames = new ListBuffer<JCTree.JCLiteral>();
        for (JavacNode field : fields) {
            Name fieldName = JavacHandlerUtil.removePrefixFromField(field);
            fieldNames.append(maker.Literal(fieldName.toString()));
        }
        JCTree.JCNewArray fieldNamesArray = maker.NewArray(null, List.<JCTree.JCExpression>nil(), fieldNames.toList());
        JCTree.JCAnnotation annotation = maker.Annotation(constructorPropertiesType, List.of(fieldNamesArray));
        mods.annotations = mods.annotations.append(annotation);
    }

    public static JCTree.JCMethodDecl createConstructor(AccessLevel level, List<JCTree.JCAnnotation> onConstructor, JavacNode typeNode, List<JavacNode> fields, Boolean suppressConstructorProperties, JavacNode source) {
        boolean isEnum;
        JavacTreeMaker maker = typeNode.getTreeMaker();
        boolean bl = isEnum = (((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x4000L) != 0L;
        if (isEnum) {
            level = AccessLevel.PRIVATE;
        }
        if (suppressConstructorProperties == null) {
            suppressConstructorProperties = fields.isEmpty() ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.TRUE.equals(((JavacAST)typeNode.getAst()).readConfiguration(ConfigurationKeys.ANY_CONSTRUCTOR_SUPPRESS_CONSTRUCTOR_PROPERTIES)));
        }
        ListBuffer<JCTree.JCStatement> nullChecks = new ListBuffer<JCTree.JCStatement>();
        ListBuffer<JCTree.JCExpressionStatement> assigns = new ListBuffer<JCTree.JCExpressionStatement>();
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        for (JavacNode fieldNode : fields) {
            JCTree.JCStatement nullCheck;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            Name fieldName = JavacHandlerUtil.removePrefixFromField(fieldNode);
            Name rawName = field.name;
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, HandlerUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, HandlerUtil.NULLABLE_PATTERN);
            long flags = JavacHandlerUtil.addFinalIfNeeded(0x200000000L, typeNode.getContext());
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(flags, nonNulls.appendList(nullables)), fieldName, field.vartype, null);
            params.append(param);
            JCTree.JCFieldAccess thisX = maker.Select(maker.Ident(fieldNode.toName("this")), rawName);
            JCTree.JCAssign assign = maker.Assign(thisX, maker.Ident(fieldName));
            assigns.append(maker.Exec(assign));
            if (nonNulls.isEmpty() || (nullCheck = JavacHandlerUtil.generateNullCheck(maker, fieldNode, source)) == null) continue;
            nullChecks.append(nullCheck);
        }
        JCTree.JCModifiers mods = maker.Modifiers(JavacHandlerUtil.toJavacModifier(level), List.<JCTree.JCAnnotation>nil());
        if (!suppressConstructorProperties.booleanValue() && level != AccessLevel.PRIVATE && level != AccessLevel.PACKAGE && !HandleConstructor.isLocalType(typeNode) && LombokOptionsFactory.getDelombokOptions(typeNode.getContext()).getFormatPreferences().generateConstructorProperties()) {
            HandleConstructor.addConstructorProperties(mods, typeNode, fields);
        }
        if (onConstructor != null) {
            mods.annotations = mods.annotations.appendList(JavacHandlerUtil.copyAnnotations(onConstructor));
        }
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("<init>"), null, List.<JCTree.JCTypeParameter>nil(), params.toList(), List.<JCTree.JCExpression>nil(), maker.Block(0L, nullChecks.appendList(assigns).toList()), null), (JCTree)source.get(), typeNode.getContext());
    }

    public static boolean isLocalType(JavacNode type) {
        AST.Kind kind = ((JavacNode)type.up()).getKind();
        if (kind == AST.Kind.COMPILATION_UNIT) {
            return false;
        }
        if (kind == AST.Kind.TYPE) {
            return HandleConstructor.isLocalType((JavacNode)type.up());
        }
        return true;
    }

    public JCTree.JCMethodDecl createStaticConstructor(String name, AccessLevel level, JavacNode typeNode, List<JavacNode> fields, JCTree source) {
        JCTree.JCExpression constructorType;
        JCTree.JCExpression returnType2;
        JavacTreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        JCTree.JCModifiers mods = maker.Modifiers(8 | JavacHandlerUtil.toJavacModifier(level));
        ListBuffer<JCTree.JCTypeParameter> typeParams = new ListBuffer<JCTree.JCTypeParameter>();
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        ListBuffer<JCTree.JCIdent> typeArgs1 = new ListBuffer<JCTree.JCIdent>();
        ListBuffer<JCTree.JCIdent> typeArgs2 = new ListBuffer<JCTree.JCIdent>();
        ListBuffer<JCTree.JCIdent> args = new ListBuffer<JCTree.JCIdent>();
        if (!type.typarams.isEmpty()) {
            for (JCTree.JCTypeParameter param : type.typarams) {
                typeArgs1.append(maker.Ident(param.name));
                typeArgs2.append(maker.Ident(param.name));
                typeParams.append(maker.TypeParameter(param.name, param.bounds));
            }
            returnType2 = maker.TypeApply(maker.Ident(type.name), typeArgs1.toList());
            constructorType = maker.TypeApply(maker.Ident(type.name), typeArgs2.toList());
        } else {
            returnType2 = maker.Ident(type.name);
            constructorType = maker.Ident(type.name);
        }
        for (JavacNode fieldNode : fields) {
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            Name fieldName = JavacHandlerUtil.removePrefixFromField(fieldNode);
            JCTree.JCExpression pType = JavacHandlerUtil.cloneType(maker, field.vartype, source, typeNode.getContext());
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, HandlerUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, HandlerUtil.NULLABLE_PATTERN);
            long flags = JavacHandlerUtil.addFinalIfNeeded(0x200000000L, typeNode.getContext());
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(flags, nonNulls.appendList(nullables)), fieldName, pType, null);
            params.append(param);
            args.append(maker.Ident(fieldName));
        }
        JCTree.JCReturn returnStatement = maker.Return(maker.NewClass(null, List.<JCTree.JCExpression>nil(), constructorType, args.toList(), null));
        JCTree.JCBlock body = maker.Block(0L, List.of(returnStatement));
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName(name), returnType2, typeParams.toList(), params.toList(), List.<JCTree.JCExpression>nil(), body, null), source, typeNode.getContext());
    }

    public static enum SkipIfConstructorExists {
        YES,
        NO,
        I_AM_BUILDER;

    }

    public static class HandleAllArgsConstructor
    extends JavacAnnotationHandler<AllArgsConstructor> {
        @Override
        public void handle(AnnotationValues<AllArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandlerUtil.handleFlagUsage(annotationNode, ConfigurationKeys.ALL_ARGS_CONSTRUCTOR_FLAG_USAGE, "@AllArgsConstructor", ConfigurationKeys.ANY_CONSTRUCTOR_FLAG_USAGE, "any @xArgsConstructor");
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, AllArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, AllArgsConstructor.class.getSimpleName())) {
                return;
            }
            List<JCTree.JCAnnotation> onConstructor = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@AllArgsConstructor(onConstructor=", annotationNode);
            AllArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            if (level == AccessLevel.NONE) {
                return;
            }
            String staticName = ann.staticName();
            Boolean suppressConstructorProperties = null;
            if (annotation.isExplicit("suppressConstructorProperties")) {
                boolean suppress = ann.suppressConstructorProperties();
                suppressConstructorProperties = suppress;
            }
            new HandleConstructor().generateConstructor(typeNode, level, onConstructor, HandleConstructor.findAllFields(typeNode), staticName, SkipIfConstructorExists.NO, suppressConstructorProperties, annotationNode);
        }
    }

    public static class HandleRequiredArgsConstructor
    extends JavacAnnotationHandler<RequiredArgsConstructor> {
        @Override
        public void handle(AnnotationValues<RequiredArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandlerUtil.handleFlagUsage(annotationNode, ConfigurationKeys.REQUIRED_ARGS_CONSTRUCTOR_FLAG_USAGE, "@RequiredArgsConstructor", ConfigurationKeys.ANY_CONSTRUCTOR_FLAG_USAGE, "any @xArgsConstructor");
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, RequiredArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, RequiredArgsConstructor.class.getSimpleName())) {
                return;
            }
            List<JCTree.JCAnnotation> onConstructor = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@RequiredArgsConstructor(onConstructor=", annotationNode);
            RequiredArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            if (level == AccessLevel.NONE) {
                return;
            }
            String staticName = ann.staticName();
            Boolean suppressConstructorProperties = null;
            if (annotation.isExplicit("suppressConstructorProperties")) {
                boolean suppress = ann.suppressConstructorProperties();
                suppressConstructorProperties = suppress;
            }
            new HandleConstructor().generateConstructor(typeNode, level, onConstructor, HandleConstructor.findRequiredFields(typeNode), staticName, SkipIfConstructorExists.NO, suppressConstructorProperties, annotationNode);
        }
    }

    public static class HandleNoArgsConstructor
    extends JavacAnnotationHandler<NoArgsConstructor> {
        @Override
        public void handle(AnnotationValues<NoArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            HandlerUtil.handleFlagUsage(annotationNode, ConfigurationKeys.NO_ARGS_CONSTRUCTOR_FLAG_USAGE, "@NoArgsConstructor", ConfigurationKeys.ANY_CONSTRUCTOR_FLAG_USAGE, "any @xArgsConstructor");
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, NoArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, NoArgsConstructor.class.getSimpleName())) {
                return;
            }
            List<JCTree.JCAnnotation> onConstructor = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@NoArgsConstructor(onConstructor=", annotationNode);
            NoArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            if (level == AccessLevel.NONE) {
                return;
            }
            String staticName = ann.staticName();
            List<JavacNode> fields = List.nil();
            new HandleConstructor().generateConstructor(typeNode, level, onConstructor, fields, staticName, SkipIfConstructorExists.NO, null, annotationNode);
        }
    }
}

