/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query.qom;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.Literal;
import org.apache.jackrabbit.oak.jcr.query.qom.QueryObjectModelImpl;
import org.apache.jackrabbit.oak.jcr.query.qom.StaticOperandImpl;

public class LiteralImpl
extends StaticOperandImpl
implements Literal {
    private final Value value;

    public LiteralImpl(Value value) {
        this.value = value;
    }

    @Override
    public Value getLiteralValue() {
        return this.value;
    }

    public String toString() {
        try {
            switch (this.value.getType()) {
                case 2: {
                    return this.cast("BINARY");
                }
                case 6: {
                    return this.cast("BOOLEAN");
                }
                case 5: {
                    return this.cast("DATE");
                }
                case 12: {
                    return this.cast("DECIMAL");
                }
                case 3: 
                case 4: {
                    return this.value.getString();
                }
                case 7: {
                    return this.cast("NAME");
                }
                case 8: {
                    return this.cast("PATH");
                }
                case 9: {
                    return this.cast("REFERENCE");
                }
                case 1: {
                    return LiteralImpl.escape(this.value.getString());
                }
                case 11: {
                    return this.cast("URI");
                }
                case 10: {
                    return this.cast("WEAKREFERENCE");
                }
            }
            return LiteralImpl.escape(this.value.getString());
        }
        catch (RepositoryException e) {
            return this.value.toString();
        }
    }

    private String cast(String type) throws RepositoryException {
        return "CAST(" + LiteralImpl.escape(this.value.getString()) + " AS " + type + ')';
    }

    public static String escape(String v) {
        return '\'' + v.replace("'", "''") + '\'';
    }

    @Override
    public void bindVariables(QueryObjectModelImpl qom) {
    }
}

