/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.aggregate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class AggregateIndexProvider
implements QueryIndexProvider {
    private final QueryIndexProvider baseProvider;

    AggregateIndexProvider(QueryIndexProvider baseProvider) {
        this.baseProvider = baseProvider;
    }

    @Nonnull
    public static QueryIndexProvider wrap(@Nonnull QueryIndexProvider baseProvider) {
        return new AggregateIndexProvider(baseProvider);
    }

    @Override
    @Nonnull
    public List<? extends QueryIndex> getQueryIndexes(NodeState state) {
        List<? extends QueryIndex> list = this.baseProvider.getQueryIndexes(state);
        ArrayList<AggregateIndex> aggregateList = new ArrayList<AggregateIndex>();
        for (int i = 0; i < list.size(); ++i) {
            QueryIndex index = list.get(i);
            if (!(index instanceof QueryIndex.FulltextQueryIndex)) continue;
            aggregateList.add(new AggregateIndex((QueryIndex.FulltextQueryIndex)index));
        }
        return aggregateList;
    }
}

