/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.strategy;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedContentMirrorStoreStrategy
extends ContentMirrorStoreStrategy {
    public static final String NEXT = ":next";
    public static final String START = ":start";
    public static final NodeState EMPTY_START_NODE = EmptyNodeState.EMPTY_NODE.builder().setProperty(":next", "").getNodeState();
    private static final Logger LOG = LoggerFactory.getLogger(OrderedContentMirrorStoreStrategy.class);
    private OrderedIndex.OrderDirection direction = OrderedIndex.DEFAULT_DIRECTION;

    public OrderedContentMirrorStoreStrategy() {
    }

    public OrderedContentMirrorStoreStrategy(OrderedIndex.OrderDirection direction) {
        this();
        this.direction = direction;
    }

    @Override
    NodeBuilder fetchKeyNode(@Nonnull NodeBuilder index, @Nonnull String key) {
        NodeBuilder localkey = null;
        NodeBuilder start = index.child(START);
        String n = start.getString(NEXT);
        if (Strings.isNullOrEmpty(n)) {
            localkey = index.child(key);
            localkey.setProperty(NEXT, "");
            start.setProperty(NEXT, key);
        } else {
            String nextKey = n;
            Iterable<? extends ChildNodeEntry> children = this.getChildNodeEntries(index.getNodeState(), true);
            for (ChildNodeEntry childNodeEntry : children) {
                nextKey = childNodeEntry.getNodeState().getString(NEXT);
                if (Strings.isNullOrEmpty(nextKey)) {
                    index.getChildNode(childNodeEntry.getName()).setProperty(NEXT, key);
                    localkey = index.child(key);
                    localkey.setProperty(NEXT, "");
                    continue;
                }
                if (!this.isInsertHere(key, nextKey)) continue;
                index.getChildNode(childNodeEntry.getName()).setProperty(NEXT, key);
                localkey = index.child(key);
                localkey.setProperty(NEXT, nextKey);
                break;
            }
        }
        return localkey;
    }

    private boolean isInsertHere(@Nonnull String newItemKey, @Nonnull String existingItemKey) {
        if (OrderedIndex.OrderDirection.ASC.equals((Object)this.direction)) {
            return newItemKey.compareTo(existingItemKey) < 0;
        }
        return newItemKey.compareTo(existingItemKey) > 0;
    }

    @Override
    void prune(NodeBuilder index, Deque<NodeBuilder> builders) {
        for (NodeBuilder node : builders) {
            if (node.hasProperty("match") || node.getChildNodeCount(1L) > 0L) {
                return;
            }
            if (!node.exists()) continue;
            if (node.hasProperty(NEXT)) {
                ChildNodeEntry previous = this.findPrevious(index.getNodeState(), node.getNodeState());
                if (previous == null) {
                    LOG.debug("previous not found. Already deleted in the meanwhile. Skipping re-link");
                } else {
                    LOG.debug("previous: {}", (Object)previous);
                    String next = node.getString(NEXT);
                    if (next == null) {
                        next = "";
                    }
                    index.getChildNode(previous.getName()).setProperty(NEXT, next);
                }
            }
            node.remove();
        }
    }

    @Nullable
    ChildNodeEntry findPrevious(@Nonnull NodeState index, @Nonnull NodeState node) {
        ChildNodeEntry previous = null;
        ChildNodeEntry current = null;
        boolean found = false;
        Iterator<? extends ChildNodeEntry> it = this.getChildNodeEntries(index, true).iterator();
        while (!found && it.hasNext()) {
            current = it.next();
            if (previous == null) {
                previous = current;
                continue;
            }
            found = node.equals(current.getNodeState());
            if (found) continue;
            previous = current;
        }
        return found ? previous : null;
    }

    @Override
    @Nonnull
    Iterable<? extends ChildNodeEntry> getChildNodeEntries(@Nonnull NodeState index) {
        return this.getChildNodeEntries(index, false);
    }

    @Nonnull
    Iterable<? extends ChildNodeEntry> getChildNodeEntries(@Nonnull NodeState index, boolean includeStart) {
        Iterable<Object> cne = null;
        NodeState start = index.getChildNode(START);
        cne = (!start.exists() || Strings.isNullOrEmpty(start.getString(NEXT))) && !includeStart ? Collections.emptyList() : new FullIterable(index, includeStart);
        return cne;
    }

    public Iterable<String> query(Filter filter, String indexName, NodeState indexMeta, Filter.PropertyRestriction pr) {
        return this.query(filter, indexName, indexMeta, ":index", pr);
    }

    public Iterable<String> query(Filter filter, String indexName, NodeState indexMeta, String indexStorageNodeName, Filter.PropertyRestriction pr) {
        NodeState index = indexMeta.getChildNode(indexStorageNodeName);
        if (pr.first != null && !pr.first.equals(pr.last)) {
            ChildNodeEntry firstValueableItem = OrderedContentMirrorStoreStrategy.seek(index, new PredicateGreaterThan(pr.first.getValue(Type.STRING), pr.firstIncluding));
            Iterable<String> it = Collections.emptyList();
            if (firstValueableItem != null) {
                SeekedIterable childrenIterable = pr.last == null ? new SeekedIterable(index, firstValueableItem) : new BetweenIterable(index, firstValueableItem, pr.last.getValue(Type.STRING), pr.lastIncluding);
                it = new QueryResultsWrapper(filter, indexName, childrenIterable);
            }
            return it;
        }
        if (pr.last != null && !pr.last.equals(pr.first)) {
            ChildNodeEntry firstValueableItem = OrderedContentMirrorStoreStrategy.seek(index, new PredicateLessThan(pr.last.getValue(Type.STRING), pr.lastIncluding));
            Iterable<String> it = Collections.emptyList();
            if (firstValueableItem != null) {
                it = new QueryResultsWrapper(filter, indexName, new SeekedIterable(index, firstValueableItem));
            }
            return it;
        }
        Iterable<String> values = null;
        return this.query(filter, indexName, indexMeta, values);
    }

    private static String convert(String value) {
        return value.replaceAll("%3A", ":");
    }

    public long count(NodeState indexMeta, Filter.PropertyRestriction pr, int max) {
        long count = 0L;
        NodeState content = indexMeta.getChildNode(":index");
        Filter.PropertyRestriction lpr = pr;
        if (content.exists()) {
            if (lpr == null) {
                lpr = new Filter.PropertyRestriction();
            }
            if (lpr.firstIncluding && lpr.lastIncluding && lpr.first != null && lpr.first.equals(lpr.last)) {
                String value = lpr.first.getValue(Type.STRING);
                NodeState n = content.getChildNode(value);
                if (n.exists()) {
                    ContentMirrorStoreStrategy.CountingNodeVisitor v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(n);
                    count = v.getEstimatedCount();
                }
            } else if (lpr.first == null && lpr.last == null) {
                PropertyState ec = indexMeta.getProperty("entryCount");
                if (ec != null) {
                    count = ec.getValue(Type.LONG);
                } else {
                    ContentMirrorStoreStrategy.CountingNodeVisitor v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(content);
                    count = v.getEstimatedCount();
                }
            } else if (lpr.first != null && !lpr.first.equals(lpr.last) && OrderedIndex.OrderDirection.ASC.equals((Object)this.direction)) {
                ContentMirrorStoreStrategy.CountingNodeVisitor v;
                Iterable<? extends ChildNodeEntry> children = this.getChildNodeEntries(content);
                String value = lpr.first.getValue(Type.STRING);
                int depthTotal = 0;
                for (ChildNodeEntry childNodeEntry : children) {
                    String converted = OrderedContentMirrorStoreStrategy.convert(childNodeEntry.getName());
                    if (value.compareTo(converted) >= 0 && (!lpr.firstIncluding || !value.equals(converted))) continue;
                    v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(content.getChildNode(childNodeEntry.getName()));
                    depthTotal = (int)((long)depthTotal + v.depthTotal);
                    if ((count += (long)v.getCount()) <= (long)max) continue;
                    break;
                }
                v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                v.depthTotal = depthTotal;
                v.count = (int)Math.min(count, Integer.MAX_VALUE);
                count = v.getEstimatedCount();
            } else if (lpr.last != null && !lpr.last.equals(lpr.first) && OrderedIndex.OrderDirection.DESC.equals((Object)this.direction)) {
                ContentMirrorStoreStrategy.CountingNodeVisitor v;
                Iterable<? extends ChildNodeEntry> children = this.getChildNodeEntries(content);
                String value = lpr.last.getValue(Type.STRING);
                int depthTotal = 0;
                for (ChildNodeEntry childNodeEntry : children) {
                    String converted = OrderedContentMirrorStoreStrategy.convert(childNodeEntry.getName());
                    if (value.compareTo(converted) <= 0 && (!lpr.lastIncluding || !value.equals(converted))) continue;
                    v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                    v.visit(content.getChildNode(childNodeEntry.getName()));
                    depthTotal = (int)((long)depthTotal + v.depthTotal);
                    if ((count += (long)v.getCount()) <= (long)max) continue;
                    break;
                }
                v = new ContentMirrorStoreStrategy.CountingNodeVisitor(max);
                v.depthTotal = depthTotal;
                v.count = (int)Math.min(count, Integer.MAX_VALUE);
                count = v.getEstimatedCount();
            }
        }
        return count;
    }

    static ChildNodeEntry seek(@Nonnull NodeState index, @Nonnull Predicate<ChildNodeEntry> condition) {
        FullIterable children = new FullIterable(index, false);
        ChildNodeEntry entry = null;
        for (ChildNodeEntry child : children) {
            if (!condition.apply(child)) continue;
            entry = child;
            break;
        }
        return entry;
    }

    private static class BetweenIterator
    extends SeekedIterator {
        private String lastKey;
        private boolean lastInclude;

        public BetweenIterator(NodeState index, NodeState start, ChildNodeEntry first, String lastKey, boolean lastInclude) {
            super(index, start, first);
            this.lastInclude = lastInclude;
            this.lastKey = lastKey;
        }

        @Override
        public boolean hasNext() {
            boolean next = super.hasNext();
            String name = this.getCurrentName();
            if (name != null && next) {
                name = OrderedContentMirrorStoreStrategy.convert(name);
                next = next && (this.lastKey.compareTo(name) > 0 || this.lastInclude && this.lastKey.equals(name));
            }
            return next;
        }
    }

    private static class BetweenIterable
    extends SeekedIterable {
        private String lastKey;
        private boolean lastInclude;

        public BetweenIterable(NodeState index, ChildNodeEntry first, String lastKey, boolean lastInclude) {
            super(index, first);
            this.lastKey = lastKey;
            this.lastInclude = lastInclude;
        }

        @Override
        public Iterator<ChildNodeEntry> iterator() {
            return new BetweenIterator(this.index, this.start, this.first, this.lastKey, this.lastInclude);
        }
    }

    static class PredicateLessThan
    implements Predicate<ChildNodeEntry> {
        private String searchfor;
        private boolean include;

        public PredicateLessThan(@Nonnull String searchfor) {
            this(searchfor, false);
        }

        public PredicateLessThan(@Nonnull String searchfor, boolean include) {
            this.searchfor = searchfor;
            this.include = include;
        }

        @Override
        public boolean apply(ChildNodeEntry arg0) {
            boolean b = false;
            if (arg0 != null) {
                String name = OrderedContentMirrorStoreStrategy.convert(arg0.getName());
                b = this.searchfor.compareTo(name) > 0 || this.include && this.searchfor.equals(name);
            }
            return b;
        }
    }

    static class PredicateGreaterThan
    implements Predicate<ChildNodeEntry> {
        private String searchfor;
        private boolean include;

        public PredicateGreaterThan(@Nonnull String searchfor) {
            this(searchfor, false);
        }

        public PredicateGreaterThan(@Nonnull String searchfor, boolean include) {
            this.searchfor = searchfor;
            this.include = include;
        }

        @Override
        public boolean apply(ChildNodeEntry arg0) {
            boolean b = false;
            if (arg0 != null) {
                String name = OrderedContentMirrorStoreStrategy.convert(arg0.getName());
                b = this.searchfor.compareTo(name) < 0 || this.include && this.searchfor.equals(name);
            }
            return b;
        }
    }

    static class PredicateEquals
    implements Predicate<ChildNodeEntry> {
        private String searchfor;

        public PredicateEquals(@Nonnull String searchfor) {
            this.searchfor = searchfor;
        }

        @Override
        public boolean apply(ChildNodeEntry arg0) {
            return arg0 != null && this.searchfor.equals(arg0.getName());
        }
    }

    private static class SeekedIterable
    extends FullIterable {
        ChildNodeEntry first;

        public SeekedIterable(NodeState index, ChildNodeEntry first) {
            super(index, false);
            this.first = first;
        }

        @Override
        public Iterator<ChildNodeEntry> iterator() {
            return new SeekedIterator(this.index, this.start, this.first);
        }
    }

    private static class SeekedIterator
    extends FullIterator {
        private boolean firstReturned;
        private ChildNodeEntry first;

        public SeekedIterator(NodeState index, NodeState start, ChildNodeEntry first) {
            super(index, start, false, first.getNodeState());
            this.first = first;
        }

        @Override
        public boolean hasNext() {
            return !this.firstReturned || super.hasNext();
        }

        @Override
        public ChildNodeEntry next() {
            if (this.firstReturned) {
                return super.next();
            }
            this.firstReturned = true;
            return this.first;
        }
    }

    private static class FullIterable
    implements Iterable<ChildNodeEntry> {
        private boolean includeStart;
        NodeState index;
        NodeState start;
        NodeState current;

        public FullIterable(NodeState index, boolean includeStart) {
            this.index = index;
            this.includeStart = includeStart;
            NodeState s = index.getChildNode(OrderedContentMirrorStoreStrategy.START);
            this.start = includeStart && !s.exists() ? EMPTY_START_NODE : s;
            this.current = this.start;
        }

        @Override
        public Iterator<ChildNodeEntry> iterator() {
            return new FullIterator(this.index, this.start, this.includeStart, this.current);
        }
    }

    private static class FullIterator
    implements Iterator<ChildNodeEntry> {
        private boolean includeStart;
        private NodeState start;
        private NodeState current;
        private NodeState index;
        private String currentName;

        public FullIterator(NodeState index, NodeState start, boolean includeStart, NodeState current) {
            this.includeStart = includeStart;
            this.start = start;
            this.current = current;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.includeStart && this.start.equals(this.current) || !this.includeStart && !Strings.isNullOrEmpty(this.current.getString(OrderedContentMirrorStoreStrategy.NEXT));
        }

        @Override
        public ChildNodeEntry next() {
            OrderedChildNodeEntry entry = null;
            if (this.includeStart && this.start.equals(this.current)) {
                entry = new OrderedChildNodeEntry(OrderedContentMirrorStoreStrategy.START, this.current);
                this.includeStart = false;
            } else if (this.hasNext()) {
                this.currentName = this.current.getString(OrderedContentMirrorStoreStrategy.NEXT);
                this.current = this.index.getChildNode(this.currentName);
                entry = new OrderedChildNodeEntry(this.currentName, this.current);
            } else {
                throw new NoSuchElementException();
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        String getCurrentName() {
            return this.currentName;
        }
    }

    private static class QueryResultsWrapper
    implements Iterable<String> {
        private Iterable<ChildNodeEntry> children;
        private String indexName;
        private Filter filter;

        public QueryResultsWrapper(Filter filter, String indexName, Iterable<ChildNodeEntry> children) {
            this.children = children;
            this.indexName = indexName;
            this.filter = filter;
        }

        @Override
        public Iterator<String> iterator() {
            ContentMirrorStoreStrategy.PathIterator pi = new ContentMirrorStoreStrategy.PathIterator(this.filter, this.indexName);
            pi.setPathContainsValue(true);
            pi.enqueue(this.children.iterator());
            return pi;
        }
    }

    private static final class OrderedChildNodeEntry
    extends AbstractChildNodeEntry {
        private final String name;
        private final NodeState state;

        public OrderedChildNodeEntry(@Nonnull String name, @Nonnull NodeState state) {
            this.name = name;
            this.state = state;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public NodeState getNodeState() {
            return this.state;
        }
    }
}

