/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.MoveValidator;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class MoveDetector
implements Validator {
    public static final String SOURCE_PATH = ":source-path";
    private final MoveValidator moveValidator;

    public MoveDetector(MoveValidator moveValidator) {
        this.moveValidator = moveValidator;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.moveValidator.enter(before, after);
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.moveValidator.enter(before, after);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.moveValidator.propertyAdded(after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.moveValidator.propertyChanged(before, after);
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        this.moveValidator.propertyDeleted(before);
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        MoveValidator childDiff;
        PropertyState sourceProperty = after.getProperty(SOURCE_PATH);
        if (sourceProperty != null) {
            String sourcePath = sourceProperty.getValue(Type.STRING);
            this.moveValidator.move(name, sourcePath, after);
        }
        return (childDiff = this.moveValidator.childNodeAdded(name, after)) == null ? null : new MoveDetector(childDiff);
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        MoveValidator childDiff = this.moveValidator.childNodeChanged(name, before, after);
        return childDiff == null ? null : new MoveDetector(childDiff);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        MoveValidator childDiff = this.moveValidator.childNodeDeleted(name, before);
        return childDiff == null ? null : new MoveDetector(childDiff);
    }
}

