/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.Loader;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.internal.AddNodeRequest;
import com.couchbase.client.core.message.internal.AddNodeResponse;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.AddServiceResponse;
import com.couchbase.client.core.service.ServiceType;
import java.net.InetAddress;
import rx.Observable;
import rx.functions.Func1;

public abstract class AbstractLoader
implements Loader {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Loader.class);
    private final ClusterFacade cluster;
    private final CoreEnvironment environment;
    private final ServiceType serviceType;
    private final LoaderType loaderType;

    protected AbstractLoader(LoaderType loaderType, ServiceType serviceType, ClusterFacade cluster, CoreEnvironment environment) {
        this.loaderType = loaderType;
        this.serviceType = serviceType;
        this.cluster = cluster;
        this.environment = environment;
    }

    protected abstract int port();

    protected abstract Observable<String> discoverConfig(String var1, String var2, InetAddress var3);

    @Override
    public Observable<Tuple2<LoaderType, BucketConfig>> loadConfig(InetAddress seedNode, String bucket, String password) {
        LOGGER.debug("Loading Config for bucket {}", (Object)bucket);
        return this.loadConfigAtAddr(seedNode, bucket, password);
    }

    private Observable<Tuple2<LoaderType, BucketConfig>> loadConfigAtAddr(InetAddress node, final String bucket, final String password) {
        return Observable.just(node).flatMap(new Func1<InetAddress, Observable<AddNodeResponse>>(){

            @Override
            public Observable<AddNodeResponse> call(InetAddress address) {
                return AbstractLoader.this.cluster.send(new AddNodeRequest(address));
            }
        }).flatMap(new Func1<AddNodeResponse, Observable<AddServiceResponse>>(){

            @Override
            public Observable<AddServiceResponse> call(AddNodeResponse response) {
                if (!response.status().isSuccess()) {
                    return Observable.error(new IllegalStateException("Could not add node for config loading."));
                }
                LOGGER.debug("Successfully added Node {}", (Object)response.hostname());
                return AbstractLoader.this.cluster.send(new AddServiceRequest(AbstractLoader.this.serviceType, bucket, password, AbstractLoader.this.port(), response.hostname()));
            }
        }).flatMap(new Func1<AddServiceResponse, Observable<String>>(){

            @Override
            public Observable<String> call(AddServiceResponse response) {
                if (!response.status().isSuccess()) {
                    return Observable.error(new IllegalStateException("Could not add service for config loading."));
                }
                LOGGER.debug("Successfully enabled Service {} on Node {}", (Object)AbstractLoader.this.serviceType, (Object)response.hostname());
                return AbstractLoader.this.discoverConfig(bucket, password, response.hostname());
            }
        }).map(new Func1<String, Tuple2<LoaderType, BucketConfig>>(){

            @Override
            public Tuple2<LoaderType, BucketConfig> call(String rawConfig) {
                LOGGER.debug("Got configuration from Service, attempting to parse.");
                BucketConfig config = BucketConfigParser.parse(rawConfig, AbstractLoader.this.env());
                config.password(password);
                return Tuple.create(AbstractLoader.this.loaderType, config);
            }
        });
    }

    protected ClusterFacade cluster() {
        return this.cluster;
    }

    protected CoreEnvironment env() {
        return this.environment;
    }

    protected String replaceHostWildcard(String input, InetAddress hostname) {
        return input.replace("$HOST", hostname.getHostName());
    }
}

