/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PrefetchIterator<K>
implements Iterator<K> {
    private final Iterator<K> it;
    private final long minPrefetch;
    private final long timeout;
    private final long maxPrefetch;
    private boolean prefetchDone;
    private Iterator<K> prefetchIterator;
    private long size;
    private long position;

    PrefetchIterator(Iterator<K> it, long min, long timeout, long max, long size) {
        this.it = it;
        this.minPrefetch = min;
        this.timeout = timeout;
        this.maxPrefetch = max;
        this.size = size;
    }

    @Override
    public boolean hasNext() {
        boolean result;
        if (this.prefetchIterator != null) {
            if (this.prefetchIterator.hasNext()) {
                return true;
            }
            this.prefetchIterator = null;
        }
        if (!(result = this.it.hasNext())) {
            this.size = this.position;
        }
        return result;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.prefetchIterator != null) {
            return this.prefetchIterator.next();
        }
        ++this.position;
        return this.it.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long size() {
        long end;
        if (this.size != -1L || this.prefetchDone || this.position > this.maxPrefetch) {
            return this.size;
        }
        this.prefetchDone = true;
        ArrayList<K> list = new ArrayList<K>();
        if (this.timeout <= 0L) {
            end = 0L;
        } else {
            long nanos = System.nanoTime();
            end = nanos + this.timeout * 1000L * 1000L;
        }
        while (this.position <= this.maxPrefetch && (this.position <= this.minPrefetch || end != 0L && System.nanoTime() <= end)) {
            if (!this.it.hasNext()) {
                this.size = this.position;
                break;
            }
            ++this.position;
            list.add(this.it.next());
        }
        if (list.size() > 0) {
            this.prefetchIterator = list.iterator();
            this.position -= (long)list.size();
        }
        return this.size;
    }
}

