/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ResultImpl;
import org.apache.jackrabbit.oak.query.ResultRowImpl;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionQueryImpl
implements Query {
    private static final Logger LOG = LoggerFactory.getLogger(QueryImpl.class);
    private final boolean unionAll;
    private final Query left;
    private final Query right;
    private ColumnImpl[] columns;
    private OrderingImpl[] orderings;
    private boolean explain;
    private boolean measure;
    private long limit = Long.MAX_VALUE;
    private long offset;
    private long size = -1L;
    private final QueryEngineSettings settings;

    UnionQueryImpl(boolean unionAll, Query left, Query right, QueryEngineSettings settings) {
        this.unionAll = unionAll;
        this.left = left;
        this.right = right;
        this.settings = settings;
    }

    @Override
    public void setExecutionContext(ExecutionContext context) {
        this.left.setExecutionContext(context);
        this.right.setExecutionContext(context);
    }

    @Override
    public void setOrderings(OrderingImpl[] orderings) {
        if (orderings == null) {
            this.left.setOrderings(null);
            this.right.setOrderings(null);
            return;
        }
        OrderingImpl[] l = new OrderingImpl[orderings.length];
        OrderingImpl[] r = new OrderingImpl[orderings.length];
        for (int i = 0; i < orderings.length; ++i) {
            OrderingImpl o = orderings[i];
            l[i] = o.createCopy();
            r[i] = o.createCopy();
        }
        this.left.setOrderings(l);
        this.right.setOrderings(r);
        this.orderings = orderings;
    }

    @Override
    public void setLimit(long limit) {
        this.limit = limit;
        this.left.setLimit(limit);
        this.right.setLimit(limit);
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public void bindValue(String key, PropertyValue value) {
        this.left.bindValue(key, value);
        this.right.bindValue(key, value);
    }

    @Override
    public void setTraversalEnabled(boolean traversal) {
        this.left.setTraversalEnabled(traversal);
        this.right.setTraversalEnabled(traversal);
    }

    @Override
    public void prepare() {
        this.left.prepare();
        this.right.prepare();
    }

    @Override
    public double getEstimatedCost() {
        return this.left.getEstimatedCost() + this.right.getEstimatedCost();
    }

    @Override
    public List<String> getBindVariableNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.left.getBindVariableNames());
        set.addAll(this.right.getBindVariableNames());
        return new ArrayList<String>(set);
    }

    @Override
    public ColumnImpl[] getColumns() {
        return this.left.getColumns();
    }

    @Override
    public String[] getSelectorNames() {
        return this.left.getSelectorNames();
    }

    @Override
    public int getSelectorIndex(String selectorName) {
        return this.left.getSelectorIndex(selectorName);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public void setMeasure(boolean measure) {
        this.left.setMeasure(measure);
        this.right.setMeasure(measure);
        this.measure = measure;
    }

    @Override
    public void init() {
        this.left.init();
        this.right.init();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.left.toString());
        buff.append(" union ");
        if (this.unionAll) {
            buff.append("all ");
        }
        buff.append(this.right.toString());
        if (this.orderings != null) {
            buff.append(" order by ");
            int i = 0;
            for (OrderingImpl o : this.orderings) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(o);
            }
        }
        return buff.toString();
    }

    @Override
    public Result executeQuery() {
        return new ResultImpl(this);
    }

    @Override
    public String getPlan() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.left.getPlan());
        buff.append(" union ");
        if (this.unionAll) {
            buff.append("all ");
        }
        buff.append(this.right.getPlan());
        return buff.toString();
    }

    @Override
    public Tree getTree(String path) {
        return this.left.getTree(path);
    }

    @Override
    public int getColumnIndex(String columnName) {
        if (this.columns == null) {
            this.columns = this.left.getColumns();
        }
        return QueryImpl.getColumnIndex(this.columns, columnName);
    }

    @Override
    public Iterator<ResultRowImpl> getRows() {
        this.prepare();
        if (this.explain) {
            String plan = this.getPlan();
            this.columns = new ColumnImpl[]{new ColumnImpl("explain", "plan", "plan")};
            ResultRowImpl r = new ResultRowImpl(this, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString(plan)}, null, null);
            return Arrays.asList(r).iterator();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("query execute union");
            LOG.debug("query plan {}", (Object)this.getPlan());
        }
        Iterator<ResultRowImpl> it = Iterators.concat(this.left.getRows(), this.right.getRows());
        if (this.measure) {
            return it;
        }
        boolean distinct = !this.unionAll;
        Comparator<ResultRowImpl> orderBy = ResultRowImpl.getComparator(this.orderings);
        it = FilterIterators.newCombinedFilter(it, distinct, this.limit, this.offset, orderBy, this.settings);
        return it;
    }
}

