/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrivilegeBitsProvider
implements PrivilegeConstants {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeBitsProvider.class);
    private final Map<PrivilegeBits, Set<String>> bitsToNames = new HashMap<PrivilegeBits, Set<String>>();
    private final Root root;

    public PrivilegeBitsProvider(Root root) {
        this.root = root;
    }

    @Nonnull
    public Tree getPrivilegesTree() {
        return PrivilegeUtil.getPrivilegesTree(this.root);
    }

    @Nonnull
    public PrivilegeBits getBits(String ... privilegeNames) {
        if (privilegeNames.length == 0) {
            return PrivilegeBits.EMPTY;
        }
        return this.getBits(Arrays.asList(privilegeNames));
    }

    @Nonnull
    public PrivilegeBits getBits(@Nonnull Iterable<String> privilegeNames) {
        if (!privilegeNames.iterator().hasNext()) {
            return PrivilegeBits.EMPTY;
        }
        Tree privilegesTree = this.getPrivilegesTree();
        if (!privilegesTree.exists()) {
            return PrivilegeBits.EMPTY;
        }
        PrivilegeBits bits = PrivilegeBits.getInstance();
        for (String privilegeName : privilegeNames) {
            if (privilegesTree.hasChild(privilegeName)) {
                Tree defTree = privilegesTree.getChild(privilegeName);
                bits.add(PrivilegeBits.getInstance(defTree));
                continue;
            }
            log.debug("Ignoring privilege name " + privilegeName);
        }
        return bits.unmodifiable();
    }

    @Nonnull
    public PrivilegeBits getBits(@Nonnull Privilege[] privileges, final @Nonnull NameMapper nameMapper) {
        return this.getBits(Iterables.transform(Arrays.asList(privileges), new Function<Privilege, String>(){

            @Override
            public String apply(@Nullable Privilege privilege) {
                if (privilege != null) {
                    try {
                        return nameMapper.getOakName(privilege.getName());
                    }
                    catch (RepositoryException e) {
                        log.debug("Unable to resolve OAK name of privilege " + privilege, (Throwable)e);
                    }
                }
                return null;
            }
        }));
    }

    @Nonnull
    public Set<String> getPrivilegeNames(PrivilegeBits privilegeBits) {
        HashSet<String> privilegeNames;
        if (privilegeBits == null || privilegeBits.isEmpty()) {
            return Collections.emptySet();
        }
        PrivilegeBits pb = privilegeBits.unmodifiable();
        if (this.bitsToNames.containsKey(pb)) {
            return this.bitsToNames.get(pb);
        }
        Tree privilegesTree = this.getPrivilegesTree();
        if (!privilegesTree.exists()) {
            return Collections.emptySet();
        }
        if (this.bitsToNames.isEmpty()) {
            for (Tree child : privilegesTree.getChildren()) {
                this.bitsToNames.put(PrivilegeBits.getInstance(child), Collections.singleton(child.getName()));
            }
        }
        if (this.bitsToNames.containsKey(pb)) {
            privilegeNames = this.bitsToNames.get(pb);
        } else {
            privilegeNames = new HashSet();
            HashSet<String> aggregates = new HashSet<String>();
            for (Tree child : privilegesTree.getChildren()) {
                PrivilegeBits bits = PrivilegeBits.getInstance(child);
                if (!pb.includes(bits)) continue;
                privilegeNames.add(child.getName());
                if (!child.hasProperty("rep:aggregates")) continue;
                aggregates.addAll(PrivilegeUtil.readDefinition(child).getDeclaredAggregateNames());
            }
            privilegeNames.removeAll(aggregates);
            this.bitsToNames.put(pb, ImmutableSet.copyOf(privilegeNames));
        }
        return privilegeNames;
    }
}

