/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.handlers;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import lombok.AllArgsConstructor;
import lombok.ConfigurationKeys;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.Value;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.JavaIdentifiers;
import lombok.core.LombokNode;
import lombok.core.configuration.ConfigurationKey;
import lombok.core.configuration.FlagUsageType;
import lombok.experimental.Accessors;
import lombok.experimental.FieldDefaults;
import lombok.experimental.Wither;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerUtil {
    public static final List<Class<? extends Annotation>> INVALID_ON_BUILDERS = Collections.unmodifiableList(Arrays.asList(Getter.class, Setter.class, Wither.class, ToString.class, EqualsAndHashCode.class, RequiredArgsConstructor.class, AllArgsConstructor.class, NoArgsConstructor.class, Data.class, Value.class, lombok.experimental.Value.class, FieldDefaults.class));
    public static final Pattern NON_NULL_PATTERN = Pattern.compile("^(?:nonnull)$", 2);
    public static final Pattern NULLABLE_PATTERN = Pattern.compile("^(?:nullable|checkfornull)$", 2);
    public static final String DEFAULT_EXCEPTION_FOR_NON_NULL = "java.lang.NullPointerException";

    private HandlerUtil() {
    }

    public static int primeForHashcode() {
        return 59;
    }

    public static int primeForTrue() {
        return 79;
    }

    public static int primeForFalse() {
        return 97;
    }

    public static boolean checkName(String nameSpec, String identifier, LombokNode<?, ?, ?> errorNode) {
        if (identifier.isEmpty()) {
            errorNode.addError(nameSpec + " cannot be the empty string.");
            return false;
        }
        if (!JavaIdentifiers.isValidJavaIdentifier(identifier)) {
            errorNode.addError(nameSpec + " must be a valid java identifier.");
            return false;
        }
        return true;
    }

    public static void handleFlagUsage(LombokNode<?, ?, ?> node, ConfigurationKey<FlagUsageType> key, String featureName) {
        FlagUsageType fut = ((AST)node.getAst()).readConfiguration(key);
        if (fut != null) {
            String msg = "Use of " + featureName + " is flagged according to lombok configuration.";
            if (fut == FlagUsageType.WARNING) {
                node.addWarning(msg);
            } else {
                node.addError(msg);
            }
        }
    }

    public static void handleExperimentalFlagUsage(LombokNode<?, ?, ?> node, ConfigurationKey<FlagUsageType> key, String featureName) {
        HandlerUtil.handleFlagUsage(node, key, featureName, ConfigurationKeys.EXPERIMENTAL_FLAG_USAGE, "any lombok.experimental feature");
    }

    public static void handleFlagUsage(LombokNode<?, ?, ?> node, ConfigurationKey<FlagUsageType> key1, String featureName1, ConfigurationKey<FlagUsageType> key2, String featureName2) {
        FlagUsageType fut1 = ((AST)node.getAst()).readConfiguration(key1);
        FlagUsageType fut2 = ((AST)node.getAst()).readConfiguration(key2);
        FlagUsageType fut = null;
        String featureName = null;
        if (fut1 == FlagUsageType.ERROR) {
            fut = fut1;
            featureName = featureName1;
        } else if (fut2 == FlagUsageType.ERROR) {
            fut = fut2;
            featureName = featureName2;
        } else if (fut1 == FlagUsageType.WARNING) {
            fut = fut1;
            featureName = featureName1;
        } else {
            fut = fut2;
            featureName = featureName2;
        }
        if (fut != null) {
            String msg = "Use of " + featureName + " is flagged according to lombok configuration.";
            if (fut == FlagUsageType.WARNING) {
                node.addWarning(msg);
            } else {
                node.addError(msg);
            }
        }
    }

    public static boolean shouldReturnThis0(AnnotationValues<Accessors> accessors, AST<?, ?, ?> ast) {
        Boolean fluentConfig;
        Boolean chainConfig;
        boolean chainForced = accessors.isExplicit("chain");
        boolean fluentForced = accessors.isExplicit("fluent");
        Accessors instance = accessors.getInstance();
        boolean chain = instance.chain();
        boolean fluent = instance.fluent();
        if (chainForced) {
            return chain;
        }
        if (!chainForced && (chainConfig = ast.readConfiguration(ConfigurationKeys.ACCESSORS_CHAIN)) != null) {
            return chainConfig;
        }
        if (!fluentForced && (fluentConfig = ast.readConfiguration(ConfigurationKeys.ACCESSORS_FLUENT)) != null) {
            fluent = fluentConfig;
        }
        return chain || fluent;
    }

    public static CharSequence removePrefix(CharSequence fieldName, List<String> prefixes) {
        if (prefixes == null || prefixes.isEmpty()) {
            return fieldName;
        }
        fieldName = fieldName.toString();
        block0: for (String prefix : prefixes) {
            if (prefix.length() == 0) {
                return fieldName;
            }
            if (fieldName.length() <= prefix.length()) continue;
            for (int i = 0; i < prefix.length(); ++i) {
                if (fieldName.charAt(i) != prefix.charAt(i)) continue block0;
            }
            char followupChar = fieldName.charAt(prefix.length());
            if (Character.isLetter(prefix.charAt(prefix.length() - 1)) && Character.isLowerCase(followupChar)) continue;
            return "" + Character.toLowerCase(followupChar) + fieldName.subSequence(prefix.length() + 1, fieldName.length());
        }
        return null;
    }

    public static String toGetterName(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return HandlerUtil.toAccessorName(ast, accessors, fieldName, isBoolean, "is", "get", true);
    }

    public static String toSetterName(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return HandlerUtil.toAccessorName(ast, accessors, fieldName, isBoolean, "set", "set", true);
    }

    public static String toWitherName(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return HandlerUtil.toAccessorName(ast, accessors, fieldName, isBoolean, "with", "with", false);
    }

    private static String toAccessorName(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean, String booleanPrefix, String normalPrefix, boolean adhereToFluent) {
        if ((fieldName = fieldName.toString()).length() == 0) {
            return null;
        }
        if (Boolean.TRUE.equals(ast.readConfiguration(ConfigurationKeys.GETTER_CONSEQUENT_BOOLEAN))) {
            isBoolean = false;
        }
        boolean explicitPrefix = accessors != null && accessors.isExplicit("prefix");
        boolean explicitFluent = accessors != null && accessors.isExplicit("fluent");
        Accessors ac = explicitPrefix || explicitFluent ? accessors.getInstance() : null;
        List<String> prefix = explicitPrefix ? Arrays.asList(ac.prefix()) : ast.readConfiguration(ConfigurationKeys.ACCESSORS_PREFIX);
        boolean fluent = explicitFluent ? ac.fluent() : Boolean.TRUE.equals(ast.readConfiguration(ConfigurationKeys.ACCESSORS_FLUENT));
        if ((fieldName = HandlerUtil.removePrefix(fieldName, prefix)) == null) {
            return null;
        }
        String fName = fieldName.toString();
        if (adhereToFluent && fluent) {
            return fName;
        }
        if (isBoolean && fName.startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
            return booleanPrefix + fName.substring(2);
        }
        return HandlerUtil.buildName(isBoolean ? booleanPrefix : normalPrefix, fName);
    }

    public static List<String> toAllGetterNames(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return HandlerUtil.toAllAccessorNames(ast, accessors, fieldName, isBoolean, "is", "get", true);
    }

    public static List<String> toAllSetterNames(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return HandlerUtil.toAllAccessorNames(ast, accessors, fieldName, isBoolean, "set", "set", true);
    }

    public static List<String> toAllWitherNames(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return HandlerUtil.toAllAccessorNames(ast, accessors, fieldName, isBoolean, "with", "with", false);
    }

    private static List<String> toAllAccessorNames(AST<?, ?, ?> ast, AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean, String booleanPrefix, String normalPrefix, boolean adhereToFluent) {
        if (Boolean.TRUE.equals(ast.readConfiguration(ConfigurationKeys.GETTER_CONSEQUENT_BOOLEAN))) {
            isBoolean = false;
        }
        if (!isBoolean) {
            String accessorName = HandlerUtil.toAccessorName(ast, accessors, fieldName, false, booleanPrefix, normalPrefix, adhereToFluent);
            return accessorName == null ? Collections.emptyList() : Collections.singletonList(accessorName);
        }
        boolean explicitPrefix = accessors != null && accessors.isExplicit("prefix");
        boolean explicitFluent = accessors != null && accessors.isExplicit("fluent");
        Accessors ac = explicitPrefix || explicitFluent ? accessors.getInstance() : null;
        List<String> prefix = explicitPrefix ? Arrays.asList(ac.prefix()) : ast.readConfiguration(ConfigurationKeys.ACCESSORS_PREFIX);
        boolean fluent = explicitFluent ? ac.fluent() : Boolean.TRUE.equals(ast.readConfiguration(ConfigurationKeys.ACCESSORS_FLUENT));
        if ((fieldName = HandlerUtil.removePrefix(fieldName, prefix)) == null) {
            return Collections.emptyList();
        }
        List<String> baseNames = HandlerUtil.toBaseNames(fieldName, isBoolean, fluent);
        HashSet<String> names = new HashSet<String>();
        for (String baseName : baseNames) {
            if (adhereToFluent && fluent) {
                names.add(baseName);
                continue;
            }
            names.add(HandlerUtil.buildName(normalPrefix, baseName));
            if (normalPrefix.equals(booleanPrefix)) continue;
            names.add(HandlerUtil.buildName(booleanPrefix, baseName));
        }
        return new ArrayList<String>(names);
    }

    private static List<String> toBaseNames(CharSequence fieldName, boolean isBoolean, boolean fluent) {
        ArrayList<String> baseNames = new ArrayList<String>();
        baseNames.add(fieldName.toString());
        String fName = fieldName.toString();
        if (fName.startsWith("is") && fName.length() > 2 && !Character.isLowerCase(fName.charAt(2))) {
            String baseName = fName.substring(2);
            if (fluent) {
                baseNames.add("" + Character.toLowerCase(baseName.charAt(0)) + baseName.substring(1));
            } else {
                baseNames.add(baseName);
            }
        }
        return baseNames;
    }

    private static String buildName(String prefix, String suffix) {
        if (suffix.length() == 0) {
            return prefix;
        }
        if (prefix.length() == 0) {
            return suffix;
        }
        char first = suffix.charAt(0);
        if (Character.isLowerCase(first)) {
            boolean useUpperCase = suffix.length() > 2 && (Character.isTitleCase(suffix.charAt(1)) || Character.isUpperCase(suffix.charAt(1)));
            suffix = String.format("%s%s", Character.valueOf(useUpperCase ? Character.toUpperCase(first) : Character.toTitleCase(first)), suffix.subSequence(1, suffix.length()));
        }
        return String.format("%s%s", prefix, suffix);
    }
}

