/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;

class Branch {
    private final ConcurrentSkipListMap<Revision, BranchCommit> commits;
    private final Revision base;

    Branch(@Nonnull SortedSet<Revision> commits, @Nonnull Revision base) {
        Preconditions.checkArgument(!Preconditions.checkNotNull(base).isBranch(), "base is not a trunk revision: %s", base);
        this.base = base;
        this.commits = new ConcurrentSkipListMap(commits.comparator());
        for (Revision r : commits) {
            this.commits.put(r.asBranchRevision(), new BranchCommit(base));
        }
    }

    @Nonnull
    Revision getBase() {
        return this.base;
    }

    @Nonnull
    Revision getBase(@Nonnull Revision r) {
        BranchCommit c = this.commits.get(Preconditions.checkNotNull(r).asBranchRevision());
        if (c == null) {
            throw new IllegalArgumentException("Revision " + r + " is not a commit in this branch");
        }
        return c.getBase();
    }

    void rebase(@Nonnull Revision head, @Nonnull Revision base) {
        Preconditions.checkArgument(Preconditions.checkNotNull(head).isBranch(), "Not a branch revision: %s", head);
        Preconditions.checkArgument(!Preconditions.checkNotNull(base).isBranch(), "Not a trunk revision: %s", base);
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument(this.commits.comparator().compare(head, last) > 0);
        BranchCommit bc = new BranchCommit(base);
        for (BranchCommit c : this.commits.values()) {
            c.getModifications().applyTo(bc.getModifications(), head);
        }
        this.commits.put(head, bc);
    }

    void addCommit(@Nonnull Revision r) {
        Preconditions.checkArgument(Preconditions.checkNotNull(r).isBranch(), "Not a branch revision: %s", r);
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument(this.commits.comparator().compare(r, last) > 0);
        this.commits.put(r, new BranchCommit(this.commits.get(last).getBase()));
    }

    SortedSet<Revision> getCommits() {
        return this.commits.keySet();
    }

    boolean hasCommits() {
        return !this.commits.isEmpty();
    }

    boolean containsCommit(@Nonnull Revision r) {
        return this.commits.containsKey(Preconditions.checkNotNull(r).asBranchRevision());
    }

    public void removeCommit(@Nonnull Revision r) {
        Preconditions.checkArgument(Preconditions.checkNotNull(r).isBranch(), "Not a branch revision: %s", r);
        this.commits.remove(r);
    }

    @Nonnull
    public UnsavedModifications getModifications(@Nonnull Revision r) {
        Preconditions.checkArgument(Preconditions.checkNotNull(r).isBranch(), "Not a branch revision: %s", r);
        BranchCommit c = this.commits.get(r);
        if (c == null) {
            throw new IllegalArgumentException("Revision " + r + " is not a commit in this branch");
        }
        return c.getModifications();
    }

    public void applyTo(@Nonnull UnsavedModifications trunk, @Nonnull Revision mergeCommit) {
        Preconditions.checkNotNull(trunk);
        for (BranchCommit c : this.commits.values()) {
            c.getModifications().applyTo(trunk, mergeCommit);
        }
    }

    @CheckForNull
    public Revision getUnsavedLastRevision(String path, Revision readRevision) {
        readRevision = readRevision.asBranchRevision();
        for (Revision r : this.commits.descendingKeySet()) {
            BranchCommit c;
            Revision modRevision;
            if (readRevision.compareRevisionTime(r) < 0 || (modRevision = (c = this.commits.get(r)).getModifications().get(path)) == null) continue;
            return modRevision;
        }
        return null;
    }

    public boolean isHead(@Nonnull Revision rev) {
        Preconditions.checkArgument(Preconditions.checkNotNull(rev).isBranch(), "Not a branch revision: %s", rev);
        return Preconditions.checkNotNull(rev).equals(this.commits.lastKey());
    }

    private static final class BranchCommit {
        private final UnsavedModifications modifications = new UnsavedModifications();
        private final Revision base;

        BranchCommit(Revision base) {
            this.base = base;
        }

        Revision getBase() {
            return this.base;
        }

        UnsavedModifications getModifications() {
            return this.modifications;
        }
    }
}

