/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class DocumentRootBuilder
extends MemoryNodeBuilder {
    static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 10000);
    protected final DocumentNodeStore store;
    @Nonnull
    private NodeState base;
    private DocumentNodeStoreBranch branch;
    private int updates;

    DocumentRootBuilder(@Nonnull DocumentNodeState base, @Nonnull DocumentNodeStore store) {
        super(Preconditions.checkNotNull(base));
        this.store = Preconditions.checkNotNull(store);
        this.base = base;
        this.branch = store.createBranch(base);
    }

    @Override
    @Nonnull
    public NodeState getBaseState() {
        return this.base;
    }

    @Override
    public void reset(@Nonnull NodeState newBase) {
        this.base = Preconditions.checkNotNull(newBase);
        super.reset(newBase);
    }

    @Override
    protected DocumentNodeBuilder createChildBuilder(String name) {
        return new DocumentNodeBuilder(this, name, this);
    }

    @Override
    protected void updated() {
        if (this.updates++ > UPDATE_LIMIT) {
            this.purge();
        }
    }

    @Override
    @Nonnull
    public NodeState getNodeState() {
        if (DocumentNodeStoreBranch.getCurrentBranch() != null) {
            this.purge();
            return this.branch.getHead();
        }
        return super.getNodeState();
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        return this.store.createBlob(stream);
    }

    NodeState rebase() {
        NodeState head = super.getNodeState();
        NodeState inMemBase = super.getBaseState();
        this.branch.rebase();
        super.reset(this.branch.getHead());
        head.compareAgainstBaseState(inMemBase, new ConflictAnnotatingRebaseDiff(this));
        this.base = this.branch.getBase();
        return super.getNodeState();
    }

    NodeState reset() {
        this.branch = this.store.createBranch(this.store.getRoot());
        NodeState head = this.branch.getHead();
        this.reset(head);
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeState merge(CommitHook hook, CommitInfo info) throws CommitFailedException {
        this.purge();
        boolean success = false;
        try {
            this.branch.merge(hook, info);
            success = true;
        }
        finally {
            if (!success) {
                super.reset(this.branch.getHead());
                this.base = this.branch.getBase();
            }
        }
        return this.reset();
    }

    boolean move(String source, String target) {
        this.purge();
        boolean success = this.branch.move(source, target);
        super.reset(this.branch.getHead());
        return success;
    }

    boolean copy(String source, String target) {
        this.purge();
        boolean success = this.branch.copy(source, target);
        super.reset(this.branch.getHead());
        return success;
    }

    private void purge() {
        this.branch.setRoot(super.getNodeState());
        super.reset(this.branch.getHead());
        this.updates = 0;
    }
}

