/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBBlobStore
extends CachingBlobStore
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RDBBlobStore.class);
    private Exception callStack;
    private DataSource ds;
    private long minLastModified;

    public RDBBlobStore(DataSource ds) {
        try {
            this.initialize(ds);
        }
        catch (Exception ex) {
            throw new MicroKernelException("initializing RDB blob store", ex);
        }
    }

    @Override
    public void close() {
        this.ds = null;
    }

    public void finalize() {
        if (this.ds != null && this.callStack != null) {
            LOG.debug("finalizing RDBDocumentStore that was not disposed", (Throwable)this.callStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataSource ds) throws Exception {
        this.ds = ds;
        Connection con = ds.getConnection();
        con.setAutoCommit(false);
        for (String tableName : new String[]{"DATASTORE_META", "DATASTORE_DATA"}) {
            try {
                PreparedStatement stmt = con.prepareStatement("select ID from " + tableName + " where ID = ?");
                stmt.setString(1, "0");
                stmt.executeQuery();
            }
            catch (SQLException ex) {
                con.rollback();
                String dbtype = con.getMetaData().getDatabaseProductName();
                LOG.info("Attempting to create table " + tableName + " in " + dbtype);
                Statement stmt = con.createStatement();
                if (tableName.equals("DATASTORE_META")) {
                    stmt.execute("create table " + tableName + " (ID varchar(1000) not null primary key, LEVEL int, LASTMOD bigint)");
                } else if ("PostgreSQL".equals(dbtype)) {
                    stmt.execute("create table " + tableName + " (ID varchar(1000) not null primary key, DATA bytea)");
                } else if ("DB2".equals(dbtype) || dbtype != null && dbtype.startsWith("DB2/")) {
                    stmt.execute("create table " + tableName + " (ID varchar(1000) not null primary key, DATA blob)");
                } else {
                    stmt.execute("create table " + tableName + " (ID varchar(1000) not null primary key, DATA blob)");
                }
                stmt.close();
                con.commit();
            }
        }
        this.callStack = LOG.isDebugEnabled() ? new Exception("call stack of RDBBlobStore creation") : null;
    }

    @Override
    protected void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        try {
            this.storeBlockInDatabase(digest, level, data);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBlockInDatabase(byte[] digest, int level, byte[] data) throws SQLException {
        block17: {
            String id = StringUtils.convertBytesToHex(digest);
            this.cache.put(id, data);
            Connection con = this.ds.getConnection();
            try {
                int count;
                long now = System.currentTimeMillis();
                PreparedStatement prep = con.prepareStatement("update datastore_meta set lastMod = ? where id = ?");
                try {
                    prep.setLong(1, now);
                    prep.setString(2, id);
                    count = prep.executeUpdate();
                }
                finally {
                    prep.close();
                }
                if (count != 0) break block17;
                try {
                    prep = con.prepareStatement("insert into datastore_data(id, data) values(?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setBytes(2, data);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    prep = con.prepareStatement("insert into datastore_meta(id, level, lastMod) values(?, ?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setInt(2, level);
                        prep.setLong(3, now);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            finally {
                con.commit();
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex(blockId.getDigest());
        byte[] data = (byte[])this.cache.get(id);
        Connection con = this.ds.getConnection();
        try {
            PreparedStatement prep = con.prepareStatement("select data from datastore_data where id = ?");
            try {
                prep.setString(1, id);
                ResultSet rs = prep.executeQuery();
                if (!rs.next()) {
                    throw new IOException("Datastore block " + id + " not found");
                }
                data = rs.getBytes(1);
            }
            finally {
                prep.close();
            }
            this.cache.put(id, data);
        }
        finally {
            con.commit();
            con.close();
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    @Override
    public void startMark() throws IOException {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        Connection con = this.ds.getConnection();
        try {
            if (this.minLastModified == 0L) {
                return;
            }
            String id = StringUtils.convertBytesToHex(blockId.getDigest());
            PreparedStatement prep = con.prepareStatement("update datastore_meta set lastMod = ? where id = ? and lastMod < ?");
            prep.setLong(1, System.currentTimeMillis());
            prep.setString(2, id);
            prep.setLong(3, this.minLastModified);
            prep.executeUpdate();
            prep.close();
        }
        finally {
            con.commit();
            con.close();
        }
    }

    @Override
    public int sweep() throws IOException {
        try {
            return this.sweepFromDatabase();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sweepFromDatabase() throws SQLException {
        Connection con = this.ds.getConnection();
        try {
            int count = 0;
            PreparedStatement prep = con.prepareStatement("select id from datastore_meta where lastMod < ?");
            prep.setLong(1, this.minLastModified);
            ResultSet rs = prep.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            prep = con.prepareStatement("delete from datastore_meta where id = ?");
            PreparedStatement prepData = con.prepareStatement("delete from datastore_data where id = ?");
            for (String id : ids) {
                prep.setString(1, id);
                prep.execute();
                prepData.setString(1, id);
                prepData.execute();
                ++count;
            }
            prepData.close();
            prep.close();
            this.minLastModified = 0L;
            int n = count;
            return n;
        }
        finally {
            con.commit();
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        Connection con = this.ds.getConnection();
        try {
            PreparedStatement prep = null;
            PreparedStatement prepData = null;
            StringBuilder inClause = new StringBuilder();
            int batch = chunkIds.size();
            for (int i = 0; i < batch; ++i) {
                inClause.append('?');
                if (i == batch - 1) continue;
                inClause.append(',');
            }
            if (maxLastModifiedTime > 0L) {
                prep = con.prepareStatement("delete from datastore_meta where id in (" + inClause.toString() + ") and lastMod <= ?");
                prep.setLong(batch + 1, maxLastModifiedTime);
                prepData = con.prepareStatement("delete from datastore_data where id in (" + inClause.toString() + ") and lastMod <= ?");
                prepData.setLong(batch + 1, maxLastModifiedTime);
            } else {
                prep = con.prepareStatement("delete from datastore_meta where id in (" + inClause.toString() + ")");
                prepData = con.prepareStatement("delete from datastore_data where id in (" + inClause.toString() + ")");
            }
            for (int idx = 0; idx < batch; ++idx) {
                prep.setString(idx + 1, chunkIds.get(idx));
                prepData.setString(idx + 1, chunkIds.get(idx));
            }
            prep.execute();
            prepData.execute();
            prep.close();
            prepData.close();
        }
        finally {
            con.commit();
            con.close();
        }
        return true;
    }

    @Override
    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        return new ChunkIdIterator(this.ds, maxLastModifiedTime);
    }

    private static class ChunkIdIterator
    extends AbstractIterator<String> {
        private long maxLastModifiedTime;
        private DataSource ds;
        private static int BATCHSIZE = 262144;
        private List<String> results = new LinkedList<String>();
        private String lastId = null;

        public ChunkIdIterator(DataSource ds, long maxLastModifiedTime) {
            this.maxLastModifiedTime = maxLastModifiedTime;
            this.ds = ds;
        }

        @Override
        protected String computeNext() {
            if (!this.results.isEmpty()) {
                return this.results.remove(0);
            }
            if (this.refill()) {
                return this.computeNext();
            }
            return (String)this.endOfData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean refill() {
            boolean bl;
            StringBuffer query = new StringBuffer();
            query.append("select id from datastore_meta");
            if (this.maxLastModifiedTime > 0L) {
                query.append(" where lastMod <= ?");
                if (this.lastId != null) {
                    query.append(" and id > ?");
                }
            } else if (this.lastId != null) {
                query.append(" where id > ?");
            }
            query.append(" order by id limit " + BATCHSIZE);
            Connection connection = null;
            connection = this.ds.getConnection();
            try {
                PreparedStatement prep = connection.prepareStatement(query.toString());
                int idx = 1;
                if (this.maxLastModifiedTime > 0L) {
                    prep.setLong(idx++, this.maxLastModifiedTime);
                }
                if (this.lastId != null) {
                    prep.setString(idx++, this.lastId);
                }
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    this.lastId = rs.getString(1);
                    this.results.add(this.lastId);
                }
                bl = !this.results.isEmpty();
            }
            catch (Throwable throwable) {
                try {
                    connection.commit();
                    connection.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    try {
                        if (connection != null) {
                            connection.rollback();
                            connection.close();
                        }
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    return false;
                }
            }
            connection.commit();
            connection.close();
            return bl;
        }
    }
}

