/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthentication.class);
    private final TokenProvider tokenProvider;
    private TokenInfo tokenInfo;

    TokenAuthentication(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @Override
    public boolean authenticate(Credentials credentials) throws LoginException {
        if (this.tokenProvider != null && credentials instanceof TokenCredentials) {
            TokenCredentials tc = (TokenCredentials)credentials;
            if (!this.validateCredentials(tc)) {
                throw new LoginException("Invalid token credentials.");
            }
            return true;
        }
        return false;
    }

    @Nonnull
    TokenInfo getTokenInfo() {
        if (this.tokenInfo == null) {
            throw new IllegalStateException("Token info can only be retrieved after successful authentication.");
        }
        return this.tokenInfo;
    }

    private boolean validateCredentials(TokenCredentials tokenCredentials) {
        String token = tokenCredentials.getToken();
        this.tokenInfo = this.tokenProvider.getTokenInfo(token);
        if (this.tokenInfo == null) {
            log.debug("No valid TokenInfo for token.");
            return false;
        }
        long loginTime = new Date().getTime();
        if (this.tokenInfo.isExpired(loginTime)) {
            log.debug("Token is expired");
            this.tokenInfo.remove();
            return false;
        }
        if (this.tokenInfo.matches(tokenCredentials)) {
            this.tokenInfo.resetExpiration(loginTime);
            return true;
        }
        return false;
    }
}

