/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.security.user.query.ConditionVisitor;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;

interface Condition {
    public void accept(ConditionVisitor var1) throws RepositoryException;

    public static class Or
    extends Compound {
        public Or(Condition condition1, Condition condition2) {
            super(condition1, condition2);
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static class And
    extends Compound {
        public And(Condition condition1, Condition condition2) {
            super(condition1, condition2);
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static abstract class Compound
    implements Condition,
    Iterable<Condition> {
        private final List<Condition> conditions = new ArrayList<Condition>();

        public Compound(Condition condition1, Condition condition2) {
            this.conditions.add(condition1);
            this.conditions.add(condition2);
        }

        @Override
        public Iterator<Condition> iterator() {
            return this.conditions.iterator();
        }
    }

    public static class Not
    implements Condition {
        private final Condition condition;

        public Not(Condition condition) {
            this.condition = condition;
        }

        public Condition getCondition() {
            return this.condition;
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static class Impersonation
    implements Condition {
        private final String name;

        public Impersonation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void accept(ConditionVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Contains
    implements Condition {
        private final String relPath;
        private final String searchExpr;

        public Contains(String relPath, String searchExpr) {
            this.relPath = relPath;
            this.searchExpr = searchExpr;
        }

        public String getRelPath() {
            return this.relPath;
        }

        public String getSearchExpr() {
            return this.searchExpr;
        }

        @Override
        public void accept(ConditionVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Property
    implements Condition {
        private final String relPath;
        private final RelationOp op;
        private final Value value;
        private final String pattern;

        public Property(String relPath, RelationOp op, Value value) {
            this.relPath = relPath;
            this.op = op;
            this.value = value;
            this.pattern = null;
        }

        public Property(String relPath, RelationOp op, String pattern) {
            this.relPath = relPath;
            this.op = op;
            this.value = null;
            this.pattern = pattern;
        }

        public Property(String relPath, RelationOp op) {
            this.relPath = relPath;
            this.op = op;
            this.value = null;
            this.pattern = null;
        }

        public String getRelPath() {
            return this.relPath;
        }

        public RelationOp getOp() {
            return this.op;
        }

        public Value getValue() {
            return this.value;
        }

        public String getPattern() {
            return this.pattern;
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static class Node
    implements Condition {
        private final String pattern;

        public Node(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }
}

