/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRGCubeItem
extends JCRWorkspaceFolderItem
implements GCubeItem {
    public JCRGCubeItem(JCRWorkspace workspace, ItemDelegate node, String name, String description, List<String> scopes, String creator, String itemType, Map<String, String> properties) throws RepositoryException, ItemNotFoundException {
        super(workspace, node, name, description);
        Validate.notNull(scopes, "scopes must be not null");
        Validate.notEmpty(scopes, "scopes must be not empty");
        Validate.notNull(creator, "creator must be not null");
        Validate.notNull(itemType, "item type must be not null");
        this.delegate.setProperties(new HashMap<NodeProperty, String>());
        this.delegate.getProperties().put(NodeProperty.CREATOR, creator);
        this.delegate.getProperties().put(NodeProperty.ITEM_TYPE, itemType);
        this.delegate.getProperties().put(NodeProperty.SCOPES, new XStream().toXML(scopes));
        this.delegate.setMetadata(properties);
        this.delegate.getProperties().put(NodeProperty.IS_SHARED, new XStream().toXML(false));
    }

    public JCRGCubeItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    @Override
    public List<String> getScopes() throws InternalErrorException {
        return (List)new XStream().fromXML(this.delegate.getProperties().get((Object)NodeProperty.SCOPES));
    }

    @Override
    public String getItemType() {
        return this.delegate.getProperties().get((Object)NodeProperty.ITEM_TYPE);
    }

    @Override
    public String getCreator() {
        return this.delegate.getProperties().get((Object)NodeProperty.CREATOR);
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.GCUBE_ITEM;
    }

    @Override
    public boolean isShared() throws InternalErrorException {
        return this.delegate.isShared();
    }

    @Override
    public WorkspaceSharedFolder share(List<String> users) throws InternalErrorException {
        WorkspaceSharedFolder folder = null;
        try {
            folder = this.workspace.shareFolder(users, this.getId());
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
        return folder;
    }

    public void setSharedRootId(String id) {
        Map<NodeProperty, String> properties = this.delegate.getProperties();
        properties.put(NodeProperty.SHARED_ROOT_ID, id);
        properties.put(NodeProperty.IS_SHARED, new XStream().toXML(true));
        this.delegate.setProperties(properties);
    }

    @Override
    public ItemDelegate save() throws RepositoryException {
        return super.save();
    }

    @Override
    public String getIdSharedFolder() throws InternalErrorException {
        JCRSession servlets = null;
        ItemDelegate item = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            item = servlets.getItemById(this.getId());
        }
        catch (ItemNotFoundException e) {
            logger.error("impossible to retrieve item id: " + this.getId());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
        return item.getProperties().get((Object)NodeProperty.SHARED_ROOT_ID);
    }

    @Override
    public InputStream getData() throws InternalErrorException {
        InputStream stream = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            ItemDelegate node = servlets.getItemById(this.delegate.getId());
            String remotePath = null;
            String storageID = null;
            try {
                storageID = node.getProperties().get((Object)NodeProperty.STORAGE_ID);
            }
            catch (Exception e) {
                logger.trace("Storage ID not found");
                try {
                    remotePath = node.getProperties().get((Object)NodeProperty.REMOTE_STORAGE_PATH);
                }
                catch (Exception e1) {
                    InputStream inputStream = null;
                    servlets.releaseSession();
                    return inputStream;
                }
            }
            if (storageID != null) {
                remotePath = storageID;
            }
            if (remotePath != null) {
                logger.trace("Content retrieved from remote storage...");
                try {
                    stream = this.workspace.getStorage().getRemoteFile(remotePath);
                }
                catch (Exception e) {
                    logger.error("no payload for " + this.getName());
                }
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
        return stream;
    }

    @Override
    public String getRemotePath() throws InternalErrorException {
        String remotePath = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            ItemDelegate node = servlets.getItemById(this.delegate.getId());
            remotePath = node.getProperties().get((Object)NodeProperty.REMOTE_STORAGE_PATH);
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
        return remotePath;
    }

    @Override
    public long getLength() throws InternalErrorException {
        return 0L;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }
}

