/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.GlobalNameMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapperImpl;
import org.apache.jackrabbit.oak.plugins.name.ReadWriteNamespaceRegistry;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;

class BuiltInNodeTypes {
    private final NodeTypeManager ntMgr;
    private final NamespaceRegistry nsReg;
    private final ValueFactory vf;

    private BuiltInNodeTypes(final Root root) {
        this.ntMgr = new ReadWriteNodeTypeManager(){

            @Override
            protected Tree getTypes() {
                return root.getTree("/jcr:system/jcr:nodeTypes");
            }

            @Override
            @Nonnull
            protected Root getWriteRoot() {
                return root;
            }
        };
        this.nsReg = new ReadWriteNamespaceRegistry(root){

            @Override
            protected Root getWriteRoot() {
                return root;
            }
        };
        this.vf = new ValueFactoryImpl(root, new NamePathMapperImpl(new GlobalNameMapper(root)));
    }

    public static void register(Root root) {
        new BuiltInNodeTypes(root).registerBuiltinNodeTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBuiltinNodeTypes() {
        try {
            InputStream stream = BuiltInNodeTypes.class.getResourceAsStream("builtin_nodetypes.cnd");
            try {
                CndImporter.registerNodeTypes(new InputStreamReader(stream, Charsets.UTF_8), "built-in node types", this.ntMgr, this.nsReg, this.vf, false);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read built-in node types", e);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Unable to parse built-in node types", e);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Unable to register built-in node types", e);
        }
    }
}

