/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;

class MapEntry
extends AbstractChildNodeEntry
implements Map.Entry<RecordId, RecordId>,
Comparable<MapEntry> {
    private final String name;
    private final RecordId key;
    private final RecordId value;

    MapEntry(String name, RecordId key, RecordId value) {
        this.name = Preconditions.checkNotNull(name);
        this.key = Preconditions.checkNotNull(key);
        this.value = value;
    }

    public int getHash() {
        return MapRecord.getHash(this.name);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public SegmentNodeState getNodeState() {
        Preconditions.checkState(this.value != null);
        return new SegmentNodeState(this.value);
    }

    @Override
    public RecordId getKey() {
        return this.key;
    }

    @Override
    public RecordId getValue() {
        return this.value;
    }

    @Override
    public RecordId setValue(RecordId value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(MapEntry that) {
        return ComparisonChain.start().compare((long)this.getHash() & 0xFFFFFFFFL, (long)that.getHash() & 0xFFFFFFFFL).compare((Comparable<?>)((Object)this.name), (Comparable<?>)((Object)that.name)).compare(this.value, that.value).result();
    }
}

