/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ACE;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ACL
extends AbstractAccessControlList {
    private static final Logger log = LoggerFactory.getLogger(ACL.class);
    private final List<ACE> entries = new ArrayList<ACE>();

    ACL(@Nullable String oakPath, @Nullable List<ACE> entries, @Nonnull NamePathMapper namePathMapper) {
        super(oakPath, namePathMapper);
        if (entries != null) {
            this.entries.addAll(entries);
        }
    }

    abstract ACE createACE(Principal var1, PrivilegeBits var2, boolean var3, Set<Restriction> var4) throws RepositoryException;

    abstract void checkValidPrincipal(Principal var1) throws AccessControlException;

    abstract PrivilegeManager getPrivilegeManager();

    abstract PrivilegeBits getPrivilegeBits(Privilege[] var1);

    @Nonnull
    public List<ACE> getEntries() {
        return this.entries;
    }

    @Override
    public void removeAccessControlEntry(AccessControlEntry ace) throws RepositoryException {
        ACE entry = ACL.checkACE(ace);
        if (!this.entries.remove(entry)) {
            throw new AccessControlException("Cannot remove AccessControlEntry " + ace);
        }
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions) throws RepositoryException {
        Set<Restriction> rs;
        if (privileges == null || privileges.length == 0) {
            throw new AccessControlException("Privileges may not be null nor an empty array");
        }
        for (Privilege p : privileges) {
            Privilege pv = this.getPrivilegeManager().getPrivilege(p.getName());
            if (!pv.isAbstract()) continue;
            throw new AccessControlException("Privilege " + p + " is abstract.");
        }
        this.checkValidPrincipal(principal);
        for (RestrictionDefinition def : this.getRestrictionProvider().getSupportedRestrictions(this.getOakPath())) {
            String jcrName = this.getNamePathMapper().getJcrName(def.getName());
            if (!def.isMandatory() || restrictions != null && restrictions.containsKey(jcrName)) continue;
            throw new AccessControlException("Mandatory restriction " + jcrName + " is missing.");
        }
        if (restrictions == null && mvRestrictions == null) {
            rs = Collections.emptySet();
        } else {
            String oakName;
            rs = new HashSet();
            if (restrictions != null) {
                for (String jcrName : restrictions.keySet()) {
                    oakName = this.getNamePathMapper().getOakName(jcrName);
                    rs.add(this.getRestrictionProvider().createRestriction(this.getOakPath(), oakName, restrictions.get(oakName)));
                }
            }
            if (mvRestrictions != null) {
                for (String jcrName : mvRestrictions.keySet()) {
                    oakName = this.getNamePathMapper().getOakName(jcrName);
                    rs.add(this.getRestrictionProvider().createRestriction(this.getOakPath(), oakName, mvRestrictions.get(oakName)));
                }
            }
        }
        ACE entry = this.createACE(principal, this.getPrivilegeBits(privileges), isAllow, rs);
        if (this.entries.contains(entry)) {
            log.debug("Entry is already contained in policy -> no modification.");
            return false;
        }
        return this.internalAddEntry(entry);
    }

    @Override
    public void orderBefore(AccessControlEntry srcEntry, AccessControlEntry destEntry) throws RepositoryException {
        int index;
        ACE dest;
        ACE src = ACL.checkACE(srcEntry);
        ACE aCE = dest = destEntry == null ? null : ACL.checkACE(destEntry);
        if (src.equals(dest)) {
            log.debug("'srcEntry' equals 'destEntry' -> no reordering required.");
            return;
        }
        int n = index = dest == null ? this.entries.size() - 1 : this.entries.indexOf(dest);
        if (index < 0) {
            throw new AccessControlException("'destEntry' not contained in this AccessControlList.");
        }
        if (!this.entries.remove(src)) {
            throw new AccessControlException("srcEntry not contained in this AccessControlList");
        }
        this.entries.add(index, src);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ACL: ").append(this.getPath()).append("; ACEs: ");
        for (AccessControlEntry accessControlEntry : this.entries) {
            sb.append(accessControlEntry.toString()).append(';');
        }
        return sb.toString();
    }

    private static ACE checkACE(AccessControlEntry entry) throws AccessControlException {
        if (!(entry instanceof ACE)) {
            throw new AccessControlException("Invalid access control entry.");
        }
        return (ACE)entry;
    }

    private boolean internalAddEntry(@Nonnull ACE entry) throws RepositoryException {
        final Principal principal = entry.getPrincipal();
        ArrayList<ACE> subList = Lists.newArrayList(Iterables.filter(this.entries, new Predicate<ACE>(){

            @Override
            public boolean apply(@Nullable ACE ace) {
                return ace != null && ace.getPrincipal().getName().equals(principal.getName());
            }
        }));
        for (ACE existing : subList) {
            PrivilegeBits existingBits = PrivilegeBits.getInstance(existing.getPrivilegeBits());
            PrivilegeBits entryBits = entry.getPrivilegeBits();
            if (!entry.getRestrictions().equals(existing.getRestrictions())) continue;
            if (entry.isAllow() == existing.isAllow()) {
                if (existingBits.includes(entryBits)) {
                    return false;
                }
                existingBits.add(entryBits);
                int index = this.entries.indexOf(existing);
                this.entries.remove(existing);
                this.entries.add(index, this.createACE(existing, existingBits));
                return true;
            }
            PrivilegeBits updated = PrivilegeBits.getInstance(existingBits).diff(entryBits);
            if (updated.isEmpty()) {
                this.entries.remove(existing);
                continue;
            }
            if (updated.includes(existingBits)) continue;
            int index = this.entries.indexOf(existing);
            this.entries.remove(existing);
            this.entries.add(index, this.createACE(existing, updated));
        }
        this.entries.add(entry);
        return true;
    }

    private ACE createACE(@Nonnull ACE existing, @Nonnull PrivilegeBits newPrivilegeBits) throws RepositoryException {
        return this.createACE(existing.getPrincipal(), newPrivilegeBits, existing.isAllow(), existing.getRestrictions());
    }
}

