/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.UserContext;
import org.apache.jackrabbit.oak.security.user.UserImporter;
import org.apache.jackrabbit.oak.security.user.UserInitializer;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.security.user.UserValidatorProvider;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;

@Component
@Service(value={UserConfiguration.class, SecurityConfiguration.class})
public class UserConfigurationImpl
extends ConfigurationBase
implements UserConfiguration,
SecurityConfiguration {
    public UserConfigurationImpl() {
    }

    public UserConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.user"));
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Override
    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.user";
    }

    @Override
    @Nonnull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return new UserInitializer(this.getSecurityProvider());
    }

    @Override
    @Nonnull
    public List<? extends ValidatorProvider> getValidators(String workspaceName, Set<Principal> principals, MoveTracker moveTracker) {
        return Collections.singletonList(new UserValidatorProvider(this.getParameters()));
    }

    @Override
    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new UserImporter(this.getParameters()));
    }

    @Override
    @Nonnull
    public Context getContext() {
        return UserContext.getInstance();
    }

    @Override
    @Nonnull
    public UserManager getUserManager(Root root, NamePathMapper namePathMapper) {
        UserManagerImpl umgr = new UserManagerImpl(root, namePathMapper, this.getSecurityProvider());
        if (this.getParameters().getConfigValue("supportAutoSave", false).booleanValue()) {
            return new AutoSaveEnabledManager(umgr, root);
        }
        return umgr;
    }
}

