/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.home.workspace.events.filter;

import java.util.LinkedList;
import java.util.List;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.events.WorkspaceEvent;
import org.gcube.common.homelibrary.home.workspace.events.filter.WorkspaceEventFilterCriteria;

public class WorkspaceEventFilterByParentId
implements WorkspaceEventFilterCriteria {
    protected List<String> acceptedParentIds = new LinkedList<String>();

    public void addParentId(String parentId) {
        this.acceptedParentIds.add(parentId);
    }

    public void removeParentId(String parentId) {
        this.acceptedParentIds.remove(parentId);
    }

    @Override
    public boolean accept(WorkspaceEvent event) {
        try {
            WorkspaceFolder parent = event.getTarget().getParent();
            if (parent != null) {
                return this.acceptedParentIds.contains(parent.getId());
            }
            return false;
        }
        catch (InternalErrorException e) {
            return false;
        }
    }
}

