/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Frame;
import java.io.IOException;

public class MeasurementsWriter
implements PlugIn {
    public void run(String path) {
        this.save(path);
    }

    public boolean save(String path) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextWindow tw = (TextWindow)frame;
            return tw.getTextPanel().saveAs(path);
        }
        if (IJ.isResultsWindow()) {
            TextPanel tp = IJ.getTextPanel();
            if (tp != null && !tp.saveAs(path)) {
                return false;
            }
        } else {
            ResultsTable rt = ResultsTable.getResultsTable();
            if (rt == null || rt.getCounter() == 0) {
                frame = WindowManager.getFrame("Results");
                if (frame == null || !(frame instanceof TextWindow)) {
                    return false;
                }
                TextWindow tw = (TextWindow)frame;
                return tw.getTextPanel().saveAs(path);
            }
            if (path.equals("")) {
                SaveDialog sd = new SaveDialog("Save as Text", "Results", Prefs.get("options.ext", ".xls"));
                String file = sd.getFileName();
                if (file == null) {
                    return false;
                }
                path = sd.getDirectory() + file;
            }
            try {
                rt.saveAs(path);
            }
            catch (IOException e) {
                IJ.error("" + e);
            }
        }
        return true;
    }
}

