/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.macro.Tokenizer;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class ImageMath
implements ExtendedPlugInFilter,
DialogListener {
    public static final String MACRO_KEY = "math.macro";
    private int flags = 16810079;
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private double lower = -1.0;
    private double upper = -1.0;
    private static double addValue = 25.0;
    private static double mulValue = 1.25;
    private static double minValue = 0.0;
    private static double maxValue = 255.0;
    private static final String defaultAndValue = "11110000";
    private static String andValue = "11110000";
    private static final double defaultGammaValue = 0.5;
    private static double gammaValue = 0.5;
    private static String macro = Prefs.get("math.macro", "v=v+50*sin(d/10)");
    private String macro2;
    private PlugInFilterRunner pfr;
    private GenericDialog gd;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(ImageMath.class);
        return this.flags;
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            ip.add(addValue);
        } else if (this.arg.equals("sub")) {
            ip.subtract(addValue);
        } else if (this.arg.equals("mul")) {
            ip.multiply(mulValue);
        } else if (this.arg.equals("div")) {
            if (mulValue == 0.0 && this.imp.getBitDepth() != 32) {
                return;
            }
            ip.multiply(1.0 / mulValue);
        } else if (this.arg.equals("and")) {
            try {
                ip.and(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
        } else if (this.arg.equals("or")) {
            try {
                ip.or(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
        } else if (this.arg.equals("xor")) {
            try {
                ip.xor(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
        } else if (this.arg.equals("min")) {
            ip.min(minValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
        } else if (this.arg.equals("max")) {
            ip.max(maxValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
        } else if (this.arg.equals("gamma")) {
            if ((gammaValue < 0.1 || gammaValue > 5.0) && !this.previewing()) {
                IJ.error("Gamma must be between 0.1 and 5.0");
                gammaValue = 0.5;
            }
            ip.gamma(gammaValue);
        } else if (this.arg.equals("set")) {
            boolean rgb = ip instanceof ColorProcessor;
            if (rgb) {
                if (addValue > 255.0) {
                    addValue = 255.0;
                }
                if (addValue < 0.0) {
                    addValue = 0.0;
                }
                int ival = (int)addValue;
                ip.setValue(ival + (ival << 8) + (ival << 16));
            } else {
                ip.setValue(addValue);
            }
            ip.fill();
        } else if (this.arg.equals("log")) {
            ip.log();
        } else if (this.arg.equals("exp")) {
            ip.exp();
        } else if (this.arg.equals("sqr")) {
            ip.sqr();
        } else if (this.arg.equals("sqrt")) {
            ip.sqrt();
        } else if (this.arg.equals("reciprocal")) {
            if (!this.isFloat(ip)) {
                return;
            }
            float[] pixels = (float[])ip.getPixels();
            for (int i = 0; i < ip.getWidth() * ip.getHeight(); ++i) {
                pixels[i] = pixels[i] == 0.0f ? Float.NaN : 1.0f / pixels[i];
            }
            ip.resetMinAndMax();
        } else if (this.arg.equals("nan")) {
            this.setBackgroundToNaN(ip);
        } else if (this.arg.equals("abs")) {
            if (!(ip instanceof FloatProcessor) && !this.imp.getCalibration().isSigned16Bit()) {
                IJ.error("32-bit or signed 16-bit image required");
                this.canceled = true;
            } else {
                ip.abs();
                ip.resetMinAndMax();
            }
        } else if (this.arg.equals("macro")) {
            this.applyMacro(ip);
        }
    }

    boolean previewing() {
        return this.gd != null && this.gd.getPreviewCheckbox().getState();
    }

    boolean isFloat(ImageProcessor ip) {
        if (!(ip instanceof FloatProcessor)) {
            IJ.error("32-bit float image required");
            this.canceled = true;
            return false;
        }
        return true;
    }

    void getValue(String title, String prompt, double defaultValue, int digits) {
        int places = Analyzer.getPrecision();
        if (digits > 0 || (double)((int)defaultValue) != defaultValue) {
            digits = Math.max(places, 1);
        }
        this.gd = new GenericDialog(title);
        this.gd.addNumericField(prompt, defaultValue, digits, 8, null);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void getBinaryValue(String title, String prompt, String defaultValue) {
        this.gd = new GenericDialog(title);
        this.gd.addStringField(prompt, defaultValue);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void getGammaValue(double defaultValue) {
        this.gd = new GenericDialog("Gamma");
        this.gd.addSlider("Value:", 0.05, 5.0, defaultValue);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void setBackgroundToNaN(ImageProcessor ip) {
        if (this.lower == -1.0 && this.upper == -1.0) {
            this.lower = ip.getMinThreshold();
            this.upper = ip.getMaxThreshold();
            if (this.lower == -808080.0 || !(ip instanceof FloatProcessor)) {
                IJ.error("Thresholded 32-bit float image required");
                this.canceled = true;
                return;
            }
        }
        float[] pixels = (float[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double v = pixels[y * width + x];
                if (!(v < this.lower) && !(v > this.upper)) continue;
                pixels[y * width + x] = Float.NaN;
            }
        }
        ip.resetMinAndMax();
    }

    private void applyMacro(ImageProcessor ip) {
        if (this.macro2 == null) {
            return;
        }
        if (this.macro2.indexOf("=") == -1) {
            IJ.error("The variable 'v' must be assigned a value (e.g., \"v=255-v\")");
            this.canceled = true;
            return;
        }
        macro = this.macro2;
        ip.setSliceNumber(this.pfr.getSliceNumber());
        boolean showProgress = this.pfr.getSliceNumber() == 1 && !Interpreter.isBatchMode();
        ImageMath.applyMacro(ip, macro, showProgress);
        if (this.pfr.getSliceNumber() == 1) {
            ip.resetMinAndMax();
        }
    }

    public static void applyMacro(ImageProcessor ip, String macro, boolean showProgress) {
        ImagePlus temp = WindowManager.getTempCurrentImage();
        WindowManager.setTempCurrentImage(new ImagePlus("", ip));
        int PCStart = 23;
        Program pgm = new Tokenizer().tokenize(macro);
        boolean hasX = pgm.hasWord("x");
        boolean hasA = pgm.hasWord("a");
        boolean hasD = pgm.hasWord("d");
        boolean hasGetPixel = pgm.hasWord("getPixel");
        int w = ip.getWidth();
        int h = ip.getHeight();
        int w2 = w / 2;
        int h2 = h / 2;
        String code = "var v,x,y,z,w,h,d,a;\nfunction dummy() {}\n" + macro + ";\n";
        Interpreter interp = new Interpreter();
        interp.run(code, null);
        if (interp.wasError()) {
            WindowManager.setTempCurrentImage(temp);
            return;
        }
        Prefs.set(MACRO_KEY, macro);
        interp.setVariable("w", w);
        interp.setVariable("h", h);
        interp.setVariable("z", ip.getSliceNumber() - 1);
        int bitDepth = ip.getBitDepth();
        Rectangle r = ip.getRoi();
        int inc = r.height / 50;
        if (inc < 1) {
            inc = 1;
        }
        if (bitDepth == 8) {
            byte[] pixels1;
            byte[] pixels2 = pixels1 = (byte[])ip.getPixels();
            if (hasGetPixel) {
                pixels2 = new byte[w * h];
            }
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    int index = y * w + x;
                    double v = pixels1[index] & 0xFF;
                    interp.setVariable("v", v);
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    interp.run(PCStart);
                    int v2 = (int)interp.getVariable("v");
                    if (v2 < 0) {
                        v2 = 0;
                    }
                    if (v2 > 255) {
                        v2 = 255;
                    }
                    pixels2[index] = (byte)v2;
                }
            }
            if (hasGetPixel) {
                System.arraycopy(pixels2, 0, pixels1, 0, w * h);
            }
        } else if (bitDepth == 24) {
            int[] pixels1;
            int[] pixels2 = pixels1 = (int[])ip.getPixels();
            if (hasGetPixel) {
                pixels2 = new int[w * h];
            }
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    int index = y * w + x;
                    int rgb = pixels1[index];
                    if (hasGetPixel) {
                        interp.setVariable("v", rgb);
                        interp.run(PCStart);
                        rgb = (int)interp.getVariable("v");
                    } else {
                        int red = (rgb & 0xFF0000) >> 16;
                        int green = (rgb & 0xFF00) >> 8;
                        int blue = rgb & 0xFF;
                        interp.setVariable("v", red);
                        interp.run(PCStart);
                        red = (int)interp.getVariable("v");
                        if (red < 0) {
                            red = 0;
                        }
                        if (red > 255) {
                            red = 255;
                        }
                        interp.setVariable("v", green);
                        interp.run(PCStart);
                        green = (int)interp.getVariable("v");
                        if (green < 0) {
                            green = 0;
                        }
                        if (green > 255) {
                            green = 255;
                        }
                        interp.setVariable("v", blue);
                        interp.run(PCStart);
                        blue = (int)interp.getVariable("v");
                        if (blue < 0) {
                            blue = 0;
                        }
                        if (blue > 255) {
                            blue = 255;
                        }
                        rgb = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                    }
                    pixels2[index] = rgb;
                }
            }
            if (hasGetPixel) {
                System.arraycopy(pixels2, 0, pixels1, 0, w * h);
            }
        } else {
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    double v = ip.getPixelValue(x, y);
                    interp.setVariable("v", v);
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    interp.run(PCStart);
                    ip.putPixelValue(x, y, interp.getVariable("v"));
                }
            }
        }
        if (showProgress) {
            IJ.showProgress(1.0);
        }
        WindowManager.setTempCurrentImage(temp);
    }

    private static final double getD(int dx, int dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static final double getA(int y, int x) {
        double angle = Math.atan2(y, x);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    void getMacro(String macro) {
        this.gd = new GenericDialog("Expression Evaluator");
        this.gd.addStringField("Code:", macro, 42);
        this.gd.setInsets(0, 40, 0);
        this.gd.addMessage("v=pixel value, x,y&z=pixel coordinates, w=image width,\nh=image height, a=angle, d=distance from center\n");
        this.gd.setInsets(5, 40, 0);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#math-macro");
        this.gd.showDialog();
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.pfr = pfr;
        if (this.arg.equals("macro")) {
            this.getMacro(macro);
        } else if (this.arg.equals("add")) {
            this.getValue("Add", "Value: ", addValue, 0);
        } else if (this.arg.equals("sub")) {
            this.getValue("Subtract", "Value: ", addValue, 0);
        } else if (this.arg.equals("mul")) {
            this.getValue("Multiply", "Value: ", mulValue, 2);
        } else if (this.arg.equals("div")) {
            this.getValue("Divide", "Value: ", mulValue, 2);
        } else if (this.arg.equals("and")) {
            this.getBinaryValue("AND", "Value (binary): ", andValue);
        } else if (this.arg.equals("or")) {
            this.getBinaryValue("OR", "Value (binary): ", andValue);
        } else if (this.arg.equals("xor")) {
            this.getBinaryValue("XOR", "Value (binary): ", andValue);
        } else if (this.arg.equals("min")) {
            this.getValue("Min", "Value: ", minValue, 0);
        } else if (this.arg.equals("max")) {
            this.getValue("Max", "Value: ", maxValue, 0);
        } else if (this.arg.equals("gamma")) {
            this.getGammaValue(gammaValue);
        } else if (this.arg.equals("set")) {
            boolean rgb = imp.getBitDepth() == 24;
            String prompt = rgb ? "Value (0-255): " : "Value: ";
            this.getValue("Set", prompt, addValue, 0);
        }
        if (this.gd != null && this.gd.wasCanceled()) {
            return 4096;
        }
        return IJ.setupDialog(imp, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (this.arg.equals("macro")) {
            String str = gd.getNextString();
            if (this.previewing() && this.macro2 != null && !str.equals(this.macro2)) {
                gd.getPreviewCheckbox().setState(false);
            }
            this.macro2 = str;
        } else if (this.arg.equals("add") || this.arg.equals("sub") || this.arg.equals("set")) {
            addValue = gd.getNextNumber();
        } else if (this.arg.equals("mul") || this.arg.equals("div")) {
            mulValue = gd.getNextNumber();
        } else if (this.arg.equals("and") || this.arg.equals("or") || this.arg.equals("xor")) {
            andValue = gd.getNextString();
        } else if (this.arg.equals("min")) {
            minValue = gd.getNextNumber();
        } else if (this.arg.equals("max")) {
            maxValue = gd.getNextNumber();
        } else if (this.arg.equals("gamma")) {
            gammaValue = gd.getNextNumber();
        }
        this.canceled = gd.invalidNumber();
        if (gd.wasOKed() && this.canceled) {
            IJ.error("Value is invalid.");
            return false;
        }
        return true;
    }

    public void setNPasses(int nPasses) {
    }
}

