/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHandlerWrapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class ChildOrderConflictHandler
extends ConflictHandlerWrapper {
    public ChildOrderConflictHandler(ConflictHandler handler) {
        super(handler);
    }

    @Override
    public ConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            ChildOrderConflictHandler.merge(parent, ours, theirs);
            return ConflictHandler.Resolution.MERGED;
        }
        return this.handler.addExistingProperty(parent, ours, theirs);
    }

    @Override
    public ConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            return ConflictHandler.Resolution.THEIRS;
        }
        return this.handler.changeDeletedProperty(parent, ours);
    }

    @Override
    public ConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            ChildOrderConflictHandler.merge(parent, ours, theirs);
            return ConflictHandler.Resolution.MERGED;
        }
        return this.handler.changeChangedProperty(parent, ours, theirs);
    }

    private static void merge(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        HashSet<String> theirOrder = Sets.newHashSet(theirs.getValue(Type.NAMES));
        PropertyBuilder<String> merged = PropertyBuilder.array(Type.NAME).assignFrom(theirs);
        for (String ourChild : ours.getValue(Type.NAMES)) {
            if (theirOrder.contains(ourChild)) continue;
            merged.addValue(ourChild);
        }
        for (String child : merged.getValues()) {
            if (parent.hasChildNode(child)) continue;
            merged.removeValue(child);
        }
        parent.setProperty(merged.getPropertyState());
    }

    @Override
    public ConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState ours) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            return ConflictHandler.Resolution.THEIRS;
        }
        return this.handler.deleteDeletedProperty(parent, ours);
    }

    @Override
    public ConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(theirs)) {
            return ConflictHandler.Resolution.THEIRS;
        }
        return this.handler.deleteChangedProperty(parent, theirs);
    }

    private static boolean isChildOrderProperty(PropertyState p) {
        return ":childOrder".equals(p.getName());
    }
}

