/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.fulltext;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;

public class FullTextOr
extends FullTextExpression {
    public final ArrayList<FullTextExpression> list;

    public FullTextOr(ArrayList<FullTextExpression> list) {
        this.list = list;
    }

    @Override
    public boolean evaluate(String value) {
        for (FullTextExpression e : this.list) {
            if (!e.evaluate(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FullTextExpression simplify() {
        Set<FullTextExpression> set = FullTextOr.getSortedAndUniqueSet(this.list);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        ArrayList<FullTextExpression> l = new ArrayList<FullTextExpression>(set.size());
        l.addAll(set);
        return new FullTextOr(l);
    }

    static Set<FullTextExpression> getSortedAndUniqueSet(List<FullTextExpression> list) {
        TreeSet<FullTextExpression> set = new TreeSet<FullTextExpression>(new Comparator<FullTextExpression>(){

            @Override
            public int compare(FullTextExpression o1, FullTextExpression o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            set.add(list.get(i).simplify());
        }
        return set;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        for (FullTextExpression e : this.list) {
            if (i++ > 0) {
                buff.append(" OR ");
            }
            if (e.getPrecedence() < this.getPrecedence()) {
                buff.append('(');
            }
            buff.append(e.toString());
            if (e.getPrecedence() >= this.getPrecedence()) continue;
            buff.append(')');
        }
        return buff.toString();
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public boolean accept(FullTextVisitor v) {
        return v.visit(this);
    }
}

