/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import javax.annotation.CheckForNull;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.namepath.PathMapper;
import org.apache.jackrabbit.oak.security.user.AdminPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.CredentialsImpl;
import org.apache.jackrabbit.oak.security.user.ImpersonationImpl;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.util.TreeUtil;

class UserImpl
extends AuthorizableImpl
implements User {
    private final boolean isAdmin;

    UserImpl(String id, Tree tree, UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
        this.isAdmin = UserUtil.getAdminId(userManager.getConfig()).equals(id);
    }

    @Override
    void checkValidTree(Tree tree) throws RepositoryException {
        if (tree == null || !UserUtil.isType(tree, AuthorizableType.USER)) {
            throw new IllegalArgumentException("Invalid user node: node type rep:User expected.");
        }
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public Principal getPrincipal() throws RepositoryException {
        Tree userTree = this.getTree();
        String principalName = this.getPrincipalName();
        NamePathMapper npMapper = this.getUserManager().getNamePathMapper();
        if (this.isAdmin()) {
            return new AdminPrincipalImpl(principalName, userTree, (PathMapper)npMapper);
        }
        return new TreeBasedPrincipal(principalName, userTree, (PathMapper)npMapper);
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @Override
    public Credentials getCredentials() {
        return new CredentialsImpl(this.getID(), this.getPasswordHash());
    }

    @Override
    public Impersonation getImpersonation() throws RepositoryException {
        return new ImpersonationImpl(this);
    }

    @Override
    public void changePassword(String password) throws RepositoryException {
        if (password == null) {
            throw new RepositoryException("Attempt to set 'null' password for user " + this.getID());
        }
        UserManagerImpl userManager = this.getUserManager();
        userManager.onPasswordChange(this, password);
        userManager.setPassword(this.getTree(), password, true);
    }

    @Override
    public void changePassword(String password, String oldPassword) throws RepositoryException {
        String pwHash = this.getPasswordHash();
        if (!PasswordUtil.isSame(pwHash, oldPassword)) {
            throw new RepositoryException("Failed to change password: Old password does not match.");
        }
        this.changePassword(password);
    }

    @Override
    public void disable(String reason) throws RepositoryException {
        if (this.isAdmin) {
            throw new RepositoryException("The administrator user cannot be disabled.");
        }
        Tree tree = this.getTree();
        if (reason == null) {
            if (tree.hasProperty("rep:disabled")) {
                tree.removeProperty("rep:disabled");
            }
        } else {
            tree.setProperty("rep:disabled", reason);
        }
    }

    @Override
    public boolean isDisabled() throws RepositoryException {
        return this.getTree().hasProperty("rep:disabled");
    }

    @Override
    public String getDisabledReason() throws RepositoryException {
        PropertyState disabled = this.getTree().getProperty("rep:disabled");
        if (disabled != null) {
            return disabled.getValue(Type.STRING);
        }
        return null;
    }

    @CheckForNull
    private String getPasswordHash() {
        return TreeUtil.getString(this.getTree(), "rep:password");
    }
}

