/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.urlshortener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class UrlShortener {
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String LONG_URL = "longUrl";
    protected static final String SHORTENER = "HTTP-URL-Shortener";
    private static String shortnerServerUrl = "";
    protected static final String KEY = "key";
    private static String paramKeyValue = "";
    protected static Logger logger = Logger.getLogger(UrlShortener.class);
    private String uriRequest;
    private boolean isAvailable = false;

    public UrlShortener() throws Exception {
        this(ScopeProvider.instance.get());
    }

    private UrlShortener(String scope) throws Exception {
        try {
            logger.info("Tentative reading Runtime Resource for name: HTTP-URL-Shortener, the scope is: " + scope);
            if (scope == null || scope.isEmpty()) {
                String msg = "Scope is null or empty! You must set the scope into: " + ScopeProvider.instance.getClass();
                throw new Exception(msg);
            }
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq 'HTTP-URL-Shortener'").setResult("$resource/Profile/AccessPoint");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
            List endpoints = client.submit((Query)query);
            if (endpoints.size() == 0) {
                this.isAvailable = false;
                logger.warn("Runtime Resource HTTP-URL-Shortener not found");
                throw new Exception("No Runtime Resource naming: HTTP-URL-Shortener available in the scope: " + scope);
            }
            String string = shortnerServerUrl = endpoints.get(0) != null ? ((ServiceEndpoint.AccessPoint)endpoints.get(0)).address() : "";
            if (endpoints.get(0) != null) {
                paramKeyValue = ((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap() != null ? ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap().get(KEY)).value() : "";
            }
            String getParam = "";
            if (paramKeyValue != null && !paramKeyValue.isEmpty()) {
                getParam = "?key=" + paramKeyValue;
            }
            this.uriRequest = shortnerServerUrl + getParam;
            logger.info("HTTP-URL-Shortener found in scope " + scope + ", uriRequest: " + this.uriRequest);
            this.isAvailable = true;
        }
        catch (Exception e) {
            logger.error("An error occurred reading Runtime Resource for name: HTTP-URL-Shortener, the scope is: " + scope, e);
            this.isAvailable = false;
            throw new Exception("No HTTP-URL-Shortener available!");
        }
    }

    public String shorten(String longUrl) throws Exception {
        if (longUrl == null) {
            return longUrl;
        }
        try {
            logger.debug("shorten longUrl: " + longUrl);
            URL url = new URL(this.uriRequest);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", APPLICATION_JSON);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put(LONG_URL, longUrl);
            logger.debug("request json : " + jsonObj.toString());
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            wr.write(jsonObj.toString());
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            JSONTokener tokener = new JSONTokener(rd);
            JSONObject jsonObject = new JSONObject(tokener);
            logger.debug("response received json : " + jsonObject.toString());
            wr.close();
            rd.close();
            return (String)jsonObject.get("id");
        }
        catch (MalformedURLException e) {
            logger.error("MalformedURLException error in UrlShortener", e);
            return longUrl;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("IOException error in UrlShortener", e);
            return longUrl;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public static String getShortnerServerUrl() {
        return shortnerServerUrl;
    }

    public static String getKey() {
        return KEY;
    }

    public static String getParamKeyValue() {
        return paramKeyValue;
    }

    public String getUriRequest() {
        return this.uriRequest;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UrlShortener [uriRequest=");
        builder.append(this.uriRequest);
        builder.append(", isAvailable=");
        builder.append(this.isAvailable);
        builder.append("]");
        return builder.toString();
    }
}

