/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import lombok.ConfigurationKeys;
import lombok.Delegate;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.core.handlers.HandlerUtil;
import lombok.javac.FindTypeVarScanner;
import lombok.javac.JavacAST;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacResolution;
import lombok.javac.JavacTreeMaker;
import lombok.javac.ResolutionResetNeeded;
import lombok.javac.handlers.JavacHandlerUtil;

@HandlerPriority(value=65536)
@ResolutionResetNeeded
public class HandleDelegate
extends JavacAnnotationHandler<lombok.experimental.Delegate> {
    private static final java.util.List<String> METHODS_IN_OBJECT = Collections.unmodifiableList(Arrays.asList("hashCode()", "canEqual(java.lang.Object)", "equals(java.lang.Object)", "wait()", "wait(long)", "wait(long, int)", "notify()", "notifyAll()", "toString()", "getClass()", "clone()", "finalize()"));
    private static final String LEGALITY_OF_DELEGATE = "@Delegate is legal only on instance fields or no-argument instance methods.";
    private static final String RECURSION_NOT_ALLOWED = "@Delegate does not support recursion (delegating to a type that itself has @Delegate members). Member \"%s\" is @Delegate in type \"%s\"";

    @Override
    public void handle(AnnotationValues<lombok.experimental.Delegate> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        Type type;
        Type delegateType;
        DelegateReceiver delegateReceiver;
        HandlerUtil.handleExperimentalFlagUsage(annotationNode, ConfigurationKeys.DELEGATE_FLAG_USAGE, "@Delegate");
        Class<Delegate> oldDelegate = Delegate.class;
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, lombok.experimental.Delegate.class, oldDelegate);
        Name delegateName = annotationNode.toName(((JavacNode)annotationNode.up()).getName());
        JavacResolution reso = new JavacResolution(annotationNode.getContext());
        JCTree member = (JCTree)((JavacNode)annotationNode.up()).get();
        if (((JavacNode)annotationNode.up()).getKind() == AST.Kind.FIELD) {
            if ((((JCTree.JCVariableDecl)member).mods.flags & 8L) != 0L) {
                annotationNode.addError(LEGALITY_OF_DELEGATE);
                return;
            }
            delegateReceiver = DelegateReceiver.FIELD;
            delegateType = member.type;
            if (delegateType == null) {
                reso.resolveClassMember((JavacNode)annotationNode.up());
            }
            delegateType = member.type;
        } else if (((JavacNode)annotationNode.up()).getKind() == AST.Kind.METHOD) {
            if (!(member instanceof JCTree.JCMethodDecl)) {
                annotationNode.addError(LEGALITY_OF_DELEGATE);
                return;
            }
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)member;
            if (!methodDecl.params.isEmpty() || (methodDecl.mods.flags & 8L) != 0L) {
                annotationNode.addError(LEGALITY_OF_DELEGATE);
                return;
            }
            delegateReceiver = DelegateReceiver.METHOD;
            delegateType = methodDecl.restype.type;
            if (delegateType == null) {
                reso.resolveClassMember((JavacNode)annotationNode.up());
            }
            delegateType = methodDecl.restype.type;
        } else {
            return;
        }
        java.util.List<Object> delegateTypes = annotation.getActualExpressions("types");
        java.util.List<Object> excludeTypes = annotation.getActualExpressions("excludes");
        ArrayList<Type> toDelegate = new ArrayList<Type>();
        ArrayList<Type> toExclude = new ArrayList<Type>();
        if (delegateTypes.isEmpty()) {
            if (delegateType != null) {
                toDelegate.add(delegateType);
            }
        } else {
            for (Object dt : delegateTypes) {
                if (!(dt instanceof JCTree.JCFieldAccess) || !((JCTree.JCFieldAccess)dt).name.toString().equals("class")) continue;
                type = ((JCTree.JCFieldAccess)dt).selected.type;
                if (type == null) {
                    reso.resolveClassMember(annotationNode);
                }
                if ((type = ((JCTree.JCFieldAccess)dt).selected.type) == null) continue;
                toDelegate.add(type);
            }
        }
        for (Object et : excludeTypes) {
            if (!(et instanceof JCTree.JCFieldAccess) || !((JCTree.JCFieldAccess)et).name.toString().equals("class")) continue;
            type = ((JCTree.JCFieldAccess)et).selected.type;
            if (type == null) {
                reso.resolveClassMember(annotationNode);
            }
            if ((type = ((JCTree.JCFieldAccess)et).selected.type) == null) continue;
            toExclude.add(type);
        }
        ArrayList<MethodSig> signaturesToDelegate = new ArrayList<MethodSig>();
        ArrayList<MethodSig> signaturesToExclude = new ArrayList<MethodSig>();
        HashSet<String> banList = new HashSet<String>();
        banList.addAll(METHODS_IN_OBJECT);
        try {
            Type.ClassType ct;
            for (Type t : toExclude) {
                if (t instanceof Type.ClassType) {
                    ct = (Type.ClassType)t;
                    this.addMethodBindings(signaturesToExclude, ct, annotationNode.getTypesUtil(), banList);
                    continue;
                }
                annotationNode.addError("@Delegate can only use concrete class types, not wildcards, arrays, type variables, or primitives.");
                return;
            }
            for (MethodSig sig : signaturesToExclude) {
                banList.add(HandleDelegate.printSig(sig.type, sig.name, annotationNode.getTypesUtil()));
            }
            for (Type t : toDelegate) {
                if (t instanceof Type.ClassType) {
                    ct = (Type.ClassType)t;
                    this.addMethodBindings(signaturesToDelegate, ct, annotationNode.getTypesUtil(), banList);
                    continue;
                }
                annotationNode.addError("@Delegate can only use concrete class types, not wildcards, arrays, type variables, or primitives.");
                return;
            }
            for (MethodSig sig : signaturesToDelegate) {
                this.generateAndAdd(sig, annotationNode, delegateName, delegateReceiver);
            }
        }
        catch (DelegateRecursion e) {
            annotationNode.addError(String.format(RECURSION_NOT_ALLOWED, e.member, e.type));
        }
    }

    public void generateAndAdd(MethodSig sig, JavacNode annotation, Name delegateName, DelegateReceiver delegateReceiver) {
        ArrayList<JCTree.JCMethodDecl> toAdd = new ArrayList<JCTree.JCMethodDecl>();
        try {
            toAdd.add(this.createDelegateMethod(sig, annotation, delegateName, delegateReceiver));
        }
        catch (JavacResolution.TypeNotConvertibleException e) {
            annotation.addError("Can't create delegate method for " + sig.name + ": " + e.getMessage());
            return;
        }
        catch (CantMakeDelegates e) {
            annotation.addError("There's a conflict in the names of type parameters. Fix it by renaming the following type parameters of your class: " + e.conflicted);
            return;
        }
        for (JCTree.JCMethodDecl method : toAdd) {
            JavacHandlerUtil.injectMethod((JavacNode)((JavacNode)annotation.up()).up(), method);
        }
    }

    public void checkConflictOfTypeVarNames(MethodSig sig, JavacNode annotation) throws CantMakeDelegates {
        if (sig.elem.getTypeParameters().isEmpty()) {
            return;
        }
        HashSet<String> usedInOurType = new HashSet<String>();
        for (JavacNode enclosingType = annotation; enclosingType != null; enclosingType = (JavacNode)enclosingType.up()) {
            List<JCTree.JCTypeParameter> typarams;
            if (enclosingType.getKind() != AST.Kind.TYPE || (typarams = ((JCTree.JCClassDecl)enclosingType.get()).typarams) == null) continue;
            for (JCTree.JCTypeParameter jCTypeParameter : typarams) {
                if (jCTypeParameter.name == null) continue;
                usedInOurType.add(jCTypeParameter.name.toString());
            }
        }
        HashSet<String> usedInMethodSig = new HashSet<String>();
        for (TypeParameterElement typeParameterElement : sig.elem.getTypeParameters()) {
            usedInMethodSig.add(typeParameterElement.getSimpleName().toString());
        }
        usedInMethodSig.retainAll(usedInOurType);
        if (usedInMethodSig.isEmpty()) {
            return;
        }
        FindTypeVarScanner scanner = new FindTypeVarScanner();
        sig.elem.asType().accept(scanner, null);
        HashSet<String> hashSet = new HashSet<String>(scanner.getTypeVariables());
        hashSet.removeAll(usedInMethodSig);
        if (!hashSet.isEmpty()) {
            CantMakeDelegates cmd = new CantMakeDelegates();
            cmd.conflicted = usedInMethodSig;
            throw cmd;
        }
    }

    public JCTree.JCMethodDecl createDelegateMethod(MethodSig sig, JavacNode annotation, Name delegateName, DelegateReceiver delegateReceiver) throws JavacResolution.TypeNotConvertibleException, CantMakeDelegates {
        this.checkConflictOfTypeVarNames(sig, annotation);
        JavacTreeMaker maker = annotation.getTreeMaker();
        List<JCTree.JCAnnotation> annotations = sig.isDeprecated ? List.of(maker.Annotation(JavacHandlerUtil.genJavaLangTypeRef(annotation, "Deprecated"), List.<JCTree.JCExpression>nil())) : List.nil();
        JCTree.JCModifiers mods = maker.Modifiers(1L, annotations);
        JCTree.JCExpression returnType2 = JavacResolution.typeToJCTree((Type)sig.type.getReturnType(), (JavacAST)annotation.getAst(), true);
        boolean useReturn = sig.type.getReturnType().getKind() != TypeKind.VOID;
        ListBuffer<JCTree.JCVariableDecl> params = sig.type.getParameterTypes().isEmpty() ? null : new ListBuffer<JCTree.JCVariableDecl>();
        ListBuffer<JCTree.JCIdent> args = sig.type.getParameterTypes().isEmpty() ? null : new ListBuffer<JCTree.JCIdent>();
        ListBuffer<JCTree.JCExpression> thrown = sig.type.getThrownTypes().isEmpty() ? null : new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCTypeParameter> typeParams = sig.type.getTypeVariables().isEmpty() ? null : new ListBuffer<JCTree.JCTypeParameter>();
        ListBuffer<JCTree.JCIdent> typeArgs = sig.type.getTypeVariables().isEmpty() ? null : new ListBuffer<JCTree.JCIdent>();
        Types types = Types.instance(annotation.getContext());
        for (TypeMirror typeMirror : sig.type.getTypeVariables()) {
            Name name = ((Type.TypeVar)typeMirror).tsym.name;
            ListBuffer<JCTree.JCExpression> bounds = types.getBounds((Type.TypeVar)typeMirror).isEmpty() ? null : new ListBuffer<JCTree.JCExpression>();
            for (Type type : types.getBounds((Type.TypeVar)typeMirror)) {
                bounds.append(JavacResolution.typeToJCTree(type, (JavacAST)annotation.getAst(), true));
            }
            typeParams.append(maker.TypeParameter(name, bounds.toList()));
            typeArgs.append(maker.Ident(name));
        }
        for (TypeMirror typeMirror : sig.type.getThrownTypes()) {
            thrown.append(JavacResolution.typeToJCTree((Type)typeMirror, (JavacAST)annotation.getAst(), true));
        }
        int idx = 0;
        for (TypeMirror typeMirror : sig.type.getParameterTypes()) {
            long flags = JavacHandlerUtil.addFinalIfNeeded(0x200000000L, annotation.getContext());
            JCTree.JCModifiers paramMods = maker.Modifiers(flags);
            String[] paramNames = sig.getParameterNames();
            Name name = annotation.toName(paramNames[idx++]);
            params.append(maker.VarDef(paramMods, name, JavacResolution.typeToJCTree((Type)typeMirror, (JavacAST)annotation.getAst(), true), null));
            args.append(maker.Ident(name));
        }
        JCTree.JCMethodInvocation jCMethodInvocation = maker.Apply(HandleDelegate.toList(typeArgs), maker.Select(delegateReceiver.get(annotation, delegateName), sig.name), HandleDelegate.toList(args));
        JCTree.JCStatement jCStatement = useReturn ? maker.Return(jCMethodInvocation) : maker.Exec(jCMethodInvocation);
        JCTree.JCBlock bodyBlock = maker.Block(0L, List.of(jCStatement));
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, sig.name, returnType2, HandleDelegate.toList(typeParams), HandleDelegate.toList(params), HandleDelegate.toList(thrown), bodyBlock, null), (JCTree)annotation.get(), annotation.getContext());
    }

    public static <T> List<T> toList(ListBuffer<T> collection) {
        return collection == null ? List.nil() : collection.toList();
    }

    public void addMethodBindings(java.util.List<MethodSig> signatures, Type.ClassType ct, JavacTypes types, Set<String> banList) throws DelegateRecursion {
        Element tsym = ct.asElement();
        if (tsym == null) {
            return;
        }
        for (Symbol member : ((Symbol.TypeSymbol)tsym).getEnclosedElements()) {
            ExecutableType methodType;
            String sig;
            ExecutableElement exElem;
            for (Attribute.Compound am : member.getAnnotationMirrors()) {
                String name = null;
                try {
                    name = am.type.tsym.flatName().toString();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (!"lombok.Delegate".equals(name) && !"lombok.experimental.Delegate".equals(name)) continue;
                throw new DelegateRecursion(ct.tsym.name.toString(), member.name.toString());
            }
            if (member.getKind() != ElementKind.METHOD || member.isStatic() || member.isConstructor() || !(exElem = (ExecutableElement)((Object)member)).getModifiers().contains((Object)Modifier.PUBLIC) || !banList.add(sig = HandleDelegate.printSig(methodType = (ExecutableType)types.asMemberOf(ct, member), member.name, types))) continue;
            boolean isDeprecated = (member.flags() & 0x20000L) != 0L;
            signatures.add(new MethodSig(member.name, methodType, isDeprecated, exElem));
        }
        if (ct.supertype_field instanceof Type.ClassType) {
            this.addMethodBindings(signatures, (Type.ClassType)ct.supertype_field, types, banList);
        }
        if (ct.interfaces_field != null) {
            for (Type iface : ct.interfaces_field) {
                if (!(iface instanceof Type.ClassType)) continue;
                this.addMethodBindings(signatures, (Type.ClassType)iface, types, banList);
            }
        }
    }

    public static String printSig(ExecutableType method, Name name, JavacTypes types) {
        StringBuilder sb = new StringBuilder();
        sb.append(name.toString()).append("(");
        boolean first = true;
        for (TypeMirror typeMirror : method.getParameterTypes()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(HandleDelegate.typeBindingToSignature(typeMirror, types));
        }
        return sb.append(")").toString();
    }

    public static String typeBindingToSignature(TypeMirror binding, JavacTypes types) {
        binding = types.erasure(binding);
        return binding.toString();
    }

    public static enum DelegateReceiver {
        METHOD{

            @Override
            public JCTree.JCExpression get(JavacNode node, Name name) {
                List<JCTree.JCExpression> nilExprs = List.nil();
                JavacTreeMaker maker = node.getTreeMaker();
                return maker.Apply(nilExprs, maker.Select(maker.Ident(node.toName("this")), name), nilExprs);
            }
        }
        ,
        FIELD{

            @Override
            public JCTree.JCExpression get(JavacNode node, Name name) {
                JavacTreeMaker maker = node.getTreeMaker();
                return maker.Select(maker.Ident(node.toName("this")), name);
            }
        };


        public abstract JCTree.JCExpression get(JavacNode var1, Name var2);
    }

    public static class MethodSig {
        final Name name;
        final ExecutableType type;
        final boolean isDeprecated;
        final ExecutableElement elem;

        MethodSig(Name name, ExecutableType type, boolean isDeprecated, ExecutableElement elem) {
            this.name = name;
            this.type = type;
            this.isDeprecated = isDeprecated;
            this.elem = elem;
        }

        String[] getParameterNames() {
            java.util.List<? extends VariableElement> paramList = this.elem.getParameters();
            String[] paramNames = new String[paramList.size()];
            for (int i = 0; i < paramNames.length; ++i) {
                paramNames[i] = paramList.get(i).getSimpleName().toString();
            }
            return paramNames;
        }

        public String toString() {
            return (this.isDeprecated ? "@Deprecated " : "") + this.name + " " + this.type;
        }
    }

    private static class DelegateRecursion
    extends Throwable {
        final String type;
        final String member;

        public DelegateRecursion(String type, String member) {
            this.type = type;
            this.member = member;
        }
    }

    public static class CantMakeDelegates
    extends Exception {
        Set<String> conflicted;
    }
}

