/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.db;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.h2.jdbcx.JdbcConnectionPool;

public class DbBlobStore
extends CachingBlobStore {
    private JdbcConnectionPool cp;
    private long minLastModified;

    public void setConnectionPool(JdbcConnectionPool cp) throws SQLException {
        this.cp = cp;
        Connection conn = cp.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("create table if not exists datastore_meta(id varchar primary key, level int, lastMod bigint)");
        stat.execute("create table if not exists datastore_data(id varchar primary key, data binary)");
        stat.close();
        conn.close();
    }

    @Override
    protected synchronized void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        try {
            this.storeBlockToDatabase(digest, level, data);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBlockToDatabase(byte[] digest, int level, byte[] data) throws SQLException {
        block17: {
            String id = StringUtils.convertBytesToHex(digest);
            this.cache.put(id, data);
            Connection conn = this.cp.getConnection();
            try {
                int count;
                long now = System.currentTimeMillis();
                PreparedStatement prep = conn.prepareStatement("update datastore_meta set lastMod = ? where id = ?");
                try {
                    prep.setLong(1, now);
                    prep.setString(2, id);
                    count = prep.executeUpdate();
                }
                finally {
                    prep.close();
                }
                if (count != 0) break block17;
                try {
                    prep = conn.prepareStatement("insert into datastore_data(id, data) values(?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setBytes(2, data);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    prep = conn.prepareStatement("insert into datastore_meta(id, level, lastMod) values(?, ?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setInt(2, level);
                        prep.setLong(3, now);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            finally {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex(blockId.getDigest());
        byte[] data = (byte[])this.cache.get(id);
        if (data == null) {
            Connection conn = this.cp.getConnection();
            try {
                PreparedStatement prep = conn.prepareStatement("select data from datastore_data where id = ?");
                try {
                    prep.setString(1, id);
                    ResultSet rs = prep.executeQuery();
                    if (!rs.next()) {
                        throw new IOException("Datastore block " + id + " not found");
                    }
                    data = rs.getBytes(1);
                }
                finally {
                    prep.close();
                }
                this.cache.put(id, data);
            }
            finally {
                conn.close();
            }
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    @Override
    public void startMark() throws IOException {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        if (this.minLastModified == 0L) {
            return;
        }
        Connection conn = this.cp.getConnection();
        try {
            String id = StringUtils.convertBytesToHex(blockId.getDigest());
            PreparedStatement prep = conn.prepareStatement("update datastore_meta set lastMod = ? where id = ? and lastMod < ?");
            prep.setLong(1, System.currentTimeMillis());
            prep.setString(2, id);
            prep.setLong(3, this.minLastModified);
            prep.executeUpdate();
            prep.close();
        }
        finally {
            conn.close();
        }
    }

    @Override
    public int sweep() throws IOException {
        try {
            return this.sweepFromDatabase();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sweepFromDatabase() throws SQLException {
        int count = 0;
        Connection conn = this.cp.getConnection();
        try {
            PreparedStatement prep = conn.prepareStatement("select id from datastore_meta where lastMod < ?");
            prep.setLong(1, this.minLastModified);
            ResultSet rs = prep.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            prep = conn.prepareStatement("delete from datastore_meta where id = ?");
            PreparedStatement prepData = conn.prepareStatement("delete from datastore_data where id = ?");
            for (String id : ids) {
                prep.setString(1, id);
                prep.execute();
                prepData.setString(1, id);
                prepData.execute();
                ++count;
            }
            prepData.close();
            prep.close();
        }
        finally {
            conn.close();
        }
        this.minLastModified = 0L;
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        Connection conn = this.cp.getConnection();
        try {
            PreparedStatement prep = null;
            PreparedStatement prepData = null;
            StringBuilder inClause = new StringBuilder();
            int batch = chunkIds.size();
            for (int i = 0; i < batch; ++i) {
                inClause.append('?');
                if (i == batch - 1) continue;
                inClause.append(',');
            }
            if (maxLastModifiedTime > 0L) {
                prep = conn.prepareStatement("delete from datastore_meta where id in (" + inClause.toString() + ") and lastMod <= ?");
                prep.setLong(batch + 1, maxLastModifiedTime);
                prepData = conn.prepareStatement("delete from datastore_data where id in (" + inClause.toString() + ") and lastMod <= ?");
                prepData.setLong(batch + 1, maxLastModifiedTime);
            } else {
                prep = conn.prepareStatement("delete from datastore_meta where id in (" + inClause.toString() + ")");
                prepData = conn.prepareStatement("delete from datastore_data where id in (" + inClause.toString() + ")");
            }
            for (int idx = 0; idx < batch; ++idx) {
                prep.setString(idx + 1, chunkIds.get(idx));
                prepData.setString(idx + 1, chunkIds.get(idx));
            }
            prep.execute();
            prepData.execute();
            prep.close();
            prepData.close();
        }
        finally {
            conn.commit();
            conn.close();
        }
        return true;
    }

    @Override
    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        final Connection conn = this.cp.getConnection();
        PreparedStatement prep = null;
        if (maxLastModifiedTime > 0L) {
            prep = conn.prepareStatement("select id from datastore_meta where lastMod <= ?");
            prep.setLong(1, maxLastModifiedTime);
        } else {
            prep = conn.prepareStatement("select id from datastore_meta");
        }
        final ResultSet rs = prep.executeQuery();
        return new AbstractIterator<String>(){

            @Override
            protected String computeNext() {
                try {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    conn.close();
                }
                catch (SQLException e) {
                    try {
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new RuntimeException(e);
                }
                return (String)this.endOfData();
            }
        };
    }
}

