/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveNodeType {
    private static final Logger log = LoggerFactory.getLogger(EffectiveNodeType.class);
    private static final NodeTypeImpl[] NO_MIXINS = new NodeTypeImpl[0];
    private final Map<String, NodeTypeImpl> nodeTypes = Maps.newLinkedHashMap();
    private final ReadOnlyNodeTypeManager ntMgr;

    EffectiveNodeType(NodeTypeImpl primary, NodeTypeImpl[] mixins, ReadOnlyNodeTypeManager ntMgr) {
        this.ntMgr = ntMgr;
        this.addNodeType(Preconditions.checkNotNull(primary));
        for (NodeTypeImpl mixin : Preconditions.checkNotNull(mixins)) {
            this.addNodeType(mixin);
        }
        if (!this.nodeTypes.containsKey("nt:base")) {
            try {
                this.nodeTypes.put("nt:base", (NodeTypeImpl)ntMgr.getNodeType("nt:base"));
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
    }

    EffectiveNodeType(NodeTypeImpl primary, ReadOnlyNodeTypeManager ntMgr) {
        this(primary, NO_MIXINS, ntMgr);
    }

    private void addNodeType(NodeTypeImpl type) {
        String name = type.getName();
        if (!this.nodeTypes.containsKey(name)) {
            NodeType[] supertypes;
            this.nodeTypes.put(name, type);
            for (NodeType supertype : supertypes = type.getDeclaredSupertypes()) {
                this.addNodeType((NodeTypeImpl)supertype);
            }
        }
    }

    public boolean includesNodeType(String nodeTypeName) {
        return this.nodeTypes.containsKey(nodeTypeName);
    }

    public boolean includesNodeTypes(String[] nodeTypeNames) {
        for (String ntName : nodeTypeNames) {
            if (this.includesNodeType(ntName)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsMixin(String mixin) {
        if (this.includesNodeType(mixin)) {
            return true;
        }
        NodeTypeImpl mixinType = null;
        try {
            mixinType = this.ntMgr.internalGetNodeType(mixin);
            if (!mixinType.isMixin() || mixinType.isAbstract()) {
                return false;
            }
        }
        catch (NoSuchNodeTypeException e) {
            log.debug("Unknown mixin type " + mixin);
        }
        return true;
    }

    public Iterable<NodeDefinition> getNodeDefinitions() {
        ArrayList<NodeDefinition> definitions = new ArrayList<NodeDefinition>();
        for (NodeType nodeType : this.nodeTypes.values()) {
            definitions.addAll(((NodeTypeImpl)nodeType).internalGetChildDefinitions());
        }
        return definitions;
    }

    public Iterable<PropertyDefinition> getPropertyDefinitions() {
        ArrayList<PropertyDefinition> definitions = new ArrayList<PropertyDefinition>();
        for (NodeType nodeType : this.nodeTypes.values()) {
            definitions.addAll(((NodeTypeImpl)nodeType).internalGetPropertyDefinitions());
        }
        return definitions;
    }

    public Iterable<NodeDefinition> getAutoCreateNodeDefinitions() {
        return Iterables.filter(this.getNodeDefinitions(), new Predicate<NodeDefinition>(){

            @Override
            public boolean apply(NodeDefinition nodeDefinition) {
                return nodeDefinition.isAutoCreated();
            }
        });
    }

    public Iterable<PropertyDefinition> getAutoCreatePropertyDefinitions() {
        return Iterables.filter(this.getPropertyDefinitions(), new Predicate<PropertyDefinition>(){

            @Override
            public boolean apply(PropertyDefinition propertyDefinition) {
                return propertyDefinition.isAutoCreated();
            }
        });
    }

    public Iterable<NodeDefinition> getMandatoryNodeDefinitions() {
        return Iterables.filter(this.getNodeDefinitions(), new Predicate<NodeDefinition>(){

            @Override
            public boolean apply(NodeDefinition nodeDefinition) {
                return nodeDefinition.isMandatory();
            }
        });
    }

    public Iterable<PropertyDefinition> getMandatoryPropertyDefinitions() {
        return Iterables.filter(this.getPropertyDefinitions(), new Predicate<PropertyDefinition>(){

            @Override
            public boolean apply(PropertyDefinition propertyDefinition) {
                return propertyDefinition.isMandatory();
            }
        });
    }

    @Nonnull
    public Iterable<NodeDefinition> getNamedNodeDefinitions(final String oakName) {
        return Iterables.concat(Iterables.transform(this.nodeTypes.values(), new Function<NodeTypeImpl, Iterable<NodeDefinition>>(){

            @Override
            public Iterable<NodeDefinition> apply(NodeTypeImpl input) {
                return input.getDeclaredNamedNodeDefinitions(oakName);
            }
        }));
    }

    @Nonnull
    public Iterable<PropertyDefinition> getNamedPropertyDefinitions(String oakName) {
        ArrayList<PropertyDefinition> definitions = Lists.newArrayList();
        for (NodeTypeImpl type : this.nodeTypes.values()) {
            definitions.addAll(type.getDeclaredNamedPropertyDefinitions(oakName));
        }
        return definitions;
    }

    @Nonnull
    public Iterable<NodeDefinition> getResidualNodeDefinitions() {
        ArrayList<NodeDefinition> definitions = Lists.newArrayList();
        for (NodeTypeImpl type : this.nodeTypes.values()) {
            definitions.addAll(type.getDeclaredResidualNodeDefinitions());
        }
        return definitions;
    }

    @Nonnull
    public Iterable<PropertyDefinition> getResidualPropertyDefinitions() {
        ArrayList<PropertyDefinition> definitions = Lists.newArrayList();
        for (NodeTypeImpl type : this.nodeTypes.values()) {
            definitions.addAll(type.getDeclaredResidualPropertyDefinitions());
        }
        return definitions;
    }

    public void checkSetProperty(PropertyState property) throws RepositoryException {
        PropertyDefinition definition = this.getDefinition(property);
        if (definition.isProtected()) {
            return;
        }
        NodeType nt = definition.getDeclaringNodeType();
        if (definition.isMultiple()) {
            List<Value> values = ValueFactoryImpl.createValues(property, this.ntMgr.getNamePathMapper());
            if (!nt.canSetProperty(property.getName(), values.toArray(new Value[values.size()]))) {
                throw new ConstraintViolationException("Cannot set property '" + property.getName() + "' to '" + values + '\'');
            }
        } else {
            Value v = ValueFactoryImpl.createValue(property, this.ntMgr.getNamePathMapper());
            if (!nt.canSetProperty(property.getName(), v)) {
                throw new ConstraintViolationException("Cannot set property '" + property.getName() + "' to '" + v + '\'');
            }
        }
    }

    public void checkRemoveProperty(PropertyState property) throws RepositoryException {
        PropertyDefinition definition = this.getDefinition(property);
        if (definition.isProtected()) {
            return;
        }
        if (!definition.getDeclaringNodeType().canRemoveProperty(property.getName())) {
            throw new ConstraintViolationException("Cannot remove property '" + property.getName() + '\'');
        }
    }

    public void checkMandatoryItems(Tree tree) throws ConstraintViolationException {
        for (NodeType nodeType : this.nodeTypes.values()) {
            String name;
            for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
                name = propertyDefinition.getName();
                if (!propertyDefinition.isMandatory() || propertyDefinition.isProtected() || tree.getProperty(name) != null) continue;
                throw new ConstraintViolationException("Property '" + name + "' in '" + nodeType.getName() + "' is mandatory");
            }
            for (ItemDefinition itemDefinition : nodeType.getChildNodeDefinitions()) {
                name = itemDefinition.getName();
                if (!itemDefinition.isMandatory() || itemDefinition.isProtected() || tree.hasChild(name)) continue;
                throw new ConstraintViolationException("Node '" + name + "' in '" + nodeType.getName() + "' is mandatory");
            }
        }
    }

    public void checkOrderableChildNodes() throws UnsupportedRepositoryOperationException {
        for (NodeType nodeType : this.nodeTypes.values()) {
            if (!nodeType.hasOrderableChildNodes()) continue;
            return;
        }
        throw new UnsupportedRepositoryOperationException("Child node ordering is not supported on this node");
    }

    public PropertyDefinition getPropertyDefinition(String propertyName, boolean isMultiple, int type, boolean exactTypeMatch) throws ConstraintViolationException {
        int defType;
        for (PropertyDefinition def : this.getNamedPropertyDefinitions(propertyName)) {
            defType = def.getRequiredType();
            if (isMultiple != def.isMultiple() || exactTypeMatch && type != defType && 0 != type && 0 != defType) continue;
            return def;
        }
        for (PropertyDefinition def : this.getResidualPropertyDefinitions()) {
            defType = def.getRequiredType();
            if (isMultiple != def.isMultiple() || exactTypeMatch && type != defType && 0 != type && 0 != defType) continue;
            return def;
        }
        throw new ConstraintViolationException("No matching property definition found for " + propertyName);
    }

    public NodeDefinition getNodeDefinition(String childName, EffectiveNodeType childEffective) throws ConstraintViolationException {
        boolean match;
        for (NodeDefinition def : this.getNamedNodeDefinitions(childName)) {
            match = true;
            if (childEffective != null && !childEffective.includesNodeTypes(def.getRequiredPrimaryTypeNames())) {
                match = false;
            }
            if (!match) continue;
            return def;
        }
        for (NodeDefinition def : this.getResidualNodeDefinitions()) {
            match = true;
            if (childEffective != null && !childEffective.includesNodeTypes(def.getRequiredPrimaryTypeNames())) {
                match = false;
            }
            if (!match) continue;
            return def;
        }
        throw new ConstraintViolationException("No matching node definition found for " + childName);
    }

    private PropertyDefinition getDefinition(PropertyState property) throws RepositoryException {
        String propertyName = property.getName();
        int propertyType = property.getType().tag();
        boolean isMultiple = property.isArray();
        return this.getPropertyDefinition(propertyName, isMultiple, propertyType, true);
    }
}

