/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;

public final class CompositePrincipalConfiguration
extends CompositeConfiguration<PrincipalConfiguration>
implements PrincipalConfiguration {
    public CompositePrincipalConfiguration(@Nonnull SecurityProvider securityProvider) {
        super("org.apache.jackrabbit.oak.principal", securityProvider);
    }

    @Override
    @Nonnull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        return new PrincipalManagerImpl(this.getPrincipalProvider(root, namePathMapper));
    }

    @Override
    @Nonnull
    public PrincipalProvider getPrincipalProvider(final Root root, final NamePathMapper namePathMapper) {
        return new CompositePrincipalProvider(Lists.transform(this.getConfigurations(), new Function<PrincipalConfiguration, PrincipalProvider>(){

            @Override
            public PrincipalProvider apply(PrincipalConfiguration principalConfiguration) {
                return principalConfiguration.getPrincipalProvider(root, namePathMapper);
            }
        }));
    }
}

