/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class ApplyDiff
implements NodeStateDiff {
    private final NodeBuilder builder;

    public ApplyDiff(NodeBuilder builder) {
        this.builder = builder;
    }

    public void apply(NodeState target) {
        target.compareAgainstBaseState(this.builder.getNodeState(), this);
    }

    @Override
    public boolean propertyAdded(PropertyState after) {
        this.builder.setProperty(after);
        return true;
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.builder.setProperty(after);
        return true;
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        this.builder.removeProperty(before.getName());
        return true;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        this.builder.setChildNode(name, after);
        return true;
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        return after.compareAgainstBaseState(before, new ApplyDiff(this.builder.getChildNode(name)));
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        this.builder.getChildNode(name).remove();
        return true;
    }
}

