/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.persist.DocumentElaboration;
import org.gcube.accounting.aggregator.persistence.CouchBaseConnector;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;

public class InsertDocument
extends DocumentElaboration {
    public InsertDocument(AggregationStatus aggregationStatus, File file, Bucket bucket) {
        super(aggregationStatus, AggregationState.ADDED, file, bucket, aggregationStatus.getAggregatedRecordsNumber());
    }

    @Override
    protected void elaborateLine(String line) throws Exception {
        JsonObject jsonObject = JsonObject.fromJson((String)line);
        String id = jsonObject.getString("id");
        JsonDocument jsonDocument = JsonDocument.create((String)id, (JsonObject)jsonObject);
        this.bucket.upsert((Document)jsonDocument, PersistTo.MASTER, CouchBaseConnector.CONNECTION_TIMEOUT_BUCKET, TimeUnit.SECONDS);
    }

    @Override
    protected void afterElaboration() {
    }
}

