/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persistence;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.OffsetPath;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistence;
import org.gcube.accounting.aggregator.persistence.AggregatorPersitenceConfiguration;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchBaseConnector {
    private static Logger logger = LoggerFactory.getLogger(CouchBaseConnector.class);
    public static final long MAX_REQUEST_LIFE_TIME = TimeUnit.SECONDS.toMillis(120L);
    public static final long KEEP_ALIVE_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    public static final long AUTO_RELEASE_AFTER = TimeUnit.HOURS.toMillis(1L);
    public static final long VIEW_TIMEOUT_BUCKET = TimeUnit.SECONDS.toMillis(120L);
    public static final long CONNECTION_TIMEOUT_BUCKET = TimeUnit.SECONDS.toMillis(15L);
    public static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private static final String URL_PROPERTY_KEY = "URL";
    private static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String ACCOUNTING_MANAGER_BUCKET_NAME = "AccountingManager";
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(CONNECTION_TIMEOUT).maxRequestLifetime(MAX_REQUEST_LIFE_TIME).queryTimeout(CONNECTION_TIMEOUT).viewTimeout(VIEW_TIMEOUT_BUCKET).keepAliveInterval(KEEP_ALIVE_INTERVAL).kvTimeout(5000L).autoreleaseAfter(AUTO_RELEASE_AFTER).build();
    protected static final PersistTo PERSIST_TO = PersistTo.MASTER;
    protected static CouchBaseConnector couchBaseConnector;
    protected AggregatorPersitenceConfiguration configuration = new AggregatorPersitenceConfiguration(AggregatorPersistence.class);
    protected Cluster cluster = this.getCluster();
    protected Map<String, Bucket> connectionMap;
    protected Map<String, Class<? extends Record>> recordTypeMap;

    public static synchronized CouchBaseConnector getInstance() throws Exception {
        if (couchBaseConnector == null) {
            couchBaseConnector = new CouchBaseConnector();
        }
        return couchBaseConnector;
    }

    protected CouchBaseConnector() throws Exception {
        this.createConnectionMap();
    }

    private Cluster getCluster() throws Exception {
        String url = this.configuration.getProperty(URL_PROPERTY_KEY);
        return CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
    }

    private static String getBucketKey(String recordType, AggregationType aggregationType, SUFFIX suffix) {
        return recordType + "-" + aggregationType.name() + "-" + suffix.name();
    }

    private Map<String, Bucket> createConnectionMap() throws Exception {
        this.connectionMap = new HashMap<String, Bucket>();
        this.recordTypeMap = new HashMap<String, Class<? extends Record>>();
        try {
            Bucket b = this.cluster.openBucket(ACCOUNTING_MANAGER_BUCKET_NAME, this.configuration.getProperty(PASSWORD_PROPERTY_KEY));
            this.connectionMap.put(ACCOUNTING_MANAGER_BUCKET_NAME, b);
        }
        catch (Exception e) {
            logger.error("Unable to open Bucket used for Accounting Aggregation Management", (Throwable)e);
            throw e;
        }
        Map recordClasses = RecordUtility.getRecordClassesFound();
        for (Class recordClass : recordClasses.values()) {
            Record recordInstance = (Record)recordClass.newInstance();
            if (!(recordInstance instanceof UsageRecord) || recordInstance instanceof AggregatedUsageRecord) continue;
            String recordType = recordInstance.getRecordType();
            this.recordTypeMap.put(recordType, recordClass);
            for (AggregationType aggregationType : AggregationType.values()) {
                for (SUFFIX suffix : SUFFIX.values()) {
                    logger.debug("Trying to get the Bucket for {} {} {}", new Object[]{suffix, recordType, aggregationType});
                    String bucketKey = CouchBaseConnector.getBucketKey(recordType, aggregationType, suffix);
                    String bucketName = this.configuration.getProperty(bucketKey);
                    logger.debug("Bucket for {} {} {} is {}. Going to open it.", new Object[]{suffix, recordType, aggregationType, bucketName});
                    try {
                        Bucket bucket = this.cluster.openBucket(bucketName, this.configuration.getProperty(PASSWORD_PROPERTY_KEY));
                        this.connectionMap.put(bucketKey, bucket);
                    }
                    catch (Exception e) {
                        logger.warn("Unable to open Bucket {} for {} {} {}. This normally means that is not configured.", new Object[]{bucketName, suffix, recordType, aggregationType, recordClass});
                    }
                }
            }
        }
        return this.connectionMap;
    }

    public Set<String> getConnectionMapKeys() {
        return this.connectionMap.keySet();
    }

    public Set<String> getRecordTypes() {
        return this.recordTypeMap.keySet();
    }

    public Bucket getBucket(String recordType, AggregationType aggregationType, SUFFIX suffix) {
        return this.connectionMap.get(CouchBaseConnector.getBucketKey(recordType, aggregationType, suffix));
    }

    public static AggregationStatus getLast(String recordType, AggregationType aggregationType, Date aggregationStartDate, Date aggregationEndDate) throws Exception {
        Bucket bucket = CouchBaseConnector.getInstance().connectionMap.get(ACCOUNTING_MANAGER_BUCKET_NAME);
        Expression expression = Expression.x((String)"`aggregationInfo`.`recordType`").eq(Expression.s((String[])new String[]{recordType}));
        expression = expression.and(Expression.x((String)"`aggregationInfo`.`aggregationType`").eq(Expression.s((String[])new String[]{aggregationType.name()})));
        String aggregationStartDateField = "`aggregationInfo`.`aggregationStartDate`";
        if (aggregationStartDate != null) {
            expression = expression.and(Expression.x((String)aggregationStartDateField).gte(Expression.s((String[])new String[]{Constant.DEFAULT_DATE_FORMAT.format(aggregationStartDate)})));
        }
        if (aggregationEndDate != null) {
            expression = expression.and(Expression.x((String)aggregationStartDateField).lte(Expression.s((String[])new String[]{Constant.DEFAULT_DATE_FORMAT.format(aggregationEndDate)})));
        }
        Sort sort = Sort.desc((String)aggregationStartDateField);
        OffsetPath statement = Select.select((String[])new String[]{"*"}).from(bucket.name()).where(expression).orderBy(new Sort[]{sort}).limit(1);
        logger.trace("Going to query : {}", (Object)statement.toString());
        N1qlQueryResult result = bucket.query((Statement)statement);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            return null;
        }
        List rows = result.allRows();
        if (rows.size() > 1) {
            String error = String.format("More than one Document found for query %. This is really strange and should not occur. Please contact the Administrator.", statement.toString());
            logger.error(error);
            throw new Exception(error);
        }
        if (rows.size() == 1) {
            N1qlQueryRow row = (N1qlQueryRow)rows.get(0);
            try {
                JsonObject jsonObject = row.value().getObject(bucket.name());
                logger.trace("JsonObject : {}", (Object)jsonObject.toString());
                return (AggregationStatus)DSMapper.getObjectMapper().readValue(jsonObject.toString(), AggregationStatus.class);
            }
            catch (Exception e) {
                logger.warn("Unable to elaborate result for {}", (Object)row.toString());
            }
        }
        return null;
    }

    public static List<AggregationStatus> getUnterminated(Date aggregationStartDate, Date aggregationEndDate) throws Exception {
        return CouchBaseConnector.getUnterminated(null, null, aggregationStartDate, aggregationEndDate);
    }

    public static List<AggregationStatus> getUnterminated(String recordType, AggregationType aggregationType, Date aggregationStartDate, Date aggregationEndDate) throws Exception {
        Bucket bucket = CouchBaseConnector.getInstance().connectionMap.get(ACCOUNTING_MANAGER_BUCKET_NAME);
        Calendar now = Utility.getUTCCalendarInstance();
        now.add(Constant.CALENDAR_FIELD_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED, -Constant.UNIT_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED);
        Expression expression = Expression.x((String)"`aggregationState`").ne(Expression.s((String[])new String[]{AggregationState.COMPLETED.name()}));
        expression = expression.and(Expression.x((String)"`lastUpdateTime`").lt(Expression.s((String[])new String[]{Constant.DEFAULT_DATE_FORMAT.format(now.getTime())})));
        if (recordType != null) {
            expression = expression.and(Expression.x((String)"`aggregationInfo`.`recordType`").eq(Expression.s((String[])new String[]{recordType})));
        }
        if (aggregationType != null) {
            expression = expression.and(Expression.x((String)"`aggregationInfo`.`aggregationType`").eq(Expression.s((String[])new String[]{aggregationType.name()})));
        }
        String aggregationStartDateField = "`aggregationInfo`.`aggregationStartDate`";
        if (aggregationStartDate != null) {
            expression = expression.and(Expression.x((String)aggregationStartDateField).gte(Expression.s((String[])new String[]{Constant.DEFAULT_DATE_FORMAT.format(aggregationStartDate)})));
        }
        if (aggregationEndDate != null) {
            expression = expression.and(Expression.x((String)aggregationStartDateField).lte(Expression.s((String[])new String[]{Constant.DEFAULT_DATE_FORMAT.format(aggregationEndDate)})));
        }
        Sort sort = Sort.asc((String)aggregationStartDateField);
        LimitPath statement = Select.select((String[])new String[]{"*"}).from(bucket.name()).where(expression).orderBy(new Sort[]{sort});
        logger.trace("Going to query : {}", (Object)statement.toString());
        N1qlQueryResult result = bucket.query((Statement)statement);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            return null;
        }
        List rows = result.allRows();
        ArrayList<AggregationStatus> aggregationStatuses = new ArrayList<AggregationStatus>(rows.size());
        for (N1qlQueryRow row : rows) {
            try {
                JsonObject jsonObject = row.value().getObject(bucket.name());
                logger.trace("JsonObject : {}", (Object)jsonObject.toString());
                AggregationStatus aggregationStatus = (AggregationStatus)DSMapper.getObjectMapper().readValue(jsonObject.toString(), AggregationStatus.class);
                aggregationStatuses.add(aggregationStatus);
            }
            catch (Exception e) {
                logger.warn("Unable to elaborate result for {}", (Object)row.toString());
            }
        }
        return aggregationStatuses;
    }

    public static AggregationStatus getAggregationStatus(String recordType, AggregationType aggregationType, Date aggregationStartDate) throws Exception {
        Bucket bucket = CouchBaseConnector.getInstance().connectionMap.get(ACCOUNTING_MANAGER_BUCKET_NAME);
        Expression expression = Expression.x((String)"`aggregationInfo`.`recordType`").eq(Expression.s((String[])new String[]{recordType}));
        expression = expression.and(Expression.x((String)"`aggregationInfo`.`aggregationType`").eq(Expression.s((String[])new String[]{aggregationType.name()})));
        expression = expression.and(Expression.x((String)"`aggregationInfo`.`aggregationStartDate`").eq(Expression.s((String[])new String[]{Constant.DEFAULT_DATE_FORMAT.format(aggregationStartDate)})));
        GroupByPath statement = Select.select((String[])new String[]{"*"}).from(bucket.name()).where(expression);
        logger.trace("Going to query : {}", (Object)statement.toString());
        N1qlQueryResult result = bucket.query((Statement)statement);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            return null;
        }
        List rows = result.allRows();
        if (rows.size() > 1) {
            String error = String.format("More than one Document found for query %s. This is really strange and should not occur. Please contact the Administrator.", statement.toString());
            logger.error(error);
            throw new Exception(error);
        }
        if (rows.size() == 1) {
            N1qlQueryRow row = (N1qlQueryRow)rows.get(0);
            try {
                JsonObject jsonObject = row.value().getObject(bucket.name());
                logger.trace("JsonObject : {}", (Object)jsonObject.toString());
                return (AggregationStatus)DSMapper.getObjectMapper().readValue(jsonObject.toString(), AggregationStatus.class);
            }
            catch (Exception e) {
                logger.warn("Unable to elaborate result for {}", (Object)row.toString());
            }
        }
        return null;
    }

    public static void upsertAggregationStatus(AggregationStatus aggregationStatus) throws Exception {
        Bucket bucket = CouchBaseConnector.getInstance().connectionMap.get(ACCOUNTING_MANAGER_BUCKET_NAME);
        JsonObject jsonObject = JsonObject.fromJson((String)DSMapper.getObjectMapper().writeValueAsString((Object)aggregationStatus));
        JsonDocument jsonDocument = JsonDocument.create((String)aggregationStatus.getUUID().toString(), (JsonObject)jsonObject);
        try {
            bucket.upsert((Document)jsonDocument, PersistTo.MASTER, CONNECTION_TIMEOUT_BUCKET, TimeUnit.SECONDS);
        }
        catch (DocumentAlreadyExistsException documentAlreadyExistsException) {
            // empty catch block
        }
    }

    public static enum SUFFIX {
        src,
        dst;

    }
}

