package org.gcube.accounting.aggregator.persist;

import java.io.File;

import org.gcube.accounting.aggregator.persistence.PostgreSQLConnector;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.documentstore.records.DSMapper;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class DeleteDocument extends DocumentElaboration {
	
	public DeleteDocument(AggregationStatus aggregationStatus, File file){
		super(aggregationStatus, AggregationState.DELETED, file, aggregationStatus.getOriginalRecordsNumber());
	}
	
	@Override
	protected void elaborateLine(String line) throws Exception {
		JsonNode jsonNode = DSMapper.asJsonNode(line);
		String id = jsonNode.get(ID).asText();
		logger.trace("Going to delete record with id {}", id);
		PostgreSQLConnector postgreSQLConnector = PostgreSQLConnector.getPostgreSQLConnector();
		postgreSQLConnector.deleteRecord(jsonNode);
	}

	@Override
	protected void afterElaboration() {
		// Nothing to do
	}
	
}
