/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.accounting.aggregator.persist.DocumentElaboration;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistencePostgreSQL;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;

public class InsertDocument
extends DocumentElaboration {
    public static final String CSV_FILENAME_SUFFIX = ".calledMethods.csv";
    protected Map<String, Map<String, Integer>> serviceClassName_calledMethods = new TreeMap<String, Map<String, Integer>>();
    protected List<String> unparsableLines = new ArrayList<String>();
    protected boolean serviceUsageRecordElaboration = false;
    protected File calledMethodCSVFile;
    protected PersistencePostgreSQL persistencePostgreSQL;
    protected int count;

    public InsertDocument(AggregationStatus aggregationStatus, File file) throws Exception {
        super(aggregationStatus, AggregationState.ADDED, file, aggregationStatus.getAggregatedRecordsNumber());
        File destinationFolder = file.getParentFile();
        this.calledMethodCSVFile = new File(destinationFolder, file.getName().replace(".aggregated.json", CSV_FILENAME_SUFFIX));
        AccountingPersistenceConfiguration accountingPersistenceConfiguration = new AccountingPersistenceConfiguration(PersistencePostgreSQL.class);
        this.persistencePostgreSQL = new PersistencePostgreSQL();
        this.persistencePostgreSQL.prepareConnection((PersistenceBackendConfiguration)accountingPersistenceConfiguration);
        this.count = 0;
    }

    protected String getKey(JsonNode jsonNode) {
        String serviceClass = jsonNode.get("serviceClass").asText();
        String serviceName = jsonNode.get("serviceName").asText();
        return serviceClass + "," + serviceName;
    }

    protected void addServiceClassName_calledMethods(JsonNode jsonNode) {
        String key = this.getKey(jsonNode);
        String calledMethod = jsonNode.get("calledMethod").asText();
        int operationCount = 0;
        try {
            operationCount = jsonNode.get("operationCount").asInt();
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        Map<String, Integer> calledMethodsMap = this.serviceClassName_calledMethods.get(key);
        if (calledMethodsMap == null) {
            calledMethodsMap = new TreeMap<String, Integer>();
            this.serviceClassName_calledMethods.put(key, calledMethodsMap);
        }
        if (!calledMethodsMap.containsKey(calledMethod)) {
            calledMethodsMap.put(calledMethod, operationCount);
        } else {
            int operationCountOnMap = calledMethodsMap.get(calledMethod);
            int sum = operationCountOnMap + operationCount;
            calledMethodsMap.put(calledMethod, sum);
        }
    }

    protected JsonNode analyseLine(String line) throws JsonProcessingException, IOException {
        JsonNode jsonNode = DSMapper.asJsonNode((String)line);
        if (this.serviceUsageRecordElaboration) {
            try {
                this.addServiceClassName_calledMethods(jsonNode);
            }
            catch (Throwable e) {
                this.unparsableLines.add(line);
            }
        }
        return jsonNode;
    }

    @Override
    protected void elaborateLine(String line) throws Exception {
        JsonNode jsonNode = this.analyseLine(line);
        Record record = RecordUtility.getRecord((String)jsonNode.toString());
        this.persistencePostgreSQL.insert(record);
        ++this.count;
        if (this.count == 100) {
            this.persistencePostgreSQL.commitAndClose();
            this.count = 0;
        }
    }

    @Override
    protected void afterElaboration() throws Exception {
        this.persistencePostgreSQL.commitAndClose();
        this.count = 0;
        if (this.serviceUsageRecordElaboration) {
            if (this.calledMethodCSVFile.exists()) {
                this.calledMethodCSVFile.delete();
            }
            for (String key : this.serviceClassName_calledMethods.keySet()) {
                Map<String, Integer> calledMethodsMap = this.serviceClassName_calledMethods.get(key);
                for (String calledMethod : calledMethodsMap.keySet()) {
                    try {
                        int operationCount = calledMethodsMap.get(calledMethod);
                        Utility.printLine(this.calledMethodCSVFile, "\"" + key.replace(",", "\",\"") + "\",\"" + calledMethod + "\",\"" + String.valueOf(operationCount) + "\"");
                    }
                    catch (Throwable e) {
                        this.logger.error("Unable to print CSV line : {},{}", (Object)key, (Object)calledMethod);
                    }
                }
            }
            if (!this.unparsableLines.isEmpty()) {
                try {
                    Utility.printLine(this.calledMethodCSVFile, "");
                    Utility.printLine(this.calledMethodCSVFile, "------------------------------------------------------------------");
                    Utility.printLine(this.calledMethodCSVFile, "Unparsable Lines");
                    Utility.printLine(this.calledMethodCSVFile, "");
                }
                catch (Throwable e) {
                    this.logger.error("Unable to add separator for unparsable lines in CSV");
                }
                for (String unparsableLine : this.unparsableLines) {
                    try {
                        Utility.printLine(this.calledMethodCSVFile, unparsableLine);
                    }
                    catch (Throwable e) {
                        this.logger.error("Unable to print unparsable line in CSV : {}", (Object)unparsableLine);
                    }
                }
            }
        }
    }

    public void setServiceUsageRecordElaboration(boolean serviceUsageRecordElaboration) {
        this.serviceUsageRecordElaboration = serviceUsageRecordElaboration;
    }

    public File getCalledMethodCSVFile() {
        return this.calledMethodCSVFile;
    }
}

