/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persistence;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.aggregation.AggregationInfo;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceDst;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceSrc;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceStatus;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStateEvent;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.accounting.utility.postgresql.RecordToDBMapping;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistencePostgreSQL;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.postgresql.core.Utils;

public class PostgreSQLConnector
extends PersistencePostgreSQL
implements AggregatorPersistenceSrc,
AggregatorPersistenceDst,
AggregatorPersistenceStatus {
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    private static final String UTC_TIME_ZONE = "UTC";
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    protected AccountingPersistenceConfiguration configuration;
    protected Connection connection;

    protected PostgreSQLConnector(Class<?> clazz) throws Exception {
        this.configuration = new AccountingPersistenceConfiguration(clazz);
        this.prepareConnection((PersistenceBackendConfiguration)this.configuration);
    }

    protected Connection getConnection() throws Exception {
        if (this.connection == null || this.connection.isClosed()) {
            String url = this.configuration.getProperty("URL");
            if (this.connection != null && this.connection.isClosed()) {
                logger.warn("The connection was closed. We should investigate why. Going to reconnect to {}.", (Object)url);
            }
            Class.forName("org.postgresql.Driver");
            String username = this.configuration.getProperty("username");
            String password = this.configuration.getProperty("password");
            this.connection = DriverManager.getConnection(url, username, password);
            logger.trace("Database {} opened successfully", (Object)url);
            this.connection.setAutoCommit(false);
        }
        return this.connection;
    }

    protected String getQuotedString(String string) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("'");
        Utils.escapeLiteral((StringBuilder)builder, (String)string, (boolean)false);
        builder.append("'");
        return builder.toString();
    }

    protected String getValue(Serializable serializable) throws SQLException {
        if (serializable == null) {
            return "null";
        }
        if (serializable instanceof Number) {
            return serializable.toString();
        }
        if (serializable instanceof Calendar) {
            Calendar calendar = (Calendar)serializable;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
            simpleDateFormat.setTimeZone(DEFAULT_TIME_ZONE);
            java.util.Date date = calendar.getTime();
            String dateString = simpleDateFormat.format(date);
            return this.getQuotedString(dateString);
        }
        if (serializable instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)serializable;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
            simpleDateFormat.setTimeZone(DEFAULT_TIME_ZONE);
            String dateString = simpleDateFormat.format(date);
            return this.getQuotedString(dateString);
        }
        if (serializable instanceof Enum) {
            Enum e = (Enum)((Object)serializable);
            return this.getQuotedString(e.name());
        }
        return this.getQuotedString(serializable.toString());
    }

    protected String getInsertAggregationStatusQuery(AggregationStatus aggregationStatus, boolean upsert) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append("aggregation_status");
        stringBuffer.append(" (id, ");
        stringBuffer.append("record_type, aggregation_type, aggregation_start_date, aggregation_end_date, ");
        stringBuffer.append("original_records_number, aggregated_records_number, recovered_records_number, malformed_records_number,  percentage, ");
        stringBuffer.append("restart_from, ");
        stringBuffer.append("context, current_aggregation_state, last_update_time, previous)");
        stringBuffer.append(" VALUES (");
        stringBuffer.append(this.getValue((Serializable)((Object)aggregationStatus.getUUID().toString())));
        AggregationInfo aggregationInfo = aggregationStatus.getAggregationInfo();
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue((Serializable)((Object)aggregationInfo.getRecordType())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue((Serializable)((Object)aggregationInfo.getAggregationType())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(aggregationInfo.getAggregationStartDate()));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(aggregationInfo.getAggregationEndDate()));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(Integer.valueOf(aggregationStatus.getOriginalRecordsNumber())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(Integer.valueOf(aggregationStatus.getAggregatedRecordsNumber())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(Integer.valueOf(aggregationStatus.getRecoveredRecordNumber())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(Integer.valueOf(aggregationStatus.getMalformedRecordNumber())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(Float.valueOf(aggregationStatus.getPercentage())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(Integer.valueOf(aggregationStatus.getRestartFrom())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue((Serializable)((Object)aggregationStatus.getContext())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue((Serializable)((Object)aggregationStatus.getAggregationState())));
        stringBuffer.append(", ");
        stringBuffer.append(this.getValue(aggregationStatus.getLastUpdateTime()));
        stringBuffer.append(", ");
        AggregationStatus previous = aggregationStatus.getPrevious();
        if (previous != null) {
            stringBuffer.append(this.getValue((Serializable)((Object)previous.getUUID().toString())));
        } else {
            stringBuffer.append(this.getValue(null));
        }
        if (upsert) {
            stringBuffer.append(") ON CONFLICT (id) DO UPDATE SET ");
            stringBuffer.append("original_records_number=EXCLUDED.original_records_number, ");
            stringBuffer.append("aggregated_records_number=EXCLUDED.aggregated_records_number, ");
            stringBuffer.append("recovered_records_number=EXCLUDED.recovered_records_number, ");
            stringBuffer.append("malformed_records_number=EXCLUDED.malformed_records_number, ");
            stringBuffer.append("percentage=EXCLUDED.percentage, ");
            stringBuffer.append("restart_from=EXCLUDED.restart_from, ");
            stringBuffer.append("current_aggregation_state=EXCLUDED.current_aggregation_state, ");
            stringBuffer.append("last_update_time=EXCLUDED.last_update_time, previous=EXCLUDED.previous;");
        } else {
            stringBuffer.append(");");
        }
        return stringBuffer.toString();
    }

    protected String getInsertAggregationStateQuery(AggregationStatus aggregationStatus) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        for (AggregationStateEvent aggregationStateEvent : aggregationStatus.getAggregationStateEvents()) {
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append("aggregation_status_event");
            stringBuffer.append(" ( aggregation_state, start_time, end_time, aggregation_status)");
            stringBuffer.append(" VALUES (");
            stringBuffer.append(this.getValue((Serializable)((Object)aggregationStateEvent.getAggregationState())));
            stringBuffer.append(", ");
            stringBuffer.append(this.getValue(aggregationStateEvent.getStartTime()));
            stringBuffer.append(", ");
            stringBuffer.append(this.getValue(aggregationStateEvent.getEndTime()));
            stringBuffer.append(", ");
            stringBuffer.append(this.getValue((Serializable)((Object)aggregationStatus.getUUID().toString())));
            stringBuffer.append(") ON CONFLICT DO NOTHING;");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsertAggregationStatus(AggregationStatus aggregationStatus) throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                Connection connection = this.getConnection();
                Statement statement = connection.createStatement();
                String sqlCommand = this.getInsertAggregationStatusQuery(aggregationStatus, true);
                statement.executeUpdate(sqlCommand);
                sqlCommand = this.getInsertAggregationStateQuery(aggregationStatus);
                statement.executeUpdate(sqlCommand);
                statement.close();
                connection.commit();
                break;
            }
            catch (Throwable e) {
                if (i < 3) {
                    long delay = TimeUnit.MILLISECONDS.toMillis(100L);
                    logger.error("Unable to upsert aggregation status at attemp {}. Retrying in {} millis.", new Object[]{i, delay, e});
                    Thread.sleep(delay);
                    continue;
                }
                logger.error("Unable to upsert aggregation status.", e);
                throw e;
            }
            finally {
                this.connection.close();
            }
        }
    }

    private java.util.Date getDateFromResultSet(ResultSet resultSet, String columnLabel) throws Exception {
        String dateString = resultSet.getString(columnLabel);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssX");
        java.util.Date date = dateFormat.parse(dateString);
        return date;
    }

    protected AggregationStatus getAggregationStatusFromResultSet(ResultSet resultSet) throws Exception {
        String recordType = resultSet.getString("record_type");
        String aggregationTypeString = resultSet.getString("aggregation_type");
        AggregationType aggregationType = AggregationType.valueOf(aggregationTypeString);
        java.util.Date aggregationStartDate = this.getDateFromResultSet(resultSet, "aggregation_start_date");
        java.util.Date aggregationEndDate = this.getDateFromResultSet(resultSet, "aggregation_end_date");
        AggregationInfo aggregationInfo = new AggregationInfo(recordType, aggregationType, aggregationStartDate, aggregationEndDate);
        AggregationStatus aggregationStatus = new AggregationStatus(aggregationInfo);
        UUID uuid = UUID.fromString(resultSet.getString("id"));
        aggregationStatus.setUUID(uuid);
        int originalRecordsNumber = resultSet.getInt("original_records_number");
        int aggregatedRecordsNumber = resultSet.getInt("aggregated_records_number");
        int malformedRecordNumber = resultSet.getInt("malformed_records_number");
        aggregationStatus.setRecordNumbers(originalRecordsNumber, aggregatedRecordsNumber, malformedRecordNumber);
        int restartFrom = resultSet.getInt("restart_from");
        aggregationStatus.setRestartFrom(restartFrom, false);
        String context = resultSet.getString("context");
        aggregationStatus.setContext(context);
        String current_aggregation_state = resultSet.getString("current_aggregation_state");
        AggregationState aggregationState = AggregationState.valueOf(current_aggregation_state);
        aggregationStatus.setAggregationState(aggregationState);
        Date last_update_time = resultSet.getDate("last_update_time");
        Calendar lastUpdateTime = Calendar.getInstance();
        lastUpdateTime.setTime(last_update_time);
        aggregationStatus.setLastUpdateTime(lastUpdateTime);
        return aggregationStatus;
    }

    @Override
    public AggregationStatus getLast(String recordType, AggregationType aggregationType, java.util.Date aggregationStartDate, java.util.Date aggregationEndDate) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT * ");
        stringBuffer.append("FROM aggregation_status");
        stringBuffer.append(" WHERE ");
        stringBuffer.append("record_type = ");
        stringBuffer.append(this.getValue((Serializable)((Object)recordType)));
        stringBuffer.append(" AND ");
        stringBuffer.append("aggregation_type = ");
        stringBuffer.append(this.getValue((Serializable)((Object)aggregationType.name())));
        if (aggregationStartDate != null && aggregationEndDate != null) {
            stringBuffer.append(" AND ");
            stringBuffer.append("aggregation_start_date >= ");
            stringBuffer.append(this.getValue(aggregationStartDate));
            stringBuffer.append(" AND ");
            stringBuffer.append("aggregation_start_date <= ");
            stringBuffer.append(this.getValue(aggregationEndDate));
        }
        stringBuffer.append(" ORDER BY ");
        stringBuffer.append("aggregation_start_date DESC LIMIT 1");
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlQuery = stringBuffer.toString();
        logger.trace("Going to request the following query: {}", (Object)sqlQuery);
        ResultSet resultSet = statement.executeQuery(sqlQuery);
        AggregationStatus aggregationStatus = null;
        if (resultSet.next()) {
            aggregationStatus = this.getAggregationStatusFromResultSet(resultSet);
        }
        return aggregationStatus;
    }

    @Override
    public List<AggregationStatus> getUnterminated(String recordType, AggregationType aggregationType, java.util.Date aggregationStartDate, java.util.Date aggregationEndDate, boolean forceRestart) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT * ");
        stringBuffer.append("FROM aggregation_status");
        stringBuffer.append(" WHERE ");
        stringBuffer.append("current_aggregation_state != ");
        stringBuffer.append(this.getValue((Serializable)((Object)AggregationState.COMPLETED)));
        if (!forceRestart) {
            Calendar now = Utility.getUTCCalendarInstance();
            now.add(Constant.CALENDAR_FIELD_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED, -Constant.UNIT_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED);
            stringBuffer.append(" AND ");
            stringBuffer.append("last_update_time < ");
            stringBuffer.append(this.getValue(now));
        }
        if (recordType != null) {
            stringBuffer.append(" AND ");
            stringBuffer.append("record_type = ");
            stringBuffer.append(this.getValue((Serializable)((Object)recordType)));
        }
        if (aggregationType != null) {
            stringBuffer.append(" AND ");
            stringBuffer.append("aggregation_type = ");
            stringBuffer.append(this.getValue((Serializable)((Object)aggregationType)));
        }
        if (aggregationStartDate != null && aggregationEndDate != null) {
            stringBuffer.append(" AND ");
            stringBuffer.append("aggregation_start_date >= ");
            stringBuffer.append(this.getValue(aggregationStartDate));
            stringBuffer.append(" AND ");
            stringBuffer.append("aggregation_end_date <= ");
            stringBuffer.append(this.getValue(aggregationEndDate));
        }
        stringBuffer.append(" ORDER BY ");
        stringBuffer.append("aggregation_start_date ASC");
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlQuery = stringBuffer.toString();
        logger.trace("Going to request the following query: {}", (Object)sqlQuery);
        ResultSet resultSet = statement.executeQuery(sqlQuery);
        ArrayList<AggregationStatus> aggregationStatuses = new ArrayList<AggregationStatus>();
        while (resultSet.next()) {
            AggregationStatus aggregationStatus = this.getAggregationStatusFromResultSet(resultSet);
            aggregationStatuses.add(aggregationStatus);
        }
        return aggregationStatuses;
    }

    @Override
    public List<AggregationStatus> getAll() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT * ");
        stringBuffer.append("FROM aggregation_status ");
        stringBuffer.append("ORDER BY aggregation_start_date ASC");
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlQuery = stringBuffer.toString();
        logger.trace("Going to request the following query: {}", (Object)sqlQuery);
        ResultSet resultSet = statement.executeQuery(sqlQuery);
        ArrayList<AggregationStatus> aggregationStatuses = new ArrayList<AggregationStatus>();
        while (resultSet.next()) {
            AggregationStatus aggregationStatus = this.getAggregationStatusFromResultSet(resultSet);
            aggregationStatuses.add(aggregationStatus);
        }
        return aggregationStatuses;
    }

    @Override
    public AggregationStatus getAggregationStatus(String recordType, AggregationType aggregationType, java.util.Date aggregationStartDate) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT * ");
        stringBuffer.append("FROM aggregation_status");
        stringBuffer.append(" WHERE ");
        stringBuffer.append("record_type = ");
        stringBuffer.append(this.getValue((Serializable)((Object)recordType)));
        stringBuffer.append(" AND ");
        stringBuffer.append("aggregation_type = ");
        stringBuffer.append(this.getValue((Serializable)((Object)aggregationType.name())));
        stringBuffer.append(" AND ");
        stringBuffer.append("aggregation_start_date = ");
        stringBuffer.append(this.getValue(aggregationStartDate));
        stringBuffer.append(" ORDER BY ");
        stringBuffer.append("last_update_time DESC LIMIT 1");
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlQuery = stringBuffer.toString();
        logger.trace("Going to request the following query: {}", (Object)sqlQuery);
        ResultSet resultSet = statement.executeQuery(sqlQuery);
        AggregationStatus aggregationStatus = null;
        if (resultSet.next()) {
            aggregationStatus = this.getAggregationStatusFromResultSet(resultSet);
        }
        return aggregationStatus;
    }

    @Override
    public void deleteRecord(JsonNode jsonNode) throws Exception {
        Record record = DSMapper.unmarshal(Record.class, (String)jsonNode.toString());
        Class<?> clz = record.getClass();
        String type = RecordToDBMapping.getRecordTypeByClass(clz);
        String tableName = RecordToDBFields.getKey((String)type);
        String id = jsonNode.get("id").asText();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ");
        stringBuffer.append("FROM ");
        stringBuffer.append(tableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append("id = ");
        stringBuffer.append(this.getValue((Serializable)((Object)id)));
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlCommand = stringBuffer.toString();
        logger.trace("Going to execute {}", (Object)sqlCommand);
        statement.execute(sqlCommand);
        statement.close();
        connection.commit();
    }

    @Override
    public ResultSet getResultSetOfRecordToBeAggregated(AggregationStatus aggregationStatus) throws Exception {
        AggregationInfo aggregationInfo = aggregationStatus.getAggregationInfo();
        String tableName = RecordToDBFields.getKey((String)aggregationInfo.getRecordType());
        String startTimeColumnName = RecordToDBFields.getKey((String)"startTime");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT *");
        stringBuffer.append(" FROM ");
        stringBuffer.append(tableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(startTimeColumnName);
        stringBuffer.append(" >= ");
        stringBuffer.append(this.getValue(aggregationInfo.getAggregationStartDate()));
        stringBuffer.append(" AND ");
        stringBuffer.append(startTimeColumnName);
        stringBuffer.append(" < ");
        stringBuffer.append(this.getValue(aggregationInfo.getAggregationEndDate()));
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlQuery = stringBuffer.toString();
        logger.trace("Going to request the following query: {}", (Object)sqlQuery);
        ResultSet resultSet = statement.executeQuery(sqlQuery);
        return resultSet;
    }

    @Override
    public int getEstimatedRecordRecordToBeAggregated(AggregationStatus aggregationStatus) throws Exception {
        AggregationInfo aggregationInfo = aggregationStatus.getAggregationInfo();
        String tableName = RecordToDBFields.getKey((String)aggregationInfo.getRecordType());
        String startTimeColumnName = RecordToDBFields.getKey((String)"startTime");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(*)");
        stringBuffer.append(" FROM ");
        stringBuffer.append(tableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(startTimeColumnName);
        stringBuffer.append(" >= ");
        stringBuffer.append(this.getValue(aggregationInfo.getAggregationStartDate()));
        stringBuffer.append(" AND ");
        stringBuffer.append(startTimeColumnName);
        stringBuffer.append(" < ");
        stringBuffer.append(this.getValue(aggregationInfo.getAggregationEndDate()));
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlQuery = stringBuffer.toString();
        logger.trace("Going to request the following query: {}", (Object)sqlQuery);
        ResultSet resultSet = statement.executeQuery(sqlQuery);
        resultSet.next();
        return resultSet.getInt(1);
    }

    @Override
    public boolean isBulkDeleteAllowed() {
        return true;
    }

    @Override
    public void deleteRecords(ArrayNode array) throws UnsupportedOperationException, Exception {
        if (array.size() < 1) {
            return;
        }
        Record record = DSMapper.unmarshal(Record.class, (String)array.get(0).toString());
        Class<?> clz = record.getClass();
        String type = RecordToDBMapping.getRecordTypeByClass(clz);
        String tableName = RecordToDBFields.getKey((String)type);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE ");
        stringBuffer.append("FROM ");
        stringBuffer.append(tableName);
        stringBuffer.append(" WHERE ");
        String id = record.getId();
        stringBuffer.append("id = ");
        stringBuffer.append(this.getValue((Serializable)((Object)id)));
        for (int i = 1; i < array.size(); ++i) {
            stringBuffer.append(" OR ");
            id = array.get(i).get("id").asText();
            stringBuffer.append("id = ");
            stringBuffer.append(this.getValue((Serializable)((Object)id)));
        }
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        String sqlCommand = stringBuffer.toString();
        logger.trace("Going to execute {}", (Object)sqlCommand);
        statement.execute(sqlCommand);
        statement.close();
        connection.commit();
    }
}

