/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentElaboration {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String ID = "id";
    public static final int MAX_RETRY = 7;
    public static final int MAX_ROWS_PER_STEP = 500;
    protected final AggregationStatus aggregationStatus;
    protected final File file;
    protected final AggregationState finalAggregationState;
    protected final int rowToBeElaborated;
    protected int currentlyElaborated;
    protected Calendar startTime;
    protected int effectiveMaxRowPerStep;

    protected DocumentElaboration(AggregationStatus statusManager, AggregationState finalAggregationState, File file, int rowToBeElaborated) {
        this.aggregationStatus = statusManager;
        this.finalAggregationState = finalAggregationState;
        this.file = file;
        this.rowToBeElaborated = rowToBeElaborated;
        this.currentlyElaborated = 0;
    }

    protected void readFile() throws Exception {
        FileInputStream fstream = null;
        FilterInputStream in = null;
        BufferedReader br = null;
        try {
            String line;
            fstream = new FileInputStream(this.file);
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));
            this.logger.info("{} - Going to elaborate {} rows", (Object)this.aggregationStatus.getAggregationInfo(), (Object)this.rowToBeElaborated);
            this.effectiveMaxRowPerStep = this.rowToBeElaborated / 10 + 1;
            if (this.effectiveMaxRowPerStep > 500) {
                this.effectiveMaxRowPerStep = 500;
            }
            this.currentlyElaborated = 0;
            int restartFrom = this.aggregationStatus.getRestartFrom();
            if (restartFrom > 0) {
                this.logger.info("The elaboration will be restarted from record number {}", (Object)this.aggregationStatus.getRestartFrom());
            }
            while ((line = br.readLine()) != null) {
                boolean elaborate = true;
                long delay = TimeUnit.MILLISECONDS.toMillis(100L);
                int i = 0;
                while (elaborate) {
                    ++i;
                    if (this.currentlyElaborated < restartFrom) break;
                    try {
                        this.elaborateLine(line);
                        elaborate = false;
                    }
                    catch (Exception e) {
                        if (i != 1) {
                            this.logger.debug("Elaboration of line {} failed due to {}. Retrying {}{} time in {} {}", new Object[]{line, e.getMessage(), i, i == 2 ? "nd" : (i == 3 ? "rd" : "th"), delay, TimeUnit.MILLISECONDS.name().toLowerCase()});
                        } else {
                            this.logger.warn("Elaboration of line {} failed due to {}. Retrying in {} {}", new Object[]{line, e.getMessage(), delay, TimeUnit.MILLISECONDS.name().toLowerCase()});
                        }
                        if (i < 7) {
                            TimeUnit.MILLISECONDS.sleep(delay);
                            delay *= 2L;
                            continue;
                        }
                        throw e;
                    }
                }
                ++this.currentlyElaborated;
                if (this.currentlyElaborated % this.effectiveMaxRowPerStep == 0) {
                    if (this.currentlyElaborated >= restartFrom) {
                        this.aggregationStatus.setRestartFrom(this.currentlyElaborated, true);
                    }
                    int elaboratedPercentage = this.currentlyElaborated * 100 / this.rowToBeElaborated;
                    this.logger.info("{} - Elaborated {} rows of {} (about {}%)", new Object[]{this.aggregationStatus.getAggregationInfo(), this.currentlyElaborated, this.rowToBeElaborated, elaboratedPercentage});
                }
                if (this.currentlyElaborated <= this.rowToBeElaborated) continue;
                throw new Exception("Elaborated file line is number " + this.currentlyElaborated + " > " + this.rowToBeElaborated + " (total number of rows to elaborate). This is really strange and should not occur. Stopping execution");
            }
            if (this.currentlyElaborated != this.rowToBeElaborated) {
                throw new Exception("Elaborated file line is number " + this.currentlyElaborated + " != " + this.rowToBeElaborated + "(total number of rows to elaborate). This is really strange and should not occur. Stopping execution");
            }
            this.logger.info("{} - Elaborated {} rows of {} ({}%)", new Object[]{this.aggregationStatus.getAggregationInfo(), this.currentlyElaborated, this.rowToBeElaborated, 100});
        }
        catch (Exception e) {
            this.logger.error("Error while elaborating file {}", (Object)this.file.getAbsolutePath(), (Object)e);
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (fstream != null) {
                fstream.close();
            }
        }
    }

    public void elaborate() throws Exception {
        this.startTime = Utility.getUTCCalendarInstance();
        try {
            this.readFile();
            this.aggregationStatus.setAggregationState(this.finalAggregationState, this.startTime, true);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.afterElaboration();
        }
    }

    protected abstract void elaborateLine(String var1) throws Exception;

    protected abstract void afterElaboration() throws Exception;
}

