/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.view.OnError;
import com.couchbase.client.java.view.View;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageServiceValue;
import org.gcube.accounting.analytics.UsageStorageValue;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.exception.DuplicatedKeyFilterException;
import org.gcube.accounting.analytics.exception.ValueException;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceQueryCouchBase
implements AccountingPersistenceBackendQuery {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceQueryCouchBase.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String BUCKET_STORAGE_NAME_PROPERTY_KEY = "AggregatedStorageUsageRecord";
    public static final String BUCKET_STORAGESTATUS_NAME_PROPERTY_KEY = "AggregatedStorageStatusRecord";
    public static final String BUCKET_SERVICE_NAME_PROPERTY_KEY = "AggregatedServiceUsageRecord";
    public static final String BUCKET_PORTLET_NAME_PROPERTY_KEY = "AggregatedPortletUsageRecord";
    public static final String BUCKET_JOB_NAME_PROPERTY_KEY = "AggregatedJobUsageRecord";
    public static final String BUCKET_TASK_NAME_PROPERTY_KEY = "AggregatedTaskUsageRecord";
    public static final String DESIGN_DOC_ID_LIST_USAGE = "ListUsage";
    public static final long ENV_TIME_OUT = 240000L;
    public static final long QUERY_TIME_OUT = 360000L;
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(360000L).maxRequestLifetime(360000L).queryTimeout(360000L).build();
    protected Cluster cluster;
    protected Bucket bucketStorage;
    protected String bucketNameStorage;
    protected Bucket bucketStorageStatus;
    protected String bucketNameStorageStatus;
    protected Bucket bucketService;
    protected String bucketNameService;
    protected Bucket bucketPortlet;
    protected String bucketNamePortlet;
    protected Bucket bucketJob;
    protected String bucketNameJob;
    protected Bucket bucketTask;
    protected String bucketNameTask;
    private Map<String, Bucket> connectionMap;
    protected static final String MAP_REDUCE__DESIGN = "";
    protected static final String MAP_REDUCE_ALL = "all";
    protected static final String KEYS_SEPARATOR = "__";
    protected static final String DESIGN_DOC_ID = "top_";

    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        String password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
        this.bucketNameStorage = configuration.getProperty(BUCKET_STORAGE_NAME_PROPERTY_KEY);
        this.bucketNameStorageStatus = configuration.getProperty(BUCKET_STORAGESTATUS_NAME_PROPERTY_KEY);
        this.bucketNameService = configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY);
        this.bucketNameJob = configuration.getProperty(BUCKET_JOB_NAME_PROPERTY_KEY);
        this.bucketNamePortlet = configuration.getProperty(BUCKET_PORTLET_NAME_PROPERTY_KEY);
        this.bucketNameTask = configuration.getProperty(BUCKET_TASK_NAME_PROPERTY_KEY);
        this.connectionMap = new HashMap<String, Bucket>();
        this.bucketStorage = this.cluster.openBucket(this.bucketNameStorage, password);
        this.connectionMap.put(BUCKET_STORAGE_NAME_PROPERTY_KEY, this.bucketStorage);
        this.bucketStorageStatus = this.cluster.openBucket(this.bucketNameStorageStatus, password);
        this.connectionMap.put(BUCKET_STORAGESTATUS_NAME_PROPERTY_KEY, this.bucketStorageStatus);
        logger.debug("connectionMap" + this.connectionMap.toString());
        this.bucketService = this.cluster.openBucket(this.bucketNameService, password);
        this.connectionMap.put(BUCKET_SERVICE_NAME_PROPERTY_KEY, this.bucketService);
        this.bucketJob = this.cluster.openBucket(this.bucketNameJob, password);
        this.connectionMap.put(BUCKET_JOB_NAME_PROPERTY_KEY, this.bucketJob);
        this.bucketPortlet = this.cluster.openBucket(this.bucketNamePortlet, password);
        this.connectionMap.put(BUCKET_PORTLET_NAME_PROPERTY_KEY, this.bucketPortlet);
        this.bucketTask = this.cluster.openBucket(this.bucketNameTask, password);
        this.connectionMap.put(BUCKET_TASK_NAME_PROPERTY_KEY, this.bucketTask);
        logger.trace("Open cluster Service Bucket Url:" + url + " BucketName:" + configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY));
    }

    public void close() throws Exception {
        this.cluster.disconnect();
    }

    protected Calendar getCalendar(JSONObject obj, TemporalConstraint.AggregationMode aggregationMode) throws NumberFormatException, JSONException {
        long millis;
        if (obj.has("startTime")) {
            millis = new Long(obj.getString("startTime"));
            logger.trace("The result {} was from an aggregated record. Using {}", (Object)obj.toString(), (Object)"startTime");
        } else {
            millis = new Long(obj.getString("creationTime"));
            logger.trace("The result {} was from single record. Using {}", (Object)obj.toString(), (Object)"creationTime");
        }
        Calendar calendar = TemporalConstraint.getAlignedCalendar((long)millis, (TemporalConstraint.AggregationMode)aggregationMode);
        logger.trace("{} has been aligned to {}", (Object)millis, (Object)calendar.getTimeInMillis());
        return calendar;
    }

    @Deprecated
    protected Map<Calendar, Info> selectQuery(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String recordType = clz.newInstance().getRecordType();
        Expression expression = Expression.x((String)"scope").eq(Expression.s((String[])new String[]{currentScope}));
        expression = expression.and(Expression.x((String)"recordType").eq(Expression.s((String[])new String[]{recordType})));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        expression = expression.and(Expression.x((String)"startTime").gt(startTime).or(Expression.x((String)"creationTime").gt(startTime)));
        long endTime = temporalConstraint.getAlignedEndTime().getTimeInMillis();
        expression = expression.and(Expression.x((String)"endTime").lt(endTime)).or(Expression.x((String)"creationTime").lt(endTime));
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        if (filters != null) {
            for (Filter filter : filters) {
                expression = expression.and(Expression.x((String)filter.getKey()).eq(Expression.s((String[])new String[]{filter.getValue()})));
            }
        }
        GroupByPath groupByPath = Select.select((String[])new String[]{"*"}).from(this.connectionMap.get(clz.getSimpleName()).name()).where(expression);
        HashMap<Calendar, Info> map = new HashMap<Calendar, Info>();
        N1qlQueryResult result = this.connectionMap.get(clz.getSimpleName()).query((Statement)groupByPath);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            return map;
        }
        List rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                logger.trace("Row : {}", (Object)row.toString());
                JsonObject jsonObject = row.value().getObject(clz.getSimpleName());
                logger.trace("JsonObject : {}", (Object)row.toString());
                String recordString = jsonObject.toMap().toString();
                logger.trace("Record String : {}", (Object)recordString);
                Record record = RecordUtility.getRecord((String)recordString);
                JSONObject obj = new JSONObject(jsonObject.toString());
                Calendar calendar = this.getCalendar(obj, aggregationMode);
                if (map.containsKey(calendar)) {
                    Info info = (Info)map.get(calendar);
                    JSONObject value = info.getValue();
                    jsonObject.toMap();
                } else {
                    map.put(calendar, new Info(calendar, obj));
                }
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
            }
            logger.trace("\n\n\n");
        }
        return map;
    }

    protected Calendar getCalendarFromArray(JsonArray array) throws JSONException {
        boolean startFound = false;
        Calendar calendar = Calendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        int count = 0;
        TemporalConstraint.CalendarEnum[] calendarValues = TemporalConstraint.CalendarEnum.values();
        for (int i = 0; i < array.size(); ++i) {
            try {
                int value = array.getInt(i);
                int calendarValue = calendarValues[count].getCalendarValue();
                if (calendarValue == 2) {
                    --value;
                }
                calendar.set(calendarValue, value);
                ++count;
                startFound = true;
                continue;
            }
            catch (Exception e) {
                if (startFound) break;
            }
        }
        for (int j = count; j < calendarValues.length; ++j) {
            if (calendarValues[j].getCalendarValue() == 5) {
                calendar.set(calendarValues[j].getCalendarValue(), 1);
                continue;
            }
            calendar.set(calendarValues[j].getCalendarValue(), 0);
        }
        return calendar;
    }

    protected JsonArray getRangeKey(long time, TemporalConstraint.AggregationMode aggregationMode, boolean wildCard, boolean endKey) throws JSONException {
        JsonArray array = JsonArray.create();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        TemporalConstraint.CalendarEnum[] values = TemporalConstraint.CalendarEnum.values();
        if (endKey) {
            calendar.add(values[aggregationMode.ordinal()].getCalendarValue(), 1);
        }
        for (int i = 0; i <= aggregationMode.ordinal(); ++i) {
            int value = calendar.get(values[i].getCalendarValue());
            if (values[i].getCalendarValue() == 2) {
                ++value;
            }
            array.add(value);
        }
        if (wildCard) {
            array.add("{}");
        }
        return array;
    }

    @Deprecated
    protected String getDesignDocId(Class<? extends AggregatedRecord<?, ?>> recordClass) throws InstantiationException, IllegalAccessException {
        return String.format("%s%s", MAP_REDUCE__DESIGN, recordClass.newInstance().getRecordType());
    }

    protected String getDesignDocIdSpecific(Class<? extends AggregatedRecord<?, ?>> recordClass, Collection<String> keys) throws InstantiationException, IllegalAccessException {
        String specific = MAP_REDUCE_ALL;
        if (!keys.isEmpty()) {
            specific = keys.iterator().next();
        }
        String getDesigndocIdSpecific = specific;
        return getDesigndocIdSpecific;
    }

    public static String getMapReduceFunctionName(Collection<String> collection) {
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            reduceFunction = null;
            for (String property : collection) {
                if (reduceFunction == null) {
                    reduceFunction = property;
                    continue;
                }
                reduceFunction = reduceFunction + KEYS_SEPARATOR + property;
            }
        }
        return reduceFunction;
    }

    public static String getMapReduceFunctionNameTopMap(String top, Collection<String> collection) {
        logger.debug("top:{}", (Object)top);
        logger.debug("collection:{}", (Object)collection.toString());
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            reduceFunction = top;
            for (String property : collection) {
                if (property.equals(top)) continue;
                if (reduceFunction == null) {
                    reduceFunction = property;
                    continue;
                }
                reduceFunction = reduceFunction + KEYS_SEPARATOR + property;
            }
        }
        return reduceFunction;
    }

    public static String getDesignDocIdName(Collection<String> collection) {
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            String property;
            reduceFunction = null;
            reduceFunction = property = collection.iterator().next();
        }
        return reduceFunction;
    }

    public SortedMap<String, Integer> getListUsage(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String context, List<String> parameters) throws Exception {
        ViewResult viewResult;
        String currentScope = null;
        currentScope = context == null ? ScopeProvider.instance.get() : context;
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(Filter filter1, Filter filter2) {
                    int result = filter1.getKey().compareTo(filter2.getKey());
                    return result;
                }
            });
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionName(keys);
        if (parameters != null) {
            for (String name : parameters) {
                viewName = viewName + KEYS_SEPARATOR + name;
            }
        }
        ViewQuery query = ViewQuery.from((String)DESIGN_DOC_ID_LIST_USAGE, (String)viewName);
        query.inclusiveEnd();
        query.reduce(false);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), DESIGN_DOC_ID_LIST_USAGE, viewName, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        TreeMap infos = new TreeMap();
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        for (ViewRow row : viewResult) {
            JsonArray array = (JsonArray)row.key();
            Calendar calendar = this.getCalendarFromArray(array);
            JsonObject value = (JsonObject)row.value();
            JSONObject obj = new JSONObject(value.toString());
            Info info = new Info(calendar, obj);
        }
        return null;
    }

    protected SortedMap<Calendar, Info> mapReduceQuery(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String context, Boolean valueEmpty, Boolean noScope) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = null;
        currentScope = context == null ? ScopeProvider.instance.get() : context;
        JsonArray startKey = JsonArray.create();
        JsonArray endKey = JsonArray.create();
        if (!noScope.booleanValue()) {
            startKey.add(currentScope);
            endKey.add(currentScope);
        }
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(Filter filter1, Filter filter2) {
                    int result = filter1.getKey().compareTo(filter2.getKey());
                    return result;
                }
            });
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        int groupLevel = scopeDateGroupLevel = aggregationMode.ordinal() + 1 + 1;
        if (filters != null) {
            groupLevel += keys.size();
        }
        String designDocId = this.getDesignDocIdSpecific(clz, keys);
        if (noScope.booleanValue()) {
            designDocId = "noContext";
            --groupLevel;
        }
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionName(keys);
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        TreeMap<Calendar, Info> infos = new TreeMap<Calendar, Info>();
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        for (ViewRow row : viewResult) {
            JsonArray array = (JsonArray)row.key();
            Calendar calendar = this.getCalendarFromArray(array);
            JsonObject value = (JsonObject)row.value();
            JSONObject obj = new JSONObject(value.toString());
            Info info = new Info(calendar, obj);
            infos.put(calendar, info);
        }
        logger.trace("valueEmpty not permitted:{}", (Object)valueEmpty);
        if (valueEmpty.booleanValue() && infos.isEmpty()) {
            logger.trace("infos is empity");
            query = ViewQuery.from((String)designDocId, (String)viewName);
            query.groupLevel(groupLevel);
            query.descending(false);
            try {
                viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
            }
            catch (Exception e) {
                logger.warn("not execute query", (Object)e.getLocalizedMessage());
            }
            try {
                if (viewResult.totalRows() != 0) {
                    ViewRow row = (ViewRow)viewResult.allRows().get(0);
                    JsonArray array = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
                    Calendar calendar = this.getCalendarFromArray(array);
                    JsonObject value = (JsonObject)row.value();
                    JSONObject objJson = new JSONObject(value.toString());
                    JSONObject objJsontemplate = new JSONObject();
                    Iterator iterateJson = objJson.keys();
                    while (iterateJson.hasNext()) {
                        String key = (String)iterateJson.next();
                        objJsontemplate.put(key, 0);
                    }
                    Info info = new Info(calendar, objJsontemplate);
                    infos.put(calendar, info);
                }
            }
            catch (Exception e) {
                logger.warn("error :{}", (Object)e.getLocalizedMessage());
            }
        }
        logger.trace("infos:{}", (Object)((Object)infos).toString());
        return infos;
    }

    public SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, null, true, false);
        return map;
    }

    public SortedMap<Calendar, Info> getNoContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, null, true, true);
        return map;
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey, String orderingProperty) throws Exception {
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int result = -o1.compareTo(o2);
                if (result == 0) {
                    result = o1.compareTo((Filter)o2);
                }
                return result;
            }
        };
        TreeMap<NumberedFilter, SortedMap<Calendar, Info>> ret = new TreeMap<NumberedFilter, SortedMap<Calendar, Info>>(comparator);
        SortedSet<NumberedFilter> top = null;
        if (this.usingNextPossibleValuesWithMap(clz, topKey, filters)) {
            logger.trace("getNextPossibleValues using map");
            top = this.getNextPossibleValuesWithMap(clz, temporalConstraint, filters, topKey, orderingProperty);
        } else {
            logger.trace("getNextPossibleValues using query");
            top = this.getNextPossibleValues(clz, temporalConstraint, filters, topKey, orderingProperty);
        }
        logger.trace("getNextPossibleValues:{}", (Object)top.toString());
        for (NumberedFilter nf : top) {
            filters.add((Filter)nf);
            SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, null, true, false);
            ret.put(nf, map);
            filters.remove(nf);
        }
        return ret;
    }

    protected boolean usingNextPossibleValuesWithMap(Class<? extends AggregatedRecord<?, ?>> clz, String topKey, List<Filter> filters) {
        logger.debug("usingNextPossibleValuesWithMap init");
        TreeSet<String> keys = new TreeSet<String>();
        try {
            SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
            keys.add(topKey);
            if (filters != null && filters.size() != 0) {
                Collections.sort(filters, new Comparator<Filter>(){

                    @Override
                    public int compare(Filter filter1, Filter filter2) {
                        int result = filter1.getKey().compareTo(filter2.getKey());
                        return result;
                    }
                });
                for (Filter filter : filters) {
                    String filterKey = filter.getKey();
                    String filterValue = filter.getValue();
                    if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                        if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                            if (keys.contains(filterKey)) {
                                throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                            }
                            keys.add(filterKey);
                            continue;
                        }
                        throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                    }
                    throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
            }
        }
        catch (Exception e1) {
            logger.warn("usingNextPossibleValuesWithMap -exception with filter:{}", (Object)filters.toString());
            return false;
        }
        logger.debug("usingNextPossibleValuesWithMap complete key and name");
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionNameTopMap(topKey, keys);
        String designDocId = DESIGN_DOC_ID + topKey;
        BucketManager bucketManager = this.connectionMap.get(clz.getSimpleName()).bucketManager();
        if (bucketManager.getDesignDocument(designDocId) != null) {
            logger.debug("usingNextPossibleValuesWithMap designDocId exist:{}-and viewname:{}-", (Object)designDocId, (Object)viewName);
            for (View view : bucketManager.getDesignDocument(designDocId).views()) {
                logger.debug("found:{}- ", (Object)view.name());
                if (!view.name().equals(viewName)) continue;
                logger.debug("usingNextPossibleValuesWithMap viewname exist");
                return true;
            }
        } else {
            logger.debug("usingNextPossibleValuesWithQuery");
            return false;
        }
        return false;
    }

    public SortedSet<NumberedFilter> getNextPossibleValuesWithMap(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws Exception {
        ViewResult viewResult;
        logger.debug("getNextPossibleValuesWithMap init");
        String currentScope = ScopeProvider.instance.get();
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        }
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        keys.add(key);
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        selectExpressions.add(Expression.x((String)("SUM(CASE WHEN " + this.getSpecializedProperty(clz, orderingProperty) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, orderingProperty) + " ELSE 1 END )")).as(orderingProperty));
        selectExpressions.add(Expression.x((String)("(CASE WHEN " + this.getSpecializedProperty(clz, key) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, key) + " ELSE 'UNKNOWN' END )")).as(key));
        Expression whereExpression = Expression.x((String)this.getSpecializedProperty(clz, "scope")).eq(Expression.s((String[])new String[]{currentScope}));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "startTime")).gt(startTime));
        long endTime = temporalConstraint.getEndTime();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "endTime")).lt(endTime));
        Expression[] selectExpressionArray = new Expression[selectExpressions.size()];
        selectExpressions.toArray(selectExpressionArray);
        Sort sort = Sort.desc((String)orderingProperty);
        LimitPath path = Select.select((Expression[])selectExpressionArray).from(this.connectionMap.get(clz.getSimpleName()).name()).where(whereExpression).groupBy(new String[]{key}).orderBy(new Sort[]{sort});
        if (filters != null && filters.size() != 0) {
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(Filter filter1, Filter filter2) {
                    int result = filter1.getKey().compareTo(filter2.getKey());
                    return result;
                }
            });
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, filterKey)).eq(Expression.s((String[])new String[]{filterValue})));
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        logger.debug("Alternative Query for top:" + path.toString());
        int groupLevel = 1;
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionNameTopMap(key, keys);
        String designDocId = DESIGN_DOC_ID + key;
        logger.trace("keys:{}", (Object)((Object)keys).toString());
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int compareResult = -o1.compareTo(o2);
                if (compareResult == 0) {
                    compareResult = 1;
                }
                return compareResult;
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        ViewRow row = (ViewRow)viewResult.allRows().get(0);
        JsonObject value = (JsonObject)row.value();
        JSONObject objectValueTop = new JSONObject(value.toString());
        Iterator iterateJosn = objectValueTop.keys();
        while (iterateJosn.hasNext()) {
            String keyTop = (String)iterateJosn.next();
            Number n = (Number)objectValueTop.get(keyTop);
            if (n == null) {
                n = 0;
            }
            NumberedFilter numberedFilter = new NumberedFilter(key, keyTop, n, orderingProperty);
            ret.add(numberedFilter);
        }
        return ret;
    }

    public SortedSet<NumberedFilter> getNextPossibleValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        }
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        selectExpressions.add(Expression.x((String)("SUM(CASE WHEN " + this.getSpecializedProperty(clz, orderingProperty) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, orderingProperty) + " ELSE 1 END )")).as(orderingProperty));
        selectExpressions.add(Expression.x((String)("(CASE WHEN " + this.getSpecializedProperty(clz, key) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, key) + " ELSE 'UNKNOWN' END )")).as(key));
        Expression whereExpression = Expression.x((String)this.getSpecializedProperty(clz, "scope")).eq(Expression.s((String[])new String[]{currentScope}));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "startTime")).gt(startTime));
        long endTime = temporalConstraint.getEndTime();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "endTime")).lt(endTime));
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, filterKey)).eq(Expression.s((String[])new String[]{filterValue})));
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        Expression[] selectExpressionArray = new Expression[selectExpressions.size()];
        selectExpressions.toArray(selectExpressionArray);
        Sort sort = Sort.desc((String)orderingProperty);
        LimitPath path = Select.select((Expression[])selectExpressionArray).from(this.connectionMap.get(clz.getSimpleName()).name()).where(whereExpression).groupBy(new String[]{key}).orderBy(new Sort[]{sort});
        logger.debug("Query for top:" + path.toString());
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int compareResult = -o1.compareTo(o2);
                if (compareResult == 0) {
                    compareResult = 1;
                }
                return compareResult;
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        N1qlQueryResult result = this.connectionMap.get(clz.getSimpleName()).query((Statement)path);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            throw new Exception("Query Failed :\n" + result.errors());
        }
        List rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                JsonObject jsonObject = row.value();
                String value = jsonObject.getString(key);
                Number n = jsonObject.getDouble(orderingProperty);
                if (n == null) {
                    n = 0;
                }
                NumberedFilter numberedFilter = new NumberedFilter(key, value, n, orderingProperty);
                ret.add(numberedFilter);
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
                e.printStackTrace();
            }
        }
        return ret;
    }

    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, List<String> contexts) throws Exception {
        logger.trace("getContextTimeSeries for contexts:{}", (Object)contexts.toString());
        TreeSet<Filter> listContexts = new TreeSet<Filter>();
        for (String context : contexts) {
            Filter contextLabel = new Filter("context", context);
            listContexts.add(contextLabel);
        }
        TreeMap<Filter, SortedMap<Calendar, Info>> ret = new TreeMap<Filter, SortedMap<Calendar, Info>>();
        for (Filter nf : listContexts) {
            logger.debug("detail time series :{}", (Object)nf.toString());
            SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, nf.getValue(), false, false);
            if (!map.isEmpty()) {
                ret.put(nf, map);
            }
            filters.remove(nf);
        }
        return ret;
    }

    protected String getQualifiedProperty(String property) {
        return property;
    }

    protected String getSpecializedProperty(Class<? extends AggregatedRecord<?, ?>> clz, String property) {
        return String.format("%s.%s", this.connectionMap.get(clz.getSimpleName()).name(), property);
    }

    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = ScopeProvider.instance.get();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        int groupLevel = scopeDateGroupLevel = 2;
        String designDocId = this.getDesignDocId(clz) + "Value";
        String viewName = key;
        logger.trace("designDocId:{} view:{} startKey:{} groupLevel:{}", new Object[]{designDocId, key, startKey, groupLevel});
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.descending(false);
        String orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error("error executing the query", (Throwable)e);
            throw e;
        }
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                if (o1.getValue() == null) {
                    o1.setValue(AccountingPersistenceQueryCouchBase.MAP_REDUCE__DESIGN);
                }
                if (o2.getValue() == null) {
                    o2.setValue(AccountingPersistenceQueryCouchBase.MAP_REDUCE__DESIGN);
                }
                return o1.getValue().compareTo(o2.getValue());
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        for (ViewRow row : viewResult) {
            String value = (String)row.value();
            NumberedFilter numberedFilter = new NumberedFilter(key, value, (Number)0, orderingProperty);
            ret.add(numberedFilter);
        }
        logger.trace("returning {} values", (Object)ret.size());
        return ret;
    }

    public JSONObject getUsageValue(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, Filter applicant) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = ScopeProvider.instance.get();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        startKey.add(applicant.getValue());
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        endKey.add(applicant.getValue());
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        int groupLevel = scopeDateGroupLevel = aggregationMode.ordinal() + 1 + 1 + 1;
        TreeSet<String> keys = new TreeSet<String>();
        keys.add(applicant.getKey());
        String designDocId = this.getDesignDocIdSpecific(clz, keys);
        String viewName = applicant.getKey();
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (ViewRow row : viewResult) {
            JsonObject jsnobject = (JsonObject)row.value();
            JSONObject objJson = new JSONObject(jsnobject.toString());
            Iterator iterateJosn = objJson.keys();
            while (iterateJosn.hasNext()) {
                String key = (String)iterateJosn.next();
                Float valuetmp = Float.valueOf(Float.parseFloat(objJson.get(key).toString()));
                if (!key.equals("operationCount") && !key.equals("dataVolume")) continue;
                if (map.containsKey(key)) {
                    map.put(key, Float.valueOf(valuetmp.floatValue() + ((Float)map.get(key)).floatValue()));
                    continue;
                }
                map.put(key, valuetmp);
            }
        }
        JSONObject result = new JSONObject(map);
        return result;
    }

    public List<UsageValue> getUsageValueQuotaTotal(List<UsageValue> listUsage) throws Exception {
        logger.debug("getUsageValueQuotaTotal init with list:{}", listUsage);
        String keyOrderingProperty = null;
        for (UsageValue totalFilters : listUsage) {
            ViewResult viewResult;
            Object temporal2;
            logger.debug("-----------------/ init for totalFilters");
            String currentScope = totalFilters.getContext();
            TreeSet<String> keys = new TreeSet<String>();
            keys.add("consumerId");
            String designDocId = this.getDesignDocIdSpecific(totalFilters.getClz(), keys);
            JsonArray temporalStartKey = null;
            JsonArray temporalEndKey = null;
            logger.trace("temporalConstraint:{}", (Object)totalFilters);
            TemporalConstraint temporalConstraint = totalFilters.getTemporalConstraint();
            if (temporalConstraint == null) {
                logger.trace("Not found temporalConstraint");
                Calendar startTime = Calendar.getInstance();
                startTime.set(1970, 0, 1);
                Calendar endTime = Calendar.getInstance();
                temporalConstraint = new TemporalConstraint(startTime.getTimeInMillis(), endTime.getTimeInMillis(), TemporalConstraint.AggregationMode.DAILY);
                if (totalFilters.getClz().getSimpleName().equals(AggregatedStorageStatusRecord.class.getSimpleName())) {
                    designDocId = "QuotaTotal";
                }
            } else if (totalFilters.getClz().getSimpleName().equals(AggregatedStorageStatusRecord.class.getSimpleName())) {
                logger.trace("AggregatedStorageStatusRecord with temporalConstraint");
                designDocId = "Quota";
            }
            TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
            temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
            temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
            Double totalQuota = 0.0;
            if (totalFilters instanceof UsageServiceValue) {
                UsageServiceValue usageServiceValue = (UsageServiceValue)totalFilters;
            }
            String viewNameTmp = null;
            JsonArray startKeyTmp = JsonArray.create();
            startKeyTmp.add(currentScope);
            JsonArray endKeyTmp = JsonArray.create();
            endKeyTmp.add(currentScope);
            int groupLevelTmp = 2;
            viewNameTmp = "consumerId";
            startKeyTmp.add(totalFilters.getIdentifier());
            endKeyTmp.add(totalFilters.getIdentifier());
            if (totalFilters instanceof UsageServiceValue) {
                UsageServiceValue totalFiltersService = (UsageServiceValue)totalFilters;
                for (Filter filter : totalFiltersService.getFilters()) {
                    viewNameTmp = viewNameTmp + KEYS_SEPARATOR + filter.getKey();
                    startKeyTmp.add(filter.getValue());
                    endKeyTmp.add(filter.getValue());
                    ++groupLevelTmp;
                }
            }
            for (Object temporal2 : temporalStartKey.toList()) {
                if (temporal2.toString().isEmpty()) continue;
                startKeyTmp.add(temporal2);
            }
            int count = 1;
            temporal2 = temporalEndKey.toList().iterator();
            while (temporal2.hasNext()) {
                Object temporal3 = temporal2.next();
                if (!temporal3.toString().isEmpty()) {
                    if (count == temporalEndKey.size()) {
                        temporal3 = (Integer)temporal3 + 1;
                    }
                    endKeyTmp.add(temporal3);
                }
                ++count;
            }
            logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{totalFilters.getClz().getSimpleName(), designDocId, viewNameTmp, groupLevelTmp, startKeyTmp, endKeyTmp, temporalStartKey.toString(), temporalEndKey.toString()});
            logger.trace("connectionMap:{}", (Object)this.connectionMap.toString());
            ViewQuery query = ViewQuery.from((String)designDocId, (String)viewNameTmp);
            query.inclusiveEnd();
            if (designDocId == "QuotaTotal") {
                query.startKey(endKeyTmp);
                query.endKey(startKeyTmp);
                query.descending(true);
                query.limit(1);
                query.onError(OnError.STOP);
            } else {
                query.groupLevel(groupLevelTmp);
                query.startKey(startKeyTmp);
                query.endKey(endKeyTmp);
                query.descending(false);
                query.onError(OnError.STOP);
            }
            logger.trace("query row:{}", (Object)query.toString());
            try {
                viewResult = this.connectionMap.get(totalFilters.getClz().getSimpleName()).query(query);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage());
                throw e;
            }
            logger.trace("viewResult row:{}", (Object)viewResult.toString());
            HashMap<String, Float> map = new HashMap<String, Float>();
            for (ViewRow row : viewResult) {
                logger.trace("ViewRow row:{}", (Object)row.toString());
                JsonObject jsnobject = (JsonObject)row.value();
                JSONObject objJson = new JSONObject(jsnobject.toString());
                Iterator iterateJosn = objJson.keys();
                while (iterateJosn.hasNext()) {
                    String key = (String)iterateJosn.next();
                    Float valuetmp = Float.valueOf(Float.parseFloat(objJson.get(key).toString()));
                    if (!key.equals("operationCount") && !key.equals("dataVolume")) continue;
                    if (map.containsKey(key)) {
                        map.put(key, Float.valueOf(valuetmp.floatValue() + ((Float)map.get(key)).floatValue()));
                        if (totalFilters instanceof UsageStorageValue) {
                            logger.debug("storageUsageRecord -designDocId:{}", (Object)designDocId);
                            if (!key.equals("dataVolume")) continue;
                            keyOrderingProperty = key;
                            totalQuota = totalQuota + (totalFilters.getD() + valuetmp.doubleValue());
                            continue;
                        }
                        logger.debug("?UsageRecord -designDocId:{}", (Object)designDocId);
                        keyOrderingProperty = key;
                        totalQuota = totalQuota + (totalFilters.getD() + valuetmp.doubleValue());
                        continue;
                    }
                    map.put(key, valuetmp);
                    if (totalFilters instanceof UsageStorageValue) {
                        logger.debug("storageUsageRecord -designDocId:{}", (Object)designDocId);
                        if (!key.equals("dataVolume")) continue;
                        keyOrderingProperty = key;
                        totalQuota = totalQuota + valuetmp.doubleValue();
                        continue;
                    }
                    logger.debug("?UsageRecord -designDocId:{}", (Object)designDocId);
                    keyOrderingProperty = key;
                    totalQuota = totalQuota + valuetmp.doubleValue();
                }
            }
            if (totalFilters instanceof UsageStorageValue) {
                totalQuota = totalQuota / 1024.0 / 1024.0;
                totalQuota = (double)Math.round(totalQuota * 100.0) / 100.0;
            }
            totalFilters.setOrderingProperty(keyOrderingProperty);
            if (totalQuota.isNaN()) {
                totalQuota = 0.0;
            }
            totalFilters.setD(totalQuota);
        }
        return listUsage;
    }
}

