/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;
import rx.internal.operators.TakeLastQueueProducer;

public final class OperatorTakeLastTimed<T>
implements Observable.Operator<T, T> {
    private final long ageMillis;
    private final Scheduler scheduler;
    private final int count;

    public OperatorTakeLastTimed(long time, TimeUnit unit, Scheduler scheduler) {
        this.ageMillis = unit.toMillis(time);
        this.scheduler = scheduler;
        this.count = -1;
    }

    public OperatorTakeLastTimed(int count, long time, TimeUnit unit, Scheduler scheduler) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.ageMillis = unit.toMillis(time);
        this.scheduler = scheduler;
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        final ArrayDeque<Object> buffer = new ArrayDeque<Object>();
        final ArrayDeque timestampBuffer = new ArrayDeque();
        final NotificationLite notification = NotificationLite.instance();
        final TakeLastQueueProducer<? super T> producer = new TakeLastQueueProducer<T>(notification, buffer, subscriber);
        subscriber.setProducer(producer);
        return new Subscriber<T>(subscriber){

            protected void runEvictionPolicy(long now) {
                long v;
                while (OperatorTakeLastTimed.this.count >= 0 && buffer.size() > OperatorTakeLastTimed.this.count) {
                    timestampBuffer.pollFirst();
                    buffer.pollFirst();
                }
                while (!buffer.isEmpty() && (v = ((Long)timestampBuffer.peekFirst()).longValue()) < now - OperatorTakeLastTimed.this.ageMillis) {
                    timestampBuffer.pollFirst();
                    buffer.pollFirst();
                }
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T args) {
                long t = OperatorTakeLastTimed.this.scheduler.now();
                timestampBuffer.add(t);
                buffer.add(notification.next(args));
                this.runEvictionPolicy(t);
            }

            @Override
            public void onError(Throwable e) {
                timestampBuffer.clear();
                buffer.clear();
                subscriber.onError(e);
            }

            @Override
            public void onCompleted() {
                this.runEvictionPolicy(OperatorTakeLastTimed.this.scheduler.now());
                timestampBuffer.clear();
                buffer.offer(notification.completed());
                producer.startEmitting();
            }
        };
    }
}

