/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import rx.Notification;
import rx.Observer;
import rx.Subscriber;
import rx.annotations.Experimental;
import rx.exceptions.CompositeException;
import rx.observers.TestObserver;

public class TestSubscriber<T>
extends Subscriber<T> {
    private final TestObserver<T> testObserver;
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile Thread lastSeenThread;
    private final long initialRequest;
    private static final Observer<Object> INERT = new Observer<Object>(){

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onNext(Object t) {
        }
    };

    @Experimental
    public TestSubscriber(long initialRequest) {
        this(INERT, initialRequest);
    }

    @Experimental
    public TestSubscriber(Observer<T> delegate, long initialRequest) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.testObserver = new TestObserver<T>(delegate);
        this.initialRequest = initialRequest;
    }

    public TestSubscriber(Subscriber<T> delegate) {
        this(delegate, -1L);
    }

    public TestSubscriber(Observer<T> delegate) {
        this(delegate, -1L);
    }

    public TestSubscriber() {
        this(-1L);
    }

    @Experimental
    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    @Experimental
    public static <T> TestSubscriber<T> create(long initialRequest) {
        return new TestSubscriber<T>(initialRequest);
    }

    @Experimental
    public static <T> TestSubscriber<T> create(Observer<T> delegate, long initialRequest) {
        return new TestSubscriber<T>(delegate, initialRequest);
    }

    @Experimental
    public static <T> TestSubscriber<T> create(Subscriber<T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    @Experimental
    public static <T> TestSubscriber<T> create(Observer<T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    @Override
    public void onStart() {
        if (this.initialRequest >= 0L) {
            this.requestMore(this.initialRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        try {
            this.lastSeenThread = Thread.currentThread();
            this.testObserver.onCompleted();
        }
        finally {
            this.latch.countDown();
        }
    }

    public List<Notification<T>> getOnCompletedEvents() {
        return this.testObserver.getOnCompletedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        try {
            this.lastSeenThread = Thread.currentThread();
            this.testObserver.onError(e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public List<Throwable> getOnErrorEvents() {
        return this.testObserver.getOnErrorEvents();
    }

    @Override
    public void onNext(T t) {
        this.lastSeenThread = Thread.currentThread();
        this.testObserver.onNext(t);
    }

    public void requestMore(long n) {
        this.request(n);
    }

    public List<T> getOnNextEvents() {
        return this.testObserver.getOnNextEvents();
    }

    public void assertReceivedOnNext(List<T> items) {
        this.testObserver.assertReceivedOnNext(items);
    }

    public void assertTerminalEvent() {
        this.testObserver.assertTerminalEvent();
    }

    public void assertUnsubscribed() {
        if (!this.isUnsubscribed()) {
            throw new AssertionError((Object)"Not unsubscribed.");
        }
    }

    public void assertNoErrors() {
        List<Throwable> onErrorEvents = this.getOnErrorEvents();
        if (onErrorEvents.size() > 0) {
            AssertionError ae = new AssertionError((Object)("Unexpected onError events: " + this.getOnErrorEvents().size()));
            if (onErrorEvents.size() == 1) {
                ((Throwable)((Object)ae)).initCause(this.getOnErrorEvents().get(0));
            } else {
                ((Throwable)((Object)ae)).initCause(new CompositeException(onErrorEvents));
            }
            throw ae;
        }
    }

    public void awaitTerminalEvent() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public void awaitTerminalEvent(long timeout, TimeUnit unit) {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public void awaitTerminalEventAndUnsubscribeOnTimeout(long timeout, TimeUnit unit) {
        try {
            boolean result = this.latch.await(timeout, unit);
            if (!result) {
                this.unsubscribe();
            }
        }
        catch (InterruptedException e) {
            this.unsubscribe();
        }
    }

    public Thread getLastSeenThread() {
        return this.lastSeenThread;
    }

    @Experimental
    public void assertCompleted() {
        int s = this.testObserver.getOnCompletedEvents().size();
        if (s == 0) {
            throw new AssertionError((Object)"Not completed!");
        }
        if (s > 1) {
            throw new AssertionError((Object)("Completed multiple times: " + s));
        }
    }

    @Experimental
    public void assertNotCompleted() {
        int s = this.testObserver.getOnCompletedEvents().size();
        if (s == 1) {
            throw new AssertionError((Object)"Completed!");
        }
        if (s > 1) {
            throw new AssertionError((Object)("Completed multiple times: " + s));
        }
    }

    @Experimental
    public void assertError(Class<? extends Throwable> clazz) {
        List<Throwable> err = this.testObserver.getOnErrorEvents();
        if (err.size() == 0) {
            throw new AssertionError((Object)"No errors");
        }
        if (err.size() > 1) {
            AssertionError ae = new AssertionError((Object)("Multiple errors: " + err.size()));
            ((Throwable)((Object)ae)).initCause(new CompositeException(err));
            throw ae;
        }
        if (!clazz.isInstance(err.get(0))) {
            AssertionError ae = new AssertionError((Object)("Exceptions differ; expected: " + clazz + ", actual: " + err.get(0)));
            ((Throwable)((Object)ae)).initCause(err.get(0));
            throw ae;
        }
    }

    @Experimental
    public void assertError(Throwable throwable) {
        List<Throwable> err = this.testObserver.getOnErrorEvents();
        if (err.size() == 0) {
            throw new AssertionError((Object)"No errors");
        }
        if (err.size() > 1) {
            AssertionError ae = new AssertionError((Object)("Multiple errors: " + err.size()));
            ((Throwable)((Object)ae)).initCause(new CompositeException(err));
            throw ae;
        }
        if (!throwable.equals(err.get(0))) {
            AssertionError ae = new AssertionError((Object)("Exceptions differ; expected: " + throwable + ", actual: " + err.get(0)));
            ((Throwable)((Object)ae)).initCause(err.get(0));
            throw ae;
        }
    }

    @Experimental
    public void assertNoTerminalEvent() {
        List<Throwable> err = this.testObserver.getOnErrorEvents();
        int s = this.testObserver.getOnCompletedEvents().size();
        if (err.size() > 0 || s > 0) {
            if (err.isEmpty()) {
                throw new AssertionError((Object)("Found " + err.size() + " errors and " + s + " completion events instead of none"));
            }
            if (err.size() == 1) {
                AssertionError ae = new AssertionError((Object)("Found " + err.size() + " errors and " + s + " completion events instead of none"));
                ((Throwable)((Object)ae)).initCause(err.get(0));
                throw ae;
            }
            AssertionError ae = new AssertionError((Object)("Found " + err.size() + " errors and " + s + " completion events instead of none"));
            ((Throwable)((Object)ae)).initCause(new CompositeException(err));
            throw ae;
        }
    }

    @Experimental
    public void assertNoValues() {
        int s = this.testObserver.getOnNextEvents().size();
        if (s > 0) {
            throw new AssertionError((Object)("No onNext events expected yet some received: " + s));
        }
    }

    @Experimental
    public void assertValueCount(int count) {
        int s = this.testObserver.getOnNextEvents().size();
        if (s != count) {
            throw new AssertionError((Object)("Number of onNext events differ; expected: " + count + ", actual: " + s));
        }
    }

    @Experimental
    public void assertValues(T ... values) {
        this.assertReceivedOnNext(Arrays.asList(values));
    }

    @Experimental
    public void assertValue(T value) {
        this.assertReceivedOnNext(Collections.singletonList(value));
    }
}

