/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.couchdb;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdCouchDbInstance;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.common.scope.api.ScopeProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceQueryCouchDB
extends AccountingPersistenceBackendQuery {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceQueryCouchDB.class);
    protected CouchDbInstance couchDbInstance;
    protected CouchDbConnector couchDbConnector;
    protected static final String DB_NAME = "dbName";
    protected static final String MAP_REDUCE__DESIGN = "_design/";
    protected static final String MAP_REDUCE_ALL = "all";
    protected static final String KEYS_SEPARATOR = "__";
    protected static final String VIEWS_KEY = "views";
    protected static final String VALUES = "Values";

    protected HttpClient initHttpClient(URL url, String username, String password) {
        StdHttpClient.Builder builder = new StdHttpClient.Builder().url(url);
        builder.username(username).password(password);
        HttpClient httpClient = builder.build();
        return httpClient;
    }

    protected ViewResult query(ViewQuery query) {
        ViewResult result = this.couchDbConnector.queryView(query);
        return result;
    }

    protected JSONObject getObjectByID(String id) throws Exception {
        InputStream is = this.couchDbConnector.getAsStream(id);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
        JSONObject obj = new JSONObject(writer.toString());
        return obj;
    }

    public void close() throws Exception {
        this.couchDbConnector.getConnection().shutdown();
    }

    protected void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        logger.debug("Preparing Connection for {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        HttpClient httpClient = this.initHttpClient(configuration.getUri().toURL(), configuration.getUsername(), configuration.getPassword());
        this.couchDbInstance = new StdCouchDbInstance(httpClient);
        this.couchDbConnector = new StdCouchDbConnector(configuration.getProperty(DB_NAME), this.couchDbInstance);
    }

    protected Calendar getCalendarFromArray(JSONArray array) throws JSONException {
        boolean startFound = false;
        Calendar calendar = Calendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        int count = 0;
        TemporalConstraint.CalendarEnum[] calendarValues = TemporalConstraint.CalendarEnum.values();
        for (int i = 0; i < array.length(); ++i) {
            try {
                int value = array.getInt(i);
                int calendarValue = calendarValues[count].getCalendarValue();
                if (calendarValue == 2) {
                    --value;
                }
                calendar.set(calendarValue, value);
                ++count;
                startFound = true;
                continue;
            }
            catch (JSONException e) {
                logger.trace("The provide value is not an int. {}", (Object)array.get(i).toString());
                if (startFound) break;
            }
        }
        for (int j = count; j < calendarValues.length; ++j) {
            calendar.set(calendarValues[j].getCalendarValue(), 0);
        }
        return calendar;
    }

    protected ArrayNode getRangeKey(ArrayNode arrayNode, long time, TemporalConstraint.AggregationMode aggregationMode, boolean wildCard) throws JSONException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        TemporalConstraint.CalendarEnum[] values = TemporalConstraint.CalendarEnum.values();
        for (int i = 0; i <= aggregationMode.ordinal(); ++i) {
            int value = calendar.get(values[i].getCalendarValue());
            if (values[i].getCalendarValue() == 2) {
                ++value;
            }
            arrayNode.add(value);
        }
        if (wildCard) {
            arrayNode.add("{}");
        }
        return arrayNode;
    }

    protected String getDesignDocId(Class<? extends AggregatedUsageRecord> usageRecordType) throws InstantiationException, IllegalAccessException {
        return String.format("%s%s", MAP_REDUCE__DESIGN, usageRecordType.newInstance().getUsageRecordType());
    }

    protected Map<Calendar, Info> reallyQuery(Class<? extends AggregatedUsageRecord> usageRecordType, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        ViewQuery query = new ViewQuery().designDocId(this.getDesignDocId(usageRecordType));
        query.group(true);
        if (filters != null) {
            query.groupLevel(temporalConstraint.getAggregationMode().ordinal() + 2 + filters.size());
        } else {
            query.groupLevel(temporalConstraint.getAggregationMode().ordinal() + 2);
        }
        ArrayNode startKey = new ObjectMapper().createArrayNode();
        startKey.add(currentScope);
        ArrayNode endKey = new ObjectMapper().createArrayNode();
        endKey.add(currentScope);
        if (filters != null && filters.size() != 0) {
            String viewName = "";
            for (Filter filter : filters) {
                startKey.add(filter.getValue());
                endKey.add(filter.getValue());
                if (viewName.compareTo("") == 0) {
                    viewName = filter.getKey();
                    continue;
                }
                viewName = viewName + KEYS_SEPARATOR + filter.getKey();
            }
            query = query.viewName(viewName);
        } else {
            query = query.viewName(MAP_REDUCE_ALL);
        }
        startKey = this.getRangeKey(startKey, temporalConstraint.getStartTime(), temporalConstraint.getAggregationMode(), false);
        query.startKey((Object)startKey);
        endKey = this.getRangeKey(endKey, temporalConstraint.getEndTime(), temporalConstraint.getAggregationMode(), true);
        query.endKey((Object)endKey);
        HashMap<Calendar, Info> infos = new HashMap<Calendar, Info>();
        ViewResult viewResult = this.query(query);
        for (ViewResult.Row row : viewResult) {
            JsonNode key = row.getKeyAsNode();
            JSONArray array = new JSONArray(key.toString());
            Calendar calendar = this.getCalendarFromArray(array);
            JsonNode value = row.getValueAsNode();
            JSONObject obj = new JSONObject(value.toString());
            infos.put(calendar, new Info(calendar, obj));
        }
        return infos;
    }

    public Set<String> getKeys(Class<? extends AggregatedUsageRecord> usageRecordType) throws Exception {
        JSONObject doc = this.getObjectByID(this.getDesignDocId(usageRecordType));
        logger.trace(doc.toString());
        HashSet<String> keys = new HashSet<String>();
        JSONObject view = doc.getJSONObject(VIEWS_KEY);
        Iterator iterator = view.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.contains(KEYS_SEPARATOR)) {
                logger.trace("{} is a composition of key, so that is not a single filter", (Object)key);
                continue;
            }
            if (key.compareTo(MAP_REDUCE_ALL) == 0) continue;
            logger.trace("Found key valid for filter : {} ", (Object)key);
            keys.add(key);
        }
        return keys;
    }

    public Set<String> getPossibleValuesForKey(Class<? extends AggregatedUsageRecord> usageRecordType, String key) throws Exception {
        HashSet<String> values = new HashSet<String>();
        String currentScope = ScopeProvider.instance.get();
        ViewQuery query = new ViewQuery().designDocId(this.getDesignDocId(usageRecordType) + VALUES);
        query = query.viewName(key);
        query.group(true);
        query.groupLevel(2);
        ArrayNode startKey = new ObjectMapper().createArrayNode();
        startKey.add(currentScope);
        ArrayNode endKey = new ObjectMapper().createArrayNode();
        endKey.add(currentScope);
        endKey.add("{}");
        ViewResult viewResult = this.query(query);
        for (ViewResult.Row row : viewResult) {
            JsonNode value = row.getValueAsNode();
            values.add(value.asText());
        }
        return values;
    }
}

