/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.jackson;

import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.CouchDbConnector;
import org.ektorp.impl.jackson.EktorpAnnotationIntrospector;
import org.ektorp.impl.jackson.EktorpBeanDeserializerModifier;
import org.ektorp.impl.jackson.EktorpBeanSerializerModifier;
import org.ektorp.util.Assert;

public class EktorpJacksonModule
extends Module {
    private static final Version VERSION = new Version(1, 2, 0, null);
    private final CouchDbConnector db;
    private final ObjectMapper objectMapper;

    public EktorpJacksonModule(CouchDbConnector db, ObjectMapper objectMapper) {
        Assert.notNull(db, "CouchDbConnector may not be null");
        Assert.notNull(objectMapper, "ObjectMapper may not be null");
        this.db = db;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getModuleName() {
        return "EktorpDocRefModule";
    }

    @Override
    public Version version() {
        return VERSION;
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.insertAnnotationIntrospector(new EktorpAnnotationIntrospector());
        context.addBeanDeserializerModifier(new EktorpBeanDeserializerModifier(this.db, this.objectMapper));
        context.addBeanSerializerModifier(new EktorpBeanSerializerModifier(this.db));
    }
}

