/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.support;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.impl.NameConventions;
import org.ektorp.support.CouchDbRepositorySupport;
import org.ektorp.support.DesignDocument;
import org.ektorp.support.GenerateView;
import org.ektorp.support.TypeDiscriminator;
import org.ektorp.support.View;
import org.ektorp.support.ViewGenerationException;
import org.ektorp.support.Views;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;
import org.ektorp.util.Joiner;
import org.ektorp.util.Predicate;
import org.ektorp.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleViewGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleViewGenerator.class);
    private static final String ALL_VIEW_TEMPLATE = "function(doc) { if(%s) {emit(null, doc._id)} }";
    private static final String LOOKUP_BY_PROPERTY_TEMPLATE = "function(doc) { if(%s) {emit(doc.%s, doc._id)} }";
    private static final String ITERABLE_PROPERTY_TEMPLATE = "function(doc) {%s}";
    private static final String ITERABLE_PROPERTY_WITH_DISCRMINATOR_TEMPLATE = "function(doc) {if (%s) {%s}}";
    private static final String ITERABLE_PROPERTY_BODY = "for (var i in doc.%s) {emit(doc.%s[i], doc._id);}";
    private static final String REFERING_CHILDREN_AS_SET_W_ORDER_BY = "function(doc) { if(%s) { emit([doc.%s, '%s', doc.%s], null); } }";
    private static final String REFERING_CHILDREN_AS_SET = "function(doc) { if(%s) { emit([doc.%s, '%s'], null); } }";
    private SoftReference<ObjectMapper> mapperRef;

    public DesignDocument.View generateFindByView(String propertyName, String typeDiscriminator) {
        String selector = typeDiscriminator.length() > 0 ? typeDiscriminator + " && doc." + propertyName : "doc." + propertyName;
        return new DesignDocument.View(String.format(LOOKUP_BY_PROPERTY_TEMPLATE, selector, propertyName));
    }

    public DesignDocument.View generateFindByIterableView(String propertyName, String typeDiscriminator) {
        String body = String.format(ITERABLE_PROPERTY_BODY, propertyName, propertyName);
        if (typeDiscriminator.length() > 0) {
            return new DesignDocument.View(String.format(ITERABLE_PROPERTY_WITH_DISCRMINATOR_TEMPLATE, typeDiscriminator, body));
        }
        return new DesignDocument.View(String.format(ITERABLE_PROPERTY_TEMPLATE, body));
    }

    public DesignDocument.View generateDocRefsAsSetWithOrderByView(String backRef, String fieldName, String orderBy, String typeDiscriminator) {
        String selector = typeDiscriminator.length() > 0 ? typeDiscriminator + " && doc." + backRef : "doc." + backRef;
        return new DesignDocument.View(String.format(REFERING_CHILDREN_AS_SET_W_ORDER_BY, selector, backRef, fieldName, orderBy));
    }

    public DesignDocument.View generateDocRefsAsSetView(String backRef, String fieldName, String typeDiscriminator) {
        String selector = typeDiscriminator.length() > 0 ? typeDiscriminator + " && doc." + backRef : "doc." + backRef;
        return new DesignDocument.View(String.format(REFERING_CHILDREN_AS_SET, selector, backRef, fieldName));
    }

    private DesignDocument.View generateAllView(String typeDiscriminator) {
        return new DesignDocument.View(String.format(ALL_VIEW_TEMPLATE, typeDiscriminator));
    }

    public Map<String, DesignDocument.View> generateViews(Object repository) {
        final HashMap<String, DesignDocument.View> views = new HashMap<String, DesignDocument.View>();
        Class<?> repositoryClass = repository.getClass();
        final Class<?> handledType = repository instanceof CouchDbRepositorySupport ? ((CouchDbRepositorySupport)repository).getHandledType() : null;
        this.createDeclaredViews(views, repositoryClass);
        ReflectionUtils.eachMethod(repositoryClass, new Predicate<Method>(){

            @Override
            public boolean apply(Method input) {
                if (ReflectionUtils.hasAnnotation(input, GenerateView.class)) {
                    SimpleViewGenerator.this.generateView(views, input, handledType);
                }
                return false;
            }
        });
        if (handledType != null) {
            views.putAll(this.generateViewsFromPersistentType(handledType));
        }
        return views;
    }

    private void createDeclaredViews(final Map<String, DesignDocument.View> views, final Class<?> klass) {
        ReflectionUtils.eachAnnotation(klass, Views.class, new Predicate<Views>(){

            @Override
            public boolean apply(Views input) {
                for (View v : input.value()) {
                    SimpleViewGenerator.this.addView(views, v, klass);
                }
                return true;
            }
        });
        ReflectionUtils.eachAnnotation(klass, View.class, new Predicate<View>(){

            @Override
            public boolean apply(View input) {
                SimpleViewGenerator.this.addView(views, input, klass);
                return true;
            }
        });
    }

    private String resolveTypeDiscriminator(Class<?> persistentType) {
        final ArrayList<String> discrimintators = new ArrayList<String>();
        TypeDiscriminator td = persistentType.getAnnotation(TypeDiscriminator.class);
        if (td != null) {
            if (td.value().length() == 0) {
                throw new ViewGenerationException(String.format("@TypeDiscriminator declared on type level must specify custom discriminator condition", persistentType));
            }
            if (this.hasTypeDiscriminatorFieldOrMethod(persistentType)) {
                throw new ViewGenerationException(String.format("@TypeDiscriminator declared on type level may not be combined with @TypeDiscriminator in fields or on methods", persistentType));
            }
            return td.value();
        }
        ReflectionUtils.eachField(persistentType, new Predicate<Field>(){

            @Override
            public boolean apply(Field input) {
                if (ReflectionUtils.hasAnnotation(input, TypeDiscriminator.class)) {
                    discrimintators.add("doc." + input.getName());
                }
                return false;
            }
        });
        ReflectionUtils.eachMethod(persistentType, new Predicate<Method>(){

            @Override
            public boolean apply(Method input) {
                if (ReflectionUtils.hasAnnotation(input, TypeDiscriminator.class)) {
                    discrimintators.add("doc." + SimpleViewGenerator.this.firstCharToLowerCase(input.getName().substring(3)));
                }
                return true;
            }
        });
        return Joiner.join(discrimintators, " && ");
    }

    private boolean hasTypeDiscriminatorFieldOrMethod(Class<?> persistentType) {
        Collection<AccessibleObject> hits = ReflectionUtils.eachField(persistentType, new Predicate<Field>(){

            @Override
            public boolean apply(Field input) {
                return ReflectionUtils.hasAnnotation(input, TypeDiscriminator.class);
            }
        });
        if (!hits.isEmpty()) {
            return true;
        }
        hits = ReflectionUtils.eachMethod(persistentType, new Predicate<Method>(){

            @Override
            public boolean apply(Method input) {
                return ReflectionUtils.hasAnnotation(input, TypeDiscriminator.class);
            }
        });
        return !hits.isEmpty();
    }

    public Map<String, DesignDocument.View> generateViewsFromPersistentType(Class<?> persistentType) {
        Assert.notNull(persistentType, "persistentType may not be null");
        final HashMap<String, DesignDocument.View> views = new HashMap<String, DesignDocument.View>();
        this.createDeclaredViews(views, persistentType);
        ReflectionUtils.eachField(persistentType, new Predicate<Field>(){

            @Override
            public boolean apply(Field input) {
                if (ReflectionUtils.hasAnnotation(input, DocumentReferences.class)) {
                    SimpleViewGenerator.this.generateView((Map<String, DesignDocument.View>)views, input);
                }
                return false;
            }
        });
        return views;
    }

    private void addView(Map<String, DesignDocument.View> views, View input, Class<?> repositoryClass) {
        if (input.file().length() > 0) {
            views.put(input.name(), this.loadViewFromFile(views, input, repositoryClass));
        } else if (this.shouldLoadFunctionFromClassPath(input.map()) || this.shouldLoadFunctionFromClassPath(input.reduce())) {
            views.put(input.name(), this.loadViewFromFile(input, repositoryClass));
        } else {
            views.put(input.name(), DesignDocument.View.of(input));
        }
    }

    public boolean shouldLoadFunctionFromClassPath(String function) {
        return function != null && function.startsWith("classpath:");
    }

    private DesignDocument.View loadViewFromFile(View input, Class<?> repositoryClass) {
        String mapPath = input.map();
        String map = this.shouldLoadFunctionFromClassPath(mapPath) ? this.loadResourceFromClasspath(repositoryClass, mapPath.substring(10)) : mapPath;
        String reducePath = input.reduce();
        String reduce = this.shouldLoadFunctionFromClassPath(reducePath) ? this.loadResourceFromClasspath(repositoryClass, reducePath.substring(10)) : (reducePath.length() > 0 ? reducePath : null);
        return new DesignDocument.View(map, reduce);
    }

    private String loadResourceFromClasspath(Class<?> repositoryClass, String path) {
        try {
            InputStream in = repositoryClass.getResourceAsStream(path);
            if (in == null) {
                throw new FileNotFoundException("Could not load view file with path: " + path);
            }
            return IOUtils.toString(in, "UTF-8");
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    private DesignDocument.View loadViewFromFile(Map<String, DesignDocument.View> views, View input, Class<?> repositoryClass) {
        try {
            String json = this.loadResourceFromClasspath(repositoryClass, input.file());
            return this.mapper().readValue(json.replaceAll("\n", ""), DesignDocument.View.class);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    private boolean isIterable(Class<?> type) {
        return Iterable.class.isAssignableFrom(type);
    }

    protected void generateView(Map<String, DesignDocument.View> views, Field f) {
        DocumentReferences referenceMetaData = f.getAnnotation(DocumentReferences.class);
        if (referenceMetaData == null) {
            LOG.warn("No DocumentReferences annotation found in field: ", (Object)f.getName());
            return;
        }
        if (referenceMetaData.view().length() > 0) {
            LOG.debug("Skipping view generation for field {} as view is already specified", (Object)f.getName());
            return;
        }
        if (!Set.class.isAssignableFrom(f.getType())) {
            throw new ViewGenerationException(String.format("The type of the field: %s in %s annotated with DocumentReferences is not supported. (Must be assignable from java.util.Set)", f.getName(), f.getDeclaringClass()));
        }
        this.generateSetBasedDocRefView(views, f, referenceMetaData);
    }

    protected void generateView(Map<String, DesignDocument.View> views, Method me) {
        DocumentReferences referenceMetaData = me.getAnnotation(DocumentReferences.class);
        if (referenceMetaData == null) {
            LOG.warn("No DocumentReferences annotation found in method: ", (Object)me.getName());
            return;
        }
        if (!me.getName().startsWith("get")) {
            throw new ViewGenerationException(String.format("The method: %s in %s annotated with DocumentReferences does not conform to the naming convention of 'getXxxx'", me.getName(), me.getDeclaringClass()));
        }
        if (!Set.class.isAssignableFrom(me.getReturnType())) {
            throw new ViewGenerationException(String.format("The return type of: %s in %s annotated with DocumentReferences is not supported. (Must be assignable from java.util.Set)", me.getName(), me.getDeclaringClass()));
        }
        this.generateSetBasedDocRefView(views, me, referenceMetaData);
    }

    private void generateSetBasedDocRefView(Map<String, DesignDocument.View> views, Member me, DocumentReferences referenceMetaData) {
        String fieldName = this.firstCharToLowerCase(me.getName());
        String orderBy = referenceMetaData.orderBy();
        String backRef = referenceMetaData.backReference();
        if (backRef.length() == 0) {
            throw new ViewGenerationException(String.format("The DocumentReferences annotation in %s must specify a backReference", me.getDeclaringClass()));
        }
        String viewName = NameConventions.backReferenceViewName(fieldName);
        String typeDiscriminator = this.resolveTypeDiscriminatorForBackReference(me);
        if (orderBy.length() > 0) {
            views.put(viewName, this.generateDocRefsAsSetWithOrderByView(backRef, fieldName, orderBy, typeDiscriminator));
        } else {
            views.put(viewName, this.generateDocRefsAsSetView(backRef, fieldName, typeDiscriminator));
        }
    }

    private String resolveTypeDiscriminatorForBackReference(Member m) {
        Method me = ReflectionUtils.findMethod(m.getDeclaringClass(), "get" + this.firstCharToUpperCase(m.getName()));
        if (me != null) {
            return this.resolveTypeDiscriminator(this.resolveReturnType(me));
        }
        return "";
    }

    private void generateView(Map<String, DesignDocument.View> views, Method me, Class<?> handledType) {
        String name = me.getName();
        if (!name.startsWith("findBy") && !name.equals("getAll")) {
            throw new ViewGenerationException(String.format("The method: %s in %s annotated with GenerateView does not conform to the naming convention of 'findByXxxx'", name, me.getDeclaringClass()));
        }
        Class<?> type = this.resolveReturnType(me);
        if (type == null) {
            if (handledType != null) {
                type = handledType;
            } else {
                throw new ViewGenerationException("Could not resolve return type for method: %s in %s", me.getName(), me.getDeclaringClass());
            }
        }
        String typeDiscriminator = this.resolveTypeDiscriminator(type);
        if (name.equals("getAll")) {
            if (typeDiscriminator.length() < 1) {
                throw new ViewGenerationException(String.format("Cannot generate 'all' view for %s. No type discriminator could be resolved. Try annotate unique field(s) with @TypeDiscriminator", type.getDeclaringClass()));
            }
            views.put("all", this.generateAllView(typeDiscriminator));
            return;
        }
        String finderName = name.substring(6);
        String fieldName = this.resolveFieldName(me, finderName);
        Method getter = ReflectionUtils.findMethod(type, "get" + fieldName);
        if (getter == null) {
            fieldName = fieldName + "s";
            getter = ReflectionUtils.findMethod(type, "get" + fieldName);
        }
        if (getter == null) {
            throw new ViewGenerationException("Could not generate view for method %s. No get method found for property %s in %s", name, name.substring(6), type);
        }
        fieldName = this.firstCharToLowerCase(fieldName);
        DesignDocument.View view = this.isIterable(getter.getReturnType()) ? this.generateFindByIterableView(fieldName, typeDiscriminator) : this.generateFindByView(fieldName, typeDiscriminator);
        views.put("by_" + this.firstCharToLowerCase(finderName), view);
    }

    private String resolveFieldName(Method me, String finderName) {
        GenerateView g = me.getAnnotation(GenerateView.class);
        String field = g.field();
        return field.length() == 0 ? finderName : g.field();
    }

    private String firstCharToLowerCase(String name) {
        return Character.toString(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    private String firstCharToUpperCase(String name) {
        return Character.toString(Character.toUpperCase(name.charAt(0))) + name.substring(1);
    }

    private Class<?> resolveReturnType(Method me) {
        Type returnType = me.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            Type[] typeArguments;
            ParameterizedType type = (ParameterizedType)returnType;
            for (Type typeArgument : typeArguments = type.getActualTypeArguments()) {
                if (!(typeArgument instanceof Class)) continue;
                return (Class)typeArgument;
            }
            return null;
        }
        return (Class)returnType;
    }

    private ObjectMapper mapper() {
        ObjectMapper mapper;
        if (this.mapperRef == null) {
            this.mapperRef = new SoftReference<ObjectMapper>(new ObjectMapper());
        }
        if ((mapper = this.mapperRef.get()) == null) {
            mapper = new ObjectMapper();
            this.mapperRef = new SoftReference<ObjectMapper>(mapper);
        }
        return mapper;
    }
}

