/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.activity.InvalidActivityException;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.exception.DuplicatedKeyFilterException;
import org.gcube.accounting.analytics.exception.KeyException;
import org.gcube.accounting.analytics.exception.ValueException;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryFactory;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.documentstore.records.AggregatedRecord;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountingPersistenceQuery
implements AccountingPersistenceBackendQuery {
    private static final AccountingPersistenceQuery accountingPersistenceQuery = new AccountingPersistenceQuery();
    public static final int DEFAULT_LIMIT_RESULT_NUMBER = 5;

    private AccountingPersistenceQuery() {
    }

    protected static synchronized AccountingPersistenceQuery getInstance() {
        return accountingPersistenceQuery;
    }

    @Deprecated
    public static SortedSet<String> getQuerableKeys(AggregatedRecord instance) throws Exception {
        return instance.getQuerableKeys();
    }

    public static SortedSet<String> getQuerableKeys(Class<? extends AggregatedRecord<?, ?>> clz) throws Exception {
        AggregatedRecord<?, ?> instance = clz.newInstance();
        return instance.getQuerableKeys();
    }

    public static String getDefaultOrderingProperties(Class<? extends AggregatedRecord<?, ?>> clz) {
        if (clz.isAssignableFrom(AggregatedStorageUsageRecord.class)) {
            return "dataVolume";
        }
        return "operationCount";
    }

    protected static JSONObject getPaddingJSONObject(Map<Calendar, Info> unpaddedResults) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (unpaddedResults.size() != 0) {
            Info auxInfo = new ArrayList<Info>(unpaddedResults.values()).get(0);
            JSONObject auxJsonObject = auxInfo.getValue();
            Iterator keys = auxJsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                jsonObject.put(key, 0);
            }
        }
        return jsonObject;
    }

    public static SortedMap<Calendar, Info> padMap(SortedMap<Calendar, Info> unpaddedData, TemporalConstraint temporalConstraint) throws Exception {
        JSONObject jsonObject = AccountingPersistenceQuery.getPaddingJSONObject(unpaddedData);
        SortedSet<Calendar> sequence = temporalConstraint.getCalendarSequence();
        for (Calendar progressTime : sequence) {
            Info info = (Info)unpaddedData.get(progressTime);
            if (info != null) continue;
            info = new Info(progressTime, jsonObject);
            unpaddedData.put(progressTime, info);
        }
        return unpaddedData;
    }

    @Override
    public SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        return this.getTimeSeries(clz, temporalConstraint, filters, false);
    }

    public SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, boolean pad) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        SortedMap<Calendar, Info> ret = AccountingPersistenceBackendQueryFactory.getInstance().getTimeSeries(clz, temporalConstraint, filters);
        if (ret == null) {
            ret = new TreeMap<Calendar, Info>();
        }
        if (pad) {
            ret = AccountingPersistenceQuery.padMap(ret, temporalConstraint);
        }
        return ret;
    }

    @Override
    public SortedMap<Calendar, Info> getNoContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        return this.getNoContextTimeSeries(clz, temporalConstraint, filters, false);
    }

    public SortedMap<Calendar, Info> getNoContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, boolean pad) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        SortedMap<Calendar, Info> ret = AccountingPersistenceBackendQueryFactory.getInstance().getNoContextTimeSeries(clz, temporalConstraint, filters);
        if (ret == null) {
            ret = new TreeMap<Calendar, Info>();
        }
        if (pad) {
            ret = AccountingPersistenceQuery.padMap(ret, temporalConstraint);
        }
        return ret;
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey, String orderingProperty, boolean pad, int limit) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        SortedMap<NumberedFilter, SortedMap<Calendar, Info>> got;
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        }
        int count = (got = AccountingPersistenceBackendQueryFactory.getInstance().getTopValues(clz, temporalConstraint, filters, topKey, orderingProperty)).size() > limit ? limit : got.size();
        NumberedFilter firstRemovalKey = null;
        for (NumberedFilter nf : got.keySet()) {
            if (--count >= 0 || limit <= 0) {
                if (!pad) continue;
                AccountingPersistenceQuery.padMap((SortedMap)got.get(nf), temporalConstraint);
                continue;
            }
            if (firstRemovalKey != null) break;
            firstRemovalKey = nf;
        }
        if (firstRemovalKey != null) {
            return got.subMap(got.firstKey(), firstRemovalKey);
        }
        return got;
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        String orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        return this.getTopValues(clz, temporalConstraint, filters, topKey, orderingProperty, false, 0);
    }

    @Override
    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey, String orderingProperty) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        return this.getTopValues(clz, temporalConstraint, filters, topKey, orderingProperty, false, 0);
    }

    public SortedSet<NumberedFilter> getNextPossibleValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        String orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        return this.getNextPossibleValues(clz, temporalConstraint, filters, key, orderingProperty);
    }

    @Override
    public SortedSet<NumberedFilter> getNextPossibleValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        return AccountingPersistenceBackendQueryFactory.getInstance().getNextPossibleValues(clz, temporalConstraint, filters, key, orderingProperty);
    }

    @Override
    public SortedSet<NumberedFilter> getNextPossibleValuesWithMap(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws Exception {
        return AccountingPersistenceBackendQueryFactory.getInstance().getNextPossibleValuesWithMap(clz, temporalConstraint, filters, key, orderingProperty);
    }

    @Override
    public void close() throws Exception {
        AccountingPersistenceBackendQueryFactory.getInstance().close();
    }

    @Override
    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        throw new InvalidActivityException();
    }

    @Override
    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key) throws Exception {
        return AccountingPersistenceBackendQueryFactory.getInstance().getFilterValues(clz, temporalConstraint, filters, key);
    }

    @Override
    public JSONObject getUsageValue(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, Filter applicant) throws Exception {
        return AccountingPersistenceBackendQueryFactory.getInstance().getUsageValue(clz, temporalConstraint, applicant);
    }

    @Override
    public List<UsageValue> getUsageValueQuotaTotal(List<UsageValue> listUsage) throws Exception {
        return AccountingPersistenceBackendQueryFactory.getInstance().getUsageValueQuotaTotal(listUsage);
    }

    @Override
    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, List<String> contexts) throws Exception {
        return AccountingPersistenceBackendQueryFactory.getInstance().getContextTimeSeries(clz, temporalConstraint, filters, contexts);
    }

    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, List<String> contexts, boolean pad) throws DuplicatedKeyFilterException, Exception {
        SortedMap<Filter, SortedMap<Calendar, Info>> got = AccountingPersistenceBackendQueryFactory.getInstance().getContextTimeSeries(clz, temporalConstraint, filters, contexts);
        int count = got.size();
        Filter firstRemovalKey = null;
        for (Filter nf : got.keySet()) {
            if (--count >= 0) {
                if (!pad) continue;
                AccountingPersistenceQuery.padMap((SortedMap)got.get(nf), temporalConstraint);
                continue;
            }
            if (firstRemovalKey != null) break;
            firstRemovalKey = nf;
        }
        if (firstRemovalKey != null) {
            return got.subMap(got.firstKey(), firstRemovalKey);
        }
        return got;
    }
}

